/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare.actions;

import docking.ActionContext;
import ghidra.app.plugin.core.functioncompare.actions.CompareFunctionsAction;
import ghidra.app.plugin.core.functionwindow.FunctionRowObject;
import ghidra.app.plugin.core.functionwindow.FunctionTableModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.util.table.GhidraTable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompareFunctionsFromFunctionTableAction
extends CompareFunctionsAction {
    public CompareFunctionsFromFunctionTableAction(PluginTool tool, String owner) {
        super(tool, owner);
    }

    public boolean isAddToPopup(ActionContext context) {
        return this.isModelSupported(context);
    }

    public boolean isValidContext(ActionContext context) {
        return this.isModelSupported(context);
    }

    @Override
    public boolean isEnabledForContext(ActionContext actionContext) {
        GhidraTable table = (GhidraTable)((Object)actionContext.getContextObject());
        int[] selectedRows = table.getSelectedRows();
        return selectedRows.length > 1;
    }

    @Override
    protected Set<Function> getSelectedFunctions(ActionContext actionContext) {
        HashSet<Function> functions = new HashSet<Function>();
        GhidraTable table = (GhidraTable)((Object)actionContext.getContextObject());
        int[] selectedRows = table.getSelectedRows();
        if (selectedRows.length == 0) {
            return Collections.emptySet();
        }
        FunctionTableModel model = (FunctionTableModel)((Object)table.getModel());
        List functionRowObjects = model.getRowObjects(selectedRows);
        for (FunctionRowObject functionRowObject : functionRowObjects) {
            Function rowFunction = functionRowObject.getFunction();
            functions.add(rowFunction);
        }
        return functions;
    }

    protected boolean isModelSupported(ActionContext context) {
        if (!(context.getContextObject() instanceof GhidraTable)) {
            return false;
        }
        GhidraTable table = (GhidraTable)((Object)context.getContextObject());
        return table.getModel() instanceof FunctionTableModel;
    }
}

