/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import docking.ActionContext;
import docking.EmptyBorderToggleButton;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.dnd.GClipboard;
import docking.widgets.EmptyBorderButton;
import generic.theme.GIcon;
import ghidra.app.plugin.core.instructionsearch.InstructionSearchPlugin;
import ghidra.app.plugin.core.instructionsearch.model.InstructionMetadata;
import ghidra.app.plugin.core.instructionsearch.model.InstructionTableDataObject;
import ghidra.app.plugin.core.instructionsearch.model.MaskContainer;
import ghidra.app.plugin.core.instructionsearch.model.OperandMetadata;
import ghidra.app.plugin.core.instructionsearch.ui.AbstractInstructionTable;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import ghidra.app.plugin.core.instructionsearch.ui.SelectionModeWidget;
import ghidra.app.plugin.core.instructionsearch.util.InstructionSearchUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import resources.Icons;

public class PreviewTable
extends AbstractInstructionTable {
    private DockingAction copyNoSpacesAction;
    private DockingAction copyInstructionAction;
    private DockingAction copyInstructionWithCommentsAction;
    private String actionMenuGroup = "aaaTableGroup";
    public static final String HEADER_COL_PREVIEW = "Search String Preview";
    private ViewType currentView = ViewType.HEX;
    private final Map<Integer, String> previewStringMap = new LinkedHashMap<Integer, String>();

    public PreviewTable(int numColumns, InstructionSearchPlugin plugin, InstructionSearchDialog dialog) {
        super(numColumns, dialog);
        this.setColumnHeaderPopupEnabled(false);
        this.createContextMenuActions();
    }

    public boolean getScrollableTracksViewportWidth() {
        int width = 0;
        for (int row = 0; row < this.getRowCount(); ++row) {
            TableCellRenderer rendererr = this.getCellRenderer(row, 0);
            Component comp = this.prepareRenderer(rendererr, row, 0);
            width = Math.max(comp.getPreferredSize().width, width);
        }
        this.setPreferredSize(new Dimension(width, this.getPreferredSize().height));
        return this.getPreferredSize().width < this.getParent().getWidth();
    }

    public void addPreviewString(String previewText, Integer index) {
        this.previewStringMap.put(index, previewText);
        this.refreshView();
    }

    public void setPreviewText(int row, String val) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            InstructionTableDataObject instrDO;
            if (!this.getColumnName(i).equals(HEADER_COL_PREVIEW) || (instrDO = this.getCellData(row, i)) == null) continue;
            instrDO.setData(val);
        }
    }

    public void buildPreviewStrings() {
        Task task = new Task("Building Preview", true, true, true){

            public void run(TaskMonitor monitor) {
                int numInstructions = PreviewTable.this.searchData.getInstructions().size();
                monitor.setMaximum((long)numInstructions);
                String valueStr = PreviewTable.this.searchData.getValueString();
                String maskStr = PreviewTable.this.searchData.getMaskString();
                int posptr = 0;
                for (int i = 0; i < numInstructions; ++i) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    monitor.incrementProgress(1L);
                    int instrSize = 0;
                    InstructionMetadata metadata = PreviewTable.this.searchData.getInstructions().get(i);
                    if (metadata != null) {
                        if (metadata.getOperands() == null || metadata.getOperands().size() == 0) {
                            MaskContainer maskContainer = metadata.getMaskContainer();
                            if (maskContainer != null && maskContainer.getValue() != null) {
                                instrSize = maskContainer.getValue().length;
                            }
                        } else if (metadata.getOperands() != null) {
                            OperandMetadata operand = metadata.getOperands().get(0);
                            if (operand == null) continue;
                            instrSize = operand.getMaskContainer().getValue().length;
                        }
                    }
                    PreviewTable.this.buildPreviewString(instrSize, valueStr, maskStr, posptr, i);
                    posptr += instrSize * 8;
                }
            }
        };
        new TaskLauncher(task, (Component)((Object)this));
    }

    @Override
    protected Object[] createColumnHeaders() {
        Object[] colsNames = new Object[this.numColumns];
        colsNames[this.numColumns - 1] = HEADER_COL_PREVIEW;
        return colsNames;
    }

    @Override
    protected JToolBar createToolbar() {
        JToolBar toolbar1 = new JToolBar();
        toolbar1.add(Box.createHorizontalGlue());
        EmptyBorderToggleButton binaryBtn = this.createBinaryViewBtn(toolbar1);
        EmptyBorderToggleButton hexBtn = this.createHexViewBtn(toolbar1);
        this.createSetViewButtonGroup(binaryBtn, hexBtn);
        toolbar1.addSeparator();
        this.createCopyBtn(toolbar1);
        toolbar1.setFloatable(false);
        return toolbar1;
    }

    @Override
    protected InstructionTableDataObject[][] createDataObjects() {
        if (this.searchData.getInstructions() == null) {
            return null;
        }
        InstructionTableDataObject[][] dataObjects = new InstructionTableDataObject[this.searchData.getInstructions().size()][this.numColumns];
        for (int mnemonic = 0; mnemonic < this.searchData.getInstructions().size(); ++mnemonic) {
            for (int col = 0; col < this.numColumns; ++col) {
                dataObjects[mnemonic][col] = new InstructionTableDataObject("", this.searchData.getInstructions().get(mnemonic).isInstruction(), AbstractInstructionTable.OperandState.PREVIEW);
            }
        }
        return dataObjects;
    }

    private void buildPreviewString(int instrSize, String valueStr, String maskStr, int posptr, int row) {
        String instrValTmp = valueStr.substring(posptr, posptr + instrSize * 8);
        String instrMaskTmp = maskStr.substring(posptr, posptr + instrSize * 8);
        String prevStr = "";
        try {
            prevStr = InstructionSearchUtils.formatSearchString(instrValTmp, instrMaskTmp);
        }
        catch (InvalidInputException e) {
            Msg.error((Object)((Object)this), (Object)("Error formatting string for preview: " + instrValTmp));
        }
        this.addPreviewString(prevStr, row);
    }

    private void createSetViewButtonGroup(EmptyBorderToggleButton binaryBtn, EmptyBorderToggleButton hexBtn) {
        ButtonGroup viewTypeGroup = new ButtonGroup();
        viewTypeGroup.add((AbstractButton)binaryBtn);
        viewTypeGroup.add((AbstractButton)hexBtn);
    }

    private void createCopyBtn(JToolBar toolbar1) {
        Icon copyIcon = Icons.COPY_ICON;
        CopyAction copyAction = new CopyAction("copy", copyIcon, "Copy the full search string to clipboard");
        EmptyBorderButton copyBtn = new EmptyBorderButton();
        copyBtn.setAction((Action)copyAction);
        copyBtn.setName("Copy Preview Button");
        copyBtn.setHideActionText(true);
        toolbar1.add((Component)copyBtn);
    }

    private EmptyBorderToggleButton createHexViewBtn(JToolBar toolbar1) {
        GIcon hexIcon = new GIcon("icon.plugin.instructiontable.hex");
        HexAction hexAction = new HexAction("hex", (Icon)hexIcon, "hex view");
        EmptyBorderToggleButton hexBtn = new EmptyBorderToggleButton();
        hexBtn.setAction((Action)hexAction);
        hexBtn.setName("Hex View Button");
        hexBtn.setHideActionText(true);
        hexBtn.setSelected(true);
        toolbar1.add((Component)hexBtn);
        return hexBtn;
    }

    private EmptyBorderToggleButton createBinaryViewBtn(JToolBar toolbar1) {
        GIcon binaryIcon = new GIcon("icon.plugin.instructiontable.binary");
        BinaryAction binaryAction = new BinaryAction("binary", (Icon)binaryIcon, "binary view");
        EmptyBorderToggleButton binaryBtn = new EmptyBorderToggleButton();
        binaryBtn.setAction((Action)binaryAction);
        binaryBtn.setName("binary view button");
        binaryBtn.setHideActionText(true);
        toolbar1.add((Component)binaryBtn);
        return binaryBtn;
    }

    private String buildSearchString() {
        StringBuilder sb = new StringBuilder();
        int previewColumnIndex = this.getPreviewColumnIndex();
        for (int j = 0; j < this.getModel().getRowCount(); ++j) {
            this.addRowToSearchString(sb, previewColumnIndex, j);
        }
        return sb.toString();
    }

    private void addRowToSearchString(StringBuilder sb, int previewColumnIndex, int j) {
        InstructionTableDataObject obj = (InstructionTableDataObject)this.getModel().getValueAt(j, previewColumnIndex);
        String preview = obj.getData();
        if (preview != null) {
            sb.append(preview);
        }
    }

    private int getPreviewColumnIndex() {
        int previewColumnIndex = 0;
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(HEADER_COL_PREVIEW)) continue;
            previewColumnIndex = i;
            break;
        }
        return previewColumnIndex;
    }

    private void refreshView() {
        for (Map.Entry<Integer, String> pair : this.previewStringMap.entrySet()) {
            Integer index = pair.getKey();
            String instr = pair.getValue();
            String previewString = "";
            switch (this.currentView) {
                case BINARY: {
                    previewString = InstructionSearchUtils.addSpaceOnByteBoundary(instr, SelectionModeWidget.InputMode.BINARY);
                    break;
                }
                case HEX: {
                    previewString = InstructionSearchUtils.toHex(instr, true).toString();
                }
            }
            this.setPreviewText(index, previewString);
        }
        this.repaint();
    }

    private void createContextMenuActions() {
        String owner = ((Object)((Object)this)).getClass().getSimpleName();
        InstructionSearchPlugin plugin = this.getPlugin();
        PluginTool tool = plugin.getTool();
        tool.setMenuGroup(new String[]{"Copy Special"}, this.actionMenuGroup, "1");
        this.createCopyNoSpacesAction(owner);
        this.copyNoSpacesAction.setPopupMenuData(new MenuData(new String[]{"Copy Special", "Selected instructions (no spaces)"}, Icons.COPY_ICON, this.actionMenuGroup, -1, Integer.toString(1)));
        this.createCopyInstructionAction(owner);
        this.copyInstructionAction.setPopupMenuData(new MenuData(new String[]{"Copy Special", "Selected Instructions"}, Icons.COPY_ICON, this.actionMenuGroup, -1, Integer.toString(1)));
        this.createCopyInstructionWithCommentsAction(owner);
        this.copyInstructionWithCommentsAction.setPopupMenuData(new MenuData(new String[]{"Copy Special", "Selected Instructions (with comments)"}, Icons.COPY_ICON, this.actionMenuGroup, -1, Integer.toString(1)));
        this.dialog.addAction((DockingActionIf)this.copyNoSpacesAction);
        this.dialog.addAction((DockingActionIf)this.copyInstructionAction);
        this.dialog.addAction((DockingActionIf)this.copyInstructionWithCommentsAction);
    }

    private void createCopyInstructionWithCommentsAction(String owner) {
        this.copyInstructionWithCommentsAction = new DockingAction("Selected Instructions (with comments)", owner){

            public void actionPerformed(ActionContext context) {
                int[] selectedRows = PreviewTable.this.getSelectedRows();
                Object val = "";
                for (int selectedRow : selectedRows) {
                    val = (String)val + PreviewTable.this.getColumnValue(selectedRow, PreviewTable.HEADER_COL_PREVIEW);
                    String comment = PreviewTable.this.searchData.getInstructions().get(selectedRow).getTextRep();
                    if (comment == null) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append((String)val).append("\t").append("// ").append(comment).append("\n");
                    val = builder.toString();
                }
                StringSelection sel = new StringSelection((String)val);
                Clipboard clip = GClipboard.getSystemClipboard();
                clip.setContents(sel, null);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context.getSourceComponent() == PreviewTable.this;
            }
        };
        this.copyInstructionWithCommentsAction.setHelpLocation(this.dialog.getHelpLocation());
    }

    private void createCopyInstructionAction(String owner) {
        this.copyInstructionAction = new DockingAction("Selected Instructions", owner){

            public void actionPerformed(ActionContext context) {
                int[] selectedRows = PreviewTable.this.getSelectedRows();
                Object val = "";
                for (int selectedRow : selectedRows) {
                    val = (String)val + PreviewTable.this.getColumnValue(selectedRow, PreviewTable.HEADER_COL_PREVIEW) + "\n";
                }
                StringSelection sel = new StringSelection((String)val);
                Clipboard clip = GClipboard.getSystemClipboard();
                clip.setContents(sel, null);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context.getSourceComponent() == PreviewTable.this;
            }
        };
        this.copyInstructionAction.setHelpLocation(this.dialog.getHelpLocation());
    }

    private void createCopyNoSpacesAction(String owner) {
        this.copyNoSpacesAction = new DockingAction("Selected instructions (no spaces)", owner){

            public void actionPerformed(ActionContext context) {
                int[] selectedRows = PreviewTable.this.getSelectedRows();
                Object val = "";
                for (int selectedRow : selectedRows) {
                    val = (String)val + PreviewTable.this.getColumnValue(selectedRow, PreviewTable.HEADER_COL_PREVIEW).replaceAll(" ", "");
                }
                StringSelection sel = new StringSelection((String)val);
                Clipboard clip = GClipboard.getSystemClipboard();
                clip.setContents(sel, null);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context.getSourceComponent() == PreviewTable.this;
            }
        };
        this.copyNoSpacesAction.setHelpLocation(this.dialog.getHelpLocation());
    }

    public static enum ViewType {
        BINARY,
        HEX;

    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringSelection sel = new StringSelection(PreviewTable.this.buildSearchString());
            Clipboard clip = GClipboard.getSystemClipboard();
            clip.setContents(sel, null);
        }
    }

    private class HexAction
    extends AbstractAction {
        public HexAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewTable.this.currentView = ViewType.HEX;
            PreviewTable.this.refreshView();
        }
    }

    private class BinaryAction
    extends AbstractAction {
        public BinaryAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewTable.this.currentView = ViewType.BINARY;
            PreviewTable.this.refreshView();
        }
    }
}

