/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import docking.DialogComponentProvider;
import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.memory.ExpandBlockModel;
import ghidra.app.plugin.core.misc.RegisterField;
import ghidra.app.util.AddressInput;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ExpandBlockDialog
extends DialogComponentProvider
implements ChangeListener {
    static final int EXPAND_UP = 0;
    static final int EXPAND_DOWN = 1;
    private static final String EXPAND_UP_TITLE = "Expand Block Up";
    private static final String EXPAND_DOWN_TITLE = "Expand Block Down";
    private int dialogType;
    private AddressFactory addrFactory;
    private AddressInput startAddressInput;
    private AddressInput endAddressInput;
    private JTextField startField;
    private JTextField endField;
    private RegisterField lengthField;
    private ExpandBlockModel model;
    private boolean isChanging;
    private PluginTool tool;

    ExpandBlockDialog(PluginTool tool, ExpandBlockModel model, MemoryBlock block, AddressFactory af, int dialogType) {
        super(dialogType == 0 ? EXPAND_UP_TITLE : EXPAND_DOWN_TITLE, true);
        this.tool = tool;
        this.model = model;
        this.dialogType = dialogType;
        this.setHelpLocation(new HelpLocation("MemoryMapPlugin", dialogType == 0 ? EXPAND_UP_TITLE : EXPAND_DOWN_TITLE));
        this.addrFactory = af;
        model.setChangeListener(this);
        this.addWorkPanel(this.create(block));
        this.addOKButton();
        this.addCancelButton();
        this.setOkEnabled(false);
        this.addListeners();
    }

    protected void okCallback() {
        Runnable doExpand = () -> {
            if (this.model.execute()) {
                this.close();
            } else {
                this.setStatusText(this.model.getMessage());
                this.setOkEnabled(false);
            }
            this.rootPanel.setCursor(Cursor.getDefaultCursor());
        };
        this.rootPanel.setCursor(Cursor.getPredefinedCursor(3));
        SwingUtilities.invokeLater(doExpand);
    }

    private JPanel create(MemoryBlock block) {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5, 150));
        this.startAddressInput = new AddressInput();
        this.startAddressInput.setName("NewStartAddress");
        this.startAddressInput.setAddressFactory(this.addrFactory);
        this.endAddressInput = new AddressInput();
        this.endAddressInput.setName("EndAddress");
        this.endAddressInput.setAddressFactory(this.addrFactory);
        Address start = block.getStart();
        Address end = block.getEnd();
        this.startAddressInput.setAddress(start);
        this.startAddressInput.setAddressSpaceEditable(false);
        this.endAddressInput.setAddress(end);
        this.endAddressInput.setAddressSpaceEditable(false);
        boolean isExpandUp = this.dialogType == 0;
        this.startField = new JTextField(10);
        this.startField.setName("StartAddress");
        this.startField.setEnabled(isExpandUp);
        this.startField.setText(start.toString());
        this.endField = new JTextField(10);
        this.endField.setName("EndAddress");
        this.endField.setEnabled(!isExpandUp);
        this.endField.setText(end.toString());
        this.lengthField = new RegisterField(32, null, false);
        this.lengthField.setName("BlockLength");
        this.lengthField.setValue(this.model.getLength());
        panel.add((Component)new GLabel(isExpandUp ? "New Start Address:" : "Start Address:", 4));
        panel.add(isExpandUp ? this.startAddressInput : this.startField);
        panel.add((Component)new GLabel(isExpandUp ? "End Address:" : "New End Address:", 4));
        panel.add(isExpandUp ? this.endField : this.endAddressInput);
        panel.add((Component)new GLabel("Block Length:", 4));
        panel.add(this.lengthField);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)panel, "Center");
        return mainPanel;
    }

    private void addListeners() {
        this.startAddressInput.addChangeListener(new AddressChangeListener());
        this.endAddressInput.addChangeListener(new AddressChangeListener());
        this.lengthField.setChangeListener(new LengthChangeListener());
        ActionListener al = e -> this.setStatusText("");
        this.startField.addActionListener(al);
        this.endField.addActionListener(al);
        this.lengthField.addActionListener(al);
        this.startAddressInput.addActionListener(al);
        this.endAddressInput.addActionListener(al);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        String message = this.model.getMessage();
        this.setStatusText(message);
        this.setOkEnabled(message.length() == 0);
        this.lengthField.setValue(this.model.getLength());
        Address startAddr = this.model.getStartAddress();
        Address endAddr = this.model.getEndAddress();
        this.isChanging = true;
        if (this.dialogType == 0 && startAddr != null) {
            this.startAddressInput.setAddress(startAddr);
        } else if (endAddr != null) {
            this.endAddressInput.setAddress(endAddr);
        }
        this.isChanging = false;
        if (!this.isVisible()) {
            this.setOkEnabled(false);
            this.tool.showDialog((DialogComponentProvider)this);
            this.model.dispose();
        }
    }

    private class AddressChangeListener
    implements ChangeListener {
        private AddressChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            if (ExpandBlockDialog.this.isChanging) {
                return;
            }
            ExpandBlockDialog.this.setStatusText("");
            this.addressChanged();
        }

        private void addressChanged() {
            if (ExpandBlockDialog.this.dialogType == 0) {
                Address startAddr = ExpandBlockDialog.this.startAddressInput.getAddress();
                if (startAddr == null) {
                    if (ExpandBlockDialog.this.startAddressInput.hasInput()) {
                        ExpandBlockDialog.this.setStatusText("Invalid Address");
                    }
                    ExpandBlockDialog.this.setOkEnabled(false);
                }
                ExpandBlockDialog.this.model.setStartAddress(startAddr);
            } else {
                Address endAddr = ExpandBlockDialog.this.endAddressInput.getAddress();
                if (endAddr == null) {
                    if (ExpandBlockDialog.this.endAddressInput.hasInput()) {
                        ExpandBlockDialog.this.setStatusText("Invalid Address");
                    }
                    ExpandBlockDialog.this.setOkEnabled(false);
                }
                ExpandBlockDialog.this.model.setEndAddress(endAddr);
            }
        }
    }

    private class LengthChangeListener
    implements ChangeListener {
        private LengthChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ExpandBlockDialog.this.isChanging) {
                return;
            }
            ExpandBlockDialog.this.setStatusText("");
            this.lengthChanged();
        }

        private void lengthChanged() {
            long length = 0L;
            Long val = ExpandBlockDialog.this.lengthField.getValue();
            if (val == null) {
                ExpandBlockDialog.this.setOkEnabled(false);
            } else {
                length = val;
            }
            ExpandBlockDialog.this.model.setLength(length);
        }
    }
}

