/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.table.GBooleanCellRenderer;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.GTableTextCellEditor;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.SelectionManager;
import docking.widgets.textfield.GValidatedTextField;
import generic.theme.GIcon;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.memory.AddBlockDialog;
import ghidra.app.plugin.core.memory.AddBlockModel;
import ghidra.app.plugin.core.memory.ExpandBlockDialog;
import ghidra.app.plugin.core.memory.ExpandBlockDownModel;
import ghidra.app.plugin.core.memory.ExpandBlockModel;
import ghidra.app.plugin.core.memory.ExpandBlockUpModel;
import ghidra.app.plugin.core.memory.ImageBaseDialog;
import ghidra.app.plugin.core.memory.MemoryMapManager;
import ghidra.app.plugin.core.memory.MemoryMapModel;
import ghidra.app.plugin.core.memory.MemoryMapPlugin;
import ghidra.app.plugin.core.memory.MoveBlockDialog;
import ghidra.app.plugin.core.memory.MoveBlockModel;
import ghidra.app.plugin.core.memory.SplitBlockDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.UsrException;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class MemoryMapProvider
extends ComponentProviderAdapter {
    private static final int MAX_SIZE = 256;
    private JPanel mainPanel;
    private MemoryMapModel tableModel;
    private GhidraTable table;
    private GTableFilterPanel<MemoryBlock> filterPanel;
    private DockingAction addAction;
    private DockingAction moveAction;
    private DockingAction splitAction;
    private DockingAction expandUpAction;
    private DockingAction expandDownAction;
    private DockingAction mergeAction;
    private DockingAction deleteAction;
    private DockingAction setBaseAction;
    private MemoryMapPlugin plugin = null;
    private Program program;
    private MemoryMapManager memManager;

    MemoryMapProvider(MemoryMapPlugin plugin) {
        super(plugin.getTool(), "Memory Map", plugin.getName(), ProgramActionContext.class);
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation(plugin.getName(), this.getName()));
        this.memManager = plugin.getMemoryMapManager();
        this.setIcon((Icon)new GIcon("icon.plugin.memorymap.provider"));
        this.addToToolbar();
        this.mainPanel = this.buildMainPanel();
        this.addToTool();
        this.addLocalActions();
    }

    public void componentShown() {
        this.updateMap();
        this.contextChanged();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.program == null) {
            return null;
        }
        return new ProgramActionContext((ComponentProvider)this, this.program, (Component)((Object)this.table));
    }

    void setStatusText(String msg) {
        this.tool.setStatusInfo(msg);
    }

    void dispose() {
        this.removeFromTool();
        this.filterPanel.dispose();
        this.plugin = null;
        this.program = null;
        this.tool = null;
    }

    void setProgram(Program program) {
        this.program = program;
        this.updateProgram(program);
        this.arrangeTable();
    }

    MemoryMapManager getMemoryMapManager() {
        return this.memManager;
    }

    private JPanel buildMainPanel() {
        JPanel memPanel = new JPanel(new BorderLayout());
        this.tableModel = new MemoryMapModel(this, null);
        this.table = new MemoryMapTable((TableModel)((Object)this.tableModel));
        this.filterPanel = new GhidraTableFilterPanel<MemoryBlock>((JTable)((Object)this.table), (RowObjectTableModel<MemoryBlock>)this.tableModel);
        this.table.installNavigation((ServiceProvider)this.tool);
        this.table.setAutoCreateColumnsFromModel(false);
        GTableCellRenderer monoRenderer = new GTableCellRenderer();
        monoRenderer.setFont(monoRenderer.getFixedWidthFont());
        TableColumn column = this.table.getColumn("Start");
        column.setCellRenderer((TableCellRenderer)monoRenderer);
        column = this.table.getColumn("End");
        column.setCellRenderer((TableCellRenderer)monoRenderer);
        column = this.table.getColumn("Length");
        column.setCellRenderer((TableCellRenderer)monoRenderer);
        column = this.table.getColumn("R");
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
        column = this.table.getColumn("W");
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
        column = this.table.getColumn("X");
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
        column = this.table.getColumn("Volatile");
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
        column = this.table.getColumn("Initialized");
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
        this.table.setDefaultEditor(String.class, (TableCellEditor)new GTableTextCellEditor((JTextField)new GValidatedTextField.MaxLengthField(256)));
        this.table.setPreferredScrollableViewportSize(new Dimension(700, 105));
        this.table.addMouseListener(new MouseHandler());
        this.table.addKeyListener(new KeyHandler());
        this.table.setSelectionMode(2);
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel model = (ListSelectionModel)e.getSource();
            this.enableOptions(model);
            this.contextChanged();
        });
        memPanel.add((Component)new JScrollPane((Component)((Object)this.table)), "Center");
        memPanel.add((Component)this.filterPanel, "South");
        return memPanel;
    }

    private boolean canRenameOverlaySpace(ActionContext context) {
        if (context.getContextObject() != this.getTable()) {
            return false;
        }
        MemoryBlock block = this.getSelectedBlock();
        return block != null && block.isOverlay();
    }

    private void addLocalActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Rename Overlay Space", this.plugin.getName()).helpLocation(new HelpLocation("MemoryMapPlugin", "OverlaySpaceRename"))).popupMenuPath(new String[]{"Rename Overlay Space"})).enabledWhen(c -> this.canRenameOverlaySpace((ActionContext)c))).onAction(c -> this.renameOverlaySpace((ActionContext)c))).buildAndInstallLocal((ComponentProvider)this);
        GIcon addImage = new GIcon("icon.plugin.memorymap.add");
        this.addAction = new MemoryMapAction("Add Block", (Icon)addImage){

            public void actionPerformed(ActionContext context) {
                if (MemoryMapProvider.this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.showAddBlockDialog();
                }
            }
        };
        this.addAction.setEnabled(false);
        this.addAction.setDescription("Add a new block to memory");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.addAction);
        GIcon moveImage = new GIcon("icon.plugin.memorymap.move");
        this.moveAction = new MemoryMapAction("Move Block", (Icon)moveImage){

            public void actionPerformed(ActionContext context) {
                if (MemoryMapProvider.this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.moveBlock();
                }
            }
        };
        this.moveAction.setEnabled(false);
        this.moveAction.setDescription("Move a block to another address");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.moveAction);
        GIcon splitImage = new GIcon("icon.plugin.memorymap.split");
        this.splitAction = new MemoryMapAction("Split Block", (Icon)splitImage){

            public void actionPerformed(ActionContext context) {
                if (MemoryMapProvider.this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.splitBlock();
                }
            }
        };
        this.splitAction.setEnabled(false);
        this.splitAction.setDescription("Split a block");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.splitAction);
        GIcon expandUpImage = new GIcon("icon.plugin.memorymap.expand.up");
        this.expandUpAction = new MemoryMapAction("Expand Block Up", (Icon)expandUpImage){

            public void actionPerformed(ActionContext context) {
                if (MemoryMapProvider.this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.expandBlock(0);
                }
            }
        };
        this.expandUpAction.setEnabled(false);
        this.expandUpAction.setDescription("Expand block by setting new start address");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.expandUpAction);
        GIcon expandDownImage = new GIcon("icon.plugin.memorymap.expand.down");
        this.expandDownAction = new MemoryMapAction("Expand Block Down", (Icon)expandDownImage){

            public void actionPerformed(ActionContext context) {
                if (MemoryMapProvider.this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.expandBlock(1);
                }
            }
        };
        this.expandDownAction.setEnabled(false);
        this.expandDownAction.setDescription("Expand block by setting new end address");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.expandDownAction);
        GIcon mergeImage = new GIcon("icon.plugin.memorymap.merge");
        this.mergeAction = new MemoryMapAction("Merge Blocks", (Icon)mergeImage){

            public void actionPerformed(ActionContext context) {
                if (MemoryMapProvider.this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.mergeBlocks();
                }
            }
        };
        this.mergeAction.setEnabled(false);
        this.mergeAction.setDescription("Merge blocks into a single block");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.mergeAction);
        GIcon deleteImage = new GIcon("icon.plugin.memorymap.delete");
        this.deleteAction = new MemoryMapAction("Delete Block", (Icon)deleteImage){

            public void actionPerformed(ActionContext context) {
                if (MemoryMapProvider.this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.deleteBlocks();
                }
            }
        };
        this.deleteAction.setEnabled(false);
        this.deleteAction.setDescription("Delete a block");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.deleteAction);
        GIcon setBaseIcon = new GIcon("icon.plugin.memorymap.image.base");
        this.setBaseAction = new MemoryMapAction("Set Image Base", (Icon)setBaseIcon){

            public void actionPerformed(ActionContext context) {
                if (MemoryMapProvider.this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.setBase();
                }
            }
        };
        this.setBaseAction.setEnabled(false);
        this.setBaseAction.setDescription("Set Image Base");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.setBaseAction);
        MakeProgramSelectionAction action = new MakeProgramSelectionAction(this.plugin, this.table);
        action.getToolBarData().setToolBarGroup("B");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)action);
    }

    private boolean checkExclusiveAccess() {
        if (this.program.hasExclusiveAccess()) {
            return true;
        }
        String msg = "Close the file and undo your checkout,\nthen do a checkout with the exclusive lock.";
        DomainFile df = this.program.getDomainFile();
        if (df.modifiedSinceCheckout() || df.isChanged()) {
            msg = "Check in this file, then do a checkout with the\nexclusive lock.";
        }
        Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Exclusive Checkout Required", (Object)("An exclusive checkout is required in order to\nmanipulate memory blocks or change the image base.\n" + msg));
        return false;
    }

    private void setBase() {
        ImageBaseDialog dialog = new ImageBaseDialog(this.tool, this.program, this.program.getImageBase());
        this.tool.showDialog((DialogComponentProvider)dialog, (ComponentProvider)this);
        dialog.dispose();
    }

    private void enableOptions(ListSelectionModel lsm) {
        int numSelected = 0;
        numSelected = lsm == null || lsm.isSelectionEmpty() ? 0 : (lsm.getMinSelectionIndex() == lsm.getMaxSelectionIndex() ? 1 : 2);
        this.addAction.setEnabled(true);
        this.moveAction.setEnabled(numSelected == 1);
        this.enableSplitAction(numSelected);
        this.enableExpandActions(numSelected);
        this.mergeAction.setEnabled(numSelected > 1);
        this.deleteAction.setEnabled(numSelected >= 1);
    }

    private void enableSplitAction(int numSelected) {
        if (numSelected != 1) {
            this.splitAction.setEnabled(false);
        } else {
            MemoryBlock block = this.getSelectedBlock();
            this.splitAction.setEnabled(block.getType() == MemoryBlockType.DEFAULT);
        }
    }

    private void enableExpandActions(int numSelected) {
        if (numSelected != 1) {
            this.expandUpAction.setEnabled(false);
            this.expandDownAction.setEnabled(false);
        } else {
            MemoryBlock block = this.getSelectedBlock();
            if (block.getType() != MemoryBlockType.DEFAULT) {
                this.expandDownAction.setEnabled(false);
                this.expandUpAction.setEnabled(false);
                return;
            }
            if (block.getStart().getOffset() == 0L) {
                this.expandUpAction.setEnabled(false);
            } else {
                this.expandUpAction.setEnabled(true);
            }
            Address endAddr = block.getEnd();
            if (endAddr.equals((Object)endAddr.getAddressSpace().getMaxAddress())) {
                this.expandDownAction.setEnabled(false);
            } else {
                this.expandDownAction.setEnabled(true);
            }
        }
    }

    JTable getTable() {
        return this.table;
    }

    void updateMap() {
        if (this.isVisible()) {
            this.tableModel.update();
            this.arrangeTable();
            this.updateTitle();
        }
    }

    void updateData() {
        if (this.isVisible()) {
            this.updateTitle();
            this.table.repaint();
        }
    }

    private void updateTitle() {
        if (this.program != null) {
            this.setSubTitle("Image Base: " + this.program.getImageBase().toString());
        }
    }

    private void updateProgram(Program updatedProgram) {
        this.enableOptions(null);
        if (updatedProgram == null) {
            this.addAction.setEnabled(false);
            this.setBaseAction.setEnabled(false);
        } else {
            this.setBaseAction.setEnabled(true);
        }
        this.tableModel.setProgram(updatedProgram);
        this.updateTitle();
    }

    private void arrangeTable() {
        TableColumn column = this.table.getColumn("R");
        if (column != null) {
            column.setMaxWidth(25);
            column.setMinWidth(25);
            column.setResizable(false);
        }
        if ((column = this.table.getColumn("W")) != null) {
            column.setMaxWidth(25);
            column.setMinWidth(25);
            column.setResizable(false);
        }
        if ((column = this.table.getColumn("X")) != null) {
            column.setMaxWidth(25);
            column.setMinWidth(25);
            column.setResizable(false);
        }
        if ((column = this.table.getColumn("Volatile")) != null) {
            column.setMaxWidth(65);
            column.setMinWidth(65);
            column.setResizable(false);
        }
        if ((column = this.table.getColumn("Type")) != null) {
            column.setMinWidth(25);
        }
        if ((column = this.table.getColumn("Initialized")) != null) {
            column.setMaxWidth(25);
            column.setMinWidth(25);
            column.setResizable(false);
        }
    }

    private void navigateToAddress() {
        int viewRow = this.table.getSelectedRow();
        int viewColumn = this.table.getSelectedColumn();
        int modelColumn = this.table.convertColumnIndexToModel(viewColumn);
        MemoryBlock block = this.tableModel.getBlockAt(viewRow);
        if (block != null && (modelColumn == 1 || modelColumn == 2)) {
            Address addr = modelColumn == 1 ? block.getStart() : block.getEnd();
            this.plugin.blockSelected(block, addr);
            this.table.setRowSelectionInterval(viewRow, viewRow);
        }
    }

    private MemoryBlock getSelectedBlock() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.tableModel.getBlockAt(row);
    }

    private void renameOverlaySpace(ActionContext c) {
        if (!this.checkExclusiveAccess()) {
            return;
        }
        if (!this.program.canLock()) {
            this.setStatusText("Program is busy, try again later");
            return;
        }
        MemoryBlock block = this.getSelectedBlock();
        if (block == null || !block.isOverlay()) {
            return;
        }
        OverlayAddressSpace overlaySpace = (OverlayAddressSpace)block.getStart().getAddressSpace();
        String oldName = overlaySpace.getName();
        String newName = OptionDialog.showInputSingleLineDialog((Component)this.getComponent(), (String)"Rename Overlay Space", (String)"New Name:", (String)oldName);
        if (newName == null || oldName.equals(newName)) {
            return;
        }
        try {
            this.program.withTransaction("Rename Overlay Space: " + oldName, () -> this.program.renameOverlaySpace(oldName, newName));
        }
        catch (UsrException e) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Rename Overlay Error", (Object)e.getMessage());
        }
    }

    private void deleteBlocks() {
        int[] delRows;
        if (!this.program.canLock()) {
            this.setStatusText("Program is busy, try again later");
            return;
        }
        ArrayList<MemoryBlock> delBlocks = new ArrayList<MemoryBlock>();
        for (int element : delRows = this.table.getSelectedRows()) {
            MemoryBlock block = this.tableModel.getBlockAt(element);
            delBlocks.add(block);
        }
        this.table.clearSelection();
        this.deleteBlock(delBlocks);
    }

    private void deleteBlock(ArrayList<MemoryBlock> blocks) {
        this.memManager.deleteBlocks(blocks);
    }

    private void expandBlock(int dialogType) {
        int choice;
        int sourceIndex;
        MemoryBlock block = this.getSelectedBlock();
        if (block == null) {
            return;
        }
        List sourceInfos = block.getSourceInfos();
        MemoryBlockSourceInfo sourceInfo = (MemoryBlockSourceInfo)sourceInfos.get(sourceIndex = dialogType == 0 ? 0 : sourceInfos.size() - 1);
        if (sourceInfo.getFileBytes().isPresent() && (choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton((Component)this.getComponent(), (String)"Expanding File Bytes Block", (String)"Block use of File Bytes will be expanded with a 0-filled region.  Continue?", (String)"Continue...")) != 1) {
            return;
        }
        this.showExpandBlockDialog(dialogType, block);
    }

    private void moveBlock() {
        if (!this.program.canLock()) {
            this.setStatusText("Program is busy, try again later");
            return;
        }
        MemoryBlock block = this.getSelectedBlock();
        if (block == null) {
            return;
        }
        if (block.isOverlay() && block.getStart().isNonLoadedMemoryAddress()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Moving OTHER Overlay Block Not Allowed", (Object)"OTHER overlay blocks cannot be moved.");
        } else {
            this.showMoveBlockDialog(block);
        }
    }

    private void splitBlock() {
        MemoryBlock block = this.getSelectedBlock();
        if (block == null) {
            return;
        }
        if (block.isOverlay() && block.getStart().isNonLoadedMemoryAddress()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Split OTHER Overlay Block Not Allowed", (Object)"OTHER overlay blocks can not be split.");
        } else {
            SplitBlockDialog d = new SplitBlockDialog(this.plugin, block, this.program.getAddressFactory());
            this.tool.showDialog((DialogComponentProvider)d, (ComponentProvider)this);
        }
    }

    private void showExpandBlockDialog(int dialogType, MemoryBlock block) {
        ExpandBlockModel model = dialogType == 0 ? new ExpandBlockUpModel(this.tool, this.program) : new ExpandBlockDownModel(this.tool, this.program);
        ExpandBlockDialog dialog = new ExpandBlockDialog(this.tool, model, block, this.program.getAddressFactory(), dialogType);
        model.initialize(block);
        dialog.dispose();
    }

    private void showMoveBlockDialog(MemoryBlock block) {
        MoveBlockModel model = new MoveBlockModel(this.program);
        new MoveBlockDialog(model, this.tool);
        model.initialize(block);
    }

    private void mergeBlocks() {
        int[] rows;
        ArrayList<MemoryBlock> blocks = new ArrayList<MemoryBlock>();
        for (int element : rows = this.table.getSelectedRows()) {
            MemoryBlock block = this.tableModel.getBlockAt(element);
            blocks.add(block);
        }
        this.table.clearSelection();
        this.memManager.mergeBlocks(blocks);
    }

    void setCursor(Cursor cursor) {
        this.tool.getToolFrame().setCursor(cursor);
    }

    void showAddBlockDialog() {
        AddBlockModel model = new AddBlockModel(this.tool, this.program);
        AddBlockDialog d = new AddBlockDialog(model);
        d.showDialog(this.tool);
    }

    public PluginTool getTool() {
        return this.plugin.getTool();
    }

    private class MemoryMapTable
    extends GhidraTable {
        MemoryMapTable(TableModel model) {
            super(model);
            this.setAutoEditEnabled(true);
            this.setActionsEnabled(true);
            this.setVisibleRowCount(10);
        }

        protected <T> SelectionManager createSelectionManager() {
            return null;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MemoryMapProvider.this.setStatusText("");
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MemoryMapProvider.this.setStatusText("");
            if (!e.isPopupTrigger() && (e.getModifiersEx() & 0xC0) == 0) {
                MemoryMapProvider.this.navigateToAddress();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MemoryMapProvider.this.setStatusText("");
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                MemoryMapProvider.this.navigateToAddress();
                e.consume();
            }
        }
    }

    private abstract class MemoryMapAction
    extends DockingAction {
        MemoryMapAction(String name, Icon icon) {
            super(name, MemoryMapProvider.this.plugin.getName());
            this.setToolBarData(new ToolBarData(icon, "A"));
        }
    }
}

