/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.FieldUtils;
import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.LabelFieldFactory;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;

class OperandLocationDescriptor
extends LocationDescriptor {
    OperandLocationDescriptor(ProgramLocation location, Program program) {
        super(location, program);
        this.program = program;
        if (location == null) {
            throw new NullPointerException("Cannot create a LocationDescriptor from a null ProgramLocation");
        }
        if (!(location instanceof OperandFieldLocation)) {
            throw new AssertException("Unexpected ProgramLocation type - Cannot create a LocationDescriptor for type: " + location);
        }
        OperandFieldLocation operandLocation = (OperandFieldLocation)location;
        this.homeAddress = operandLocation.getRefAddress();
        this.label = this.getLabelForAddress(operandLocation);
    }

    private String getLabelForAddress(OperandFieldLocation location) {
        int operandIndex = location.getOperandIndex();
        ReferenceManager referenceManager = this.program.getReferenceManager();
        Address address = location.getAddress();
        Reference ref = referenceManager.getReference(address, this.homeAddress, operandIndex);
        SymbolTable symbolTable = this.program.getSymbolTable();
        Symbol symbol = symbolTable.getSymbol(ref);
        if (symbol != null) {
            return symbol.getName(false);
        }
        return FieldUtils.trimString((String)location.getOperandRepresentation());
    }

    @Override
    protected void doGetReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        ReferenceUtils.getReferences(accumulator, this.getHomeLocation(), monitor);
    }

    @Override
    Highlight[] getHighlights(String text, Object object, Class<? extends FieldFactory> fieldFactoryClass, Color highlightColor) {
        int offset;
        Address currentAddress = this.getAddressForHighlightObject(object);
        if (!this.isInAddresses(currentAddress)) {
            return this.EMPTY_HIGHLIGHTS;
        }
        if (OperandFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
            int offset2 = text.indexOf(this.label);
            if (offset2 >= 0) {
                return new Highlight[]{new Highlight(offset2, this.label.length() + offset2 - 1, highlightColor)};
            }
        } else if (LabelFieldFactory.class.isAssignableFrom(fieldFactoryClass) && currentAddress.equals((Object)this.homeAddress) && (offset = text.indexOf(this.label)) != -1) {
            return new Highlight[]{new Highlight(offset, this.label.length() + offset - 1, highlightColor)};
        }
        return this.EMPTY_HIGHLIGHTS;
    }
}

