/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.table.GBooleanCellRenderer;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.references.EditReferencesModel;
import ghidra.app.plugin.core.references.InstructionPanel;
import ghidra.app.plugin.core.references.InstructionPanelListener;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.app.util.SelectionTransferData;
import ghidra.app.util.SelectionTransferable;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import resources.Icons;

public class EditReferencesProvider
extends ComponentProviderAdapter
implements DomainObjectListener,
ChangeListener {
    private static final String ADD_REFS_GROUP = "AddReferences";
    private static final HelpLocation HELP = new HelpLocation("ReferencesPlugin", "View_Edit_References_From");
    private static final Icon ADD_ICON = Icons.ADD_ICON;
    private static final Icon EDIT_ICON = new GIcon("icon.base.edit.bytes");
    private static final Icon DELETE_ICON = Icons.DELETE_ICON;
    private static final Icon RECV_LOCATION_ICON = Icons.NAVIGATE_ON_INCOMING_EVENT_ICON;
    private static final Icon SEND_LOCATION_ICON = Icons.NAVIGATE_ON_OUTGOING_EVENT_ICON;
    private static final Icon HOME_ICON = Icons.HOME_ICON;
    private static final Icon SELECT_ICON = Icons.MAKE_SELECTION_ICON;
    private static final String TITLE_PREFIX = "References Editor ";
    static int MNEMONIC_OPINDEX = -1;
    static Color BG_COLOR_ACTIVE_OPERAND = new GColor("color.bg.plugin.references.table.active.operand");
    private static final DataFlavor[] ACCEPTABLE_DROP_FLAVORS = new DataFlavor[]{SelectionTransferable.localProgramSelectionFlavor};
    private ReferencesPlugin plugin;
    private SwingUpdateManager updateMgr;
    private CodeUnit currentCodeUnit;
    private Program currentProgram;
    private ProgramLocation currentLocation;
    private JPanel panel;
    private InstructionPanel instrPanel;
    private GhidraTable refsTable;
    private DropTarget tableDropTarget;
    private DropTarget scrollPaneDropTarget;
    private EditReferencesModel tableModel;
    private boolean selectionBusy;
    private DockingAction addRefAction;
    private DockingAction editRefAction;
    private DockingAction deleteRefAction;
    private ToggleDockingAction followLocationToggleAction;
    private ToggleDockingAction gotoReferenceLocationToggleAction;
    private DockingAction goHomeAction;
    private DockingAction selectAction;
    private ProgramLocation initLocation;
    private DropTgtAdapter dropTargetAdapter;
    private Droppable dropHandler = new Droppable(){

        public void dragUnderFeedback(boolean ok, DropTargetDragEvent e) {
        }

        public boolean isDropOk(DropTargetDragEvent e) {
            if (EditReferencesProvider.this.currentCodeUnit != null) {
                Memory memory = EditReferencesProvider.this.currentCodeUnit.getProgram().getMemory();
                try {
                    Object data = e.getTransferable().getTransferData(SelectionTransferable.localProgramSelectionFlavor);
                    AddressSetView view = ((SelectionTransferData)data).getAddressSet();
                    if (memory.contains(view)) {
                        return true;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        public void undoDragUnderFeedback() {
        }

        public void add(Object obj, DropTargetDropEvent e, DataFlavor f) {
            AddressSetView view = ((SelectionTransferData)obj).getAddressSet();
            if (view.getNumAddressRanges() == 0) {
                return;
            }
            EditReferencesProvider.this.plugin.addMemoryReferences(EditReferencesProvider.this.panel, view, EditReferencesProvider.this.currentCodeUnit, EditReferencesProvider.this.instrPanel.getSelectedOpIndex(), true);
        }
    };

    EditReferencesProvider(ReferencesPlugin plugin) {
        super(plugin.getTool(), TITLE_PREFIX, plugin.getName());
        this.plugin = plugin;
        this.tableModel = new EditReferencesModel(plugin);
        this.setHelpLocation(HELP);
        this.updateMgr = new SwingUpdateManager(100, 2000, () -> this.doUpdate());
        this.setTransient();
        this.setWindowMenuGroup(TITLE_PREFIX);
        this.tool.addComponentProvider((ComponentProvider)this, false);
    }

    private void setupActions() {
        this.addRefAction = new DockingAction("Add Reference", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EditReferencesProvider.this.addCallback();
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        this.addRefAction.setDescription("Add forward reference");
        this.addRefAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(155, 0)));
        this.addRefAction.setPopupMenuData(new MenuData(new String[]{"Add..."}, ADD_ICON, ADD_REFS_GROUP));
        this.addRefAction.setToolBarData(new ToolBarData(ADD_ICON, "EditAction"));
        this.addRefAction.setEnabled(true);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.addRefAction);
        this.deleteRefAction = new DockingAction("Delete References", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EditReferencesProvider.this.deleteCallback();
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        this.deleteRefAction.setDescription("Delete references");
        this.deleteRefAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(127, 0)));
        this.deleteRefAction.setPopupMenuData(new MenuData(new String[]{"Delete..."}, DELETE_ICON, ADD_REFS_GROUP));
        this.deleteRefAction.setToolBarData(new ToolBarData(DELETE_ICON, "EditAction"));
        this.deleteRefAction.setEnabled(false);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.deleteRefAction);
        this.editRefAction = new DockingAction("Edit Reference", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EditReferencesProvider.this.editCallback();
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        this.editRefAction.setDescription("Edit reference");
        this.editRefAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(10, 0)));
        this.editRefAction.setPopupMenuData(new MenuData(new String[]{"Edit..."}, EDIT_ICON, ADD_REFS_GROUP));
        this.editRefAction.setToolBarData(new ToolBarData(EDIT_ICON, "EditAction"));
        this.editRefAction.setEnabled(false);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.editRefAction);
        this.selectAction = new DockingAction("Select Destinations", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                if (EditReferencesProvider.this.currentProgram != null) {
                    EditReferencesProvider.this.selectReferenceLocations();
                }
            }
        };
        this.selectAction.setDescription("Select reference destinations");
        this.selectAction.setToolBarData(new ToolBarData(SELECT_ICON, "NavAction"));
        this.selectAction.setEnabled(true);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.selectAction);
        this.followLocationToggleAction = new ToggleDockingAction("Follow location changes", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EditReferencesProvider.this.enableFollowLocation(EditReferencesProvider.this.followLocationToggleAction.isSelected());
            }
        };
        this.followLocationToggleAction.setEnabled(true);
        this.followLocationToggleAction.setToolBarData(new ToolBarData(RECV_LOCATION_ICON, "NavAction"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.followLocationToggleAction);
        this.gotoReferenceLocationToggleAction = new ToggleDockingAction("GoTo selected destination", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EditReferencesProvider.this.enableGotoReferenceLocation(EditReferencesProvider.this.gotoReferenceLocationToggleAction.isSelected());
            }
        };
        this.gotoReferenceLocationToggleAction.setToolBarData(new ToolBarData(SEND_LOCATION_ICON, "NavAction"));
        this.gotoReferenceLocationToggleAction.setEnabled(true);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.gotoReferenceLocationToggleAction);
        this.goHomeAction = new DockingAction("GoTo source location", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                if (EditReferencesProvider.this.currentProgram != null) {
                    EditReferencesProvider.this.plugin.goTo(EditReferencesProvider.this.currentProgram, EditReferencesProvider.this.currentLocation);
                }
            }
        };
        this.goHomeAction.setToolBarData(new ToolBarData(HOME_ICON, "NavAction"));
        this.goHomeAction.setDescription("GoTo reference source location");
        this.goHomeAction.setEnabled(true);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.goHomeAction);
        this.enableGotoReferenceLocation(this.plugin.getDefaultGotoReferenceLocation());
        this.enableFollowLocation(this.plugin.getDefaultFollowOnLocation());
    }

    private String generateTitle() {
        String suffix = this.currentCodeUnit != null ? "@ " + this.currentCodeUnit.getMinAddress() + "  (" + this.currentProgram.getDomainFile().getName() + ")" : "";
        return TITLE_PREFIX + suffix;
    }

    private void selectReferenceLocations() {
        int[] selRows;
        AddressSet set = new AddressSet();
        for (int selRow : selRows = this.refsTable.getSelectedRows()) {
            Reference ref = this.tableModel.getReference(selRow);
            Address addr = ref.getToAddress();
            if (!addr.isMemoryAddress()) continue;
            set.addRange(addr, addr);
        }
        ProgramSelection sel = new ProgramSelection((AddressSetView)set);
        this.plugin.firePluginEvent(new ProgramSelectionPluginEvent(this.plugin.getName(), sel, this.currentProgram));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doUpdate() {
        if (this.currentProgram == null) {
            return;
        }
        CodeUnit cu = this.getCurrentCodeUnit(this.currentProgram);
        if (cu == null) {
            this.show(null, null);
        } else {
            this.selectionBusy = true;
            try {
                int[] selRows = this.refsTable.getSelectedRows();
                ArrayList<Reference> selRefList = new ArrayList<Reference>();
                for (int row : selRows) {
                    selRefList.add(this.tableModel.getReference(row));
                }
                int opIndex = this.instrPanel.getSelectedOpIndex();
                int subIndex = this.instrPanel.getSelectedSubOpIndex();
                this.currentCodeUnit = cu;
                int opCnt = cu.getNumOperands();
                if (opIndex >= opCnt) {
                    opIndex = opCnt > 0 ? 0 : MNEMONIC_OPINDEX;
                    subIndex = -1;
                }
                this.init(opIndex, subIndex);
                if (!selRefList.isEmpty()) {
                    ListSelectionModel selModel = this.refsTable.getSelectionModel();
                    for (Reference ref : selRefList) {
                        int row = this.tableModel.getRow(ref);
                        if (row == -1) continue;
                        selModel.addSelectionInterval(row, row);
                    }
                }
            }
            finally {
                this.selectionBusy = false;
            }
        }
    }

    public synchronized void dispose() {
        this.updateMgr.dispose();
        if (this.plugin != null) {
            this.tool.removeComponentProvider((ComponentProvider)this);
            this.plugin = null;
        }
        this.clearProgramState();
        if (this.tableModel != null) {
            this.tableModel.setCodeUnitLocation(null);
            this.tableModel = null;
        }
        this.refsTable.dispose();
        if (this.instrPanel != null) {
            this.instrPanel.setCodeUnitLocation(null, MNEMONIC_OPINDEX, -1, false);
        }
        this.tool = null;
    }

    synchronized void updateForLocation(Program program, ProgramLocation loc) {
        ReferenceInfo referenceInfo = this.initializeFromLocation(program, loc);
        this.init(referenceInfo);
    }

    synchronized void show(Program p, ProgramLocation loc) {
        ReferenceInfo referenceInfo = this.initializeFromLocation(p, loc);
        if (!this.tool.isVisible((ComponentProvider)this)) {
            this.tool.showComponentProvider((ComponentProvider)this, true);
            this.setupActions();
        } else {
            this.init(referenceInfo);
            this.tool.toFront((ComponentProvider)this);
        }
    }

    private ReferenceInfo initializeFromLocation(Program p, ProgramLocation loc) {
        this.currentLocation = loc;
        this.initLocation = loc;
        this.clearProgramState();
        if (p == null) {
            return null;
        }
        ReferenceInfo referenceInfo = this.getReferenceInfo(p, loc);
        this.currentCodeUnit = referenceInfo.codeUnit;
        this.currentProgram = referenceInfo.program;
        if (this.currentProgram != null) {
            this.currentProgram.addListener((DomainObjectListener)this);
        }
        return referenceInfo;
    }

    private ReferenceInfo getReferenceInfo(Program p, ProgramLocation loc) {
        Instruction instruction;
        ReferenceInfo info = new ReferenceInfo();
        if (loc == null) {
            return info;
        }
        info.program = p;
        info.codeUnit = this.getCurrentCodeUnit(p);
        if (loc instanceof OperandFieldLocation) {
            OperandFieldLocation operandFieldLocation = (OperandFieldLocation)loc;
            info.opIndex = operandFieldLocation.getOperandIndex();
            info.subIndex = operandFieldLocation.getSubOperandIndex();
        } else {
            info.opIndex = MNEMONIC_OPINDEX;
        }
        if (info.codeUnit == null) {
            info.program = null;
        } else if (info.codeUnit instanceof Instruction && (instruction = (Instruction)info.codeUnit).getNumOperands() == 0) {
            info.opIndex = MNEMONIC_OPINDEX;
        }
        return info;
    }

    private void clearProgramState() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
            this.currentProgram = null;
            this.currentCodeUnit = null;
        }
    }

    Program getCurrentProgram() {
        return this.currentProgram;
    }

    public CodeUnit getCodeUnit() {
        return this.getCurrentCodeUnit(this.currentProgram);
    }

    public CodeUnit getCodeUnit(Program currProgram, ProgramLocation currLocation) {
        CodeUnit cu = null;
        if (currProgram != null && currLocation != null) {
            Address addr = currLocation.getAddress();
            Listing listing = currProgram.getListing();
            Data data = DataUtilities.getDataAtLocation((ProgramLocation)currLocation);
            if (data == null) {
                cu = listing.getCodeUnitAt(addr);
            } else {
                Data d = listing.getDataContaining(addr);
                cu = this.findComponent(d, addr);
            }
        }
        return cu;
    }

    public ProgramLocation getInitLocation() {
        return this.initLocation;
    }

    private CodeUnit getCurrentCodeUnit(Program theProgram) {
        if (this.currentLocation == null) {
            return null;
        }
        Address addr = this.currentLocation.getAddress();
        Listing listing = theProgram.getListing();
        Data data = DataUtilities.getDataAtLocation((ProgramLocation)this.currentLocation);
        if (data == null) {
            return listing.getCodeUnitAt(addr);
        }
        Data d = listing.getDataContaining(addr);
        return this.findComponent(d, addr);
    }

    private Data findComponent(Data data, Address addr) {
        long offset;
        Data d;
        while (addr.compareTo((Object)data.getMinAddress()) >= 0 && (d = data.getComponentContaining((int)(offset = addr.subtract(data.getMinAddress())))) != null) {
            data = d;
        }
        return data;
    }

    private void init(ReferenceInfo info) {
        int opIndex = -1;
        int subIndex = 0;
        if (info != null) {
            opIndex = info.opIndex;
            subIndex = info.subIndex;
        }
        this.init(opIndex, subIndex);
    }

    private void init(int opIndex, int subIndex) {
        this.setTitle(this.generateTitle());
        this.refsTable.clearSelection();
        this.tableModel.setCodeUnitLocation(this.currentCodeUnit);
        this.instrPanel.setCodeUnitLocation(this.currentCodeUnit, opIndex, subIndex, false);
        this.adjustActionState();
        this.tableDropTarget.setActive(this.currentCodeUnit != null);
        this.scrollPaneDropTarget.setActive(this.currentCodeUnit != null);
    }

    public void closeComponent() {
        this.refsTable.editingStopped(new ChangeEvent((Object)this.refsTable));
        super.closeComponent();
        this.plugin.providerClosed((ComponentProvider)this);
    }

    public void componentHidden() {
        this.plugin.getCodeUnitFormat().removeChangeListener(this);
    }

    public void componentShown() {
        this.plugin.getCodeUnitFormat().addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.panel != null && this.panel.isVisible()) {
            this.panel.repaint();
        }
    }

    public JComponent getComponent() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel(new BorderLayout());
        this.panel.setPreferredSize(new Dimension(600, 200));
        this.instrPanel = new InstructionPanel(0, 5, 0, 5, this.goHomeAction, this.plugin, new InstructionPanelListener(){

            @Override
            public boolean dropSupported() {
                return true;
            }

            @Override
            public void operandSelected(int opIndex, int subIndex) {
                if (!EditReferencesProvider.this.selectionBusy) {
                    EditReferencesProvider.this.selectionBusy = true;
                    EditReferencesProvider.this.refsTable.getSelectionModel().clearSelection();
                    EditReferencesProvider.this.updateLocation();
                    EditReferencesProvider.this.adjustActionState();
                    EditReferencesProvider.this.selectionBusy = false;
                }
                EditReferencesProvider.this.getComponent().repaint();
            }

            @Override
            public void selectionDropped(AddressSetView set, CodeUnit cu, int opIndex) {
                EditReferencesProvider.this.plugin.addMemoryReferences(EditReferencesProvider.this.panel, set, cu, opIndex, false);
            }
        });
        this.panel.add((Component)this.instrPanel, "North");
        this.refsTable = new GhidraTable((TableModel)((Object)this.tableModel));
        this.refsTable.setName("RefsTable");
        JScrollPane sp = new JScrollPane((Component)((Object)this.refsTable));
        this.refsTable.setPreferredScrollableViewportSize(new Dimension(200, 400));
        this.refsTable.setSelectionMode(2);
        this.refsTable.getSelectionModel().addListSelectionListener(e -> {
            if (!this.selectionBusy && !e.getValueIsAdjusting()) {
                this.selectionBusy = true;
                int[] selRows = this.refsTable.getSelectedRows();
                if (selRows.length == 1) {
                    int opIndex = this.tableModel.getReference(selRows[0]).getOperandIndex();
                    this.instrPanel.setSelectedOpIndex(opIndex, -1);
                    this.followSelectedReference();
                }
                this.selectionBusy = false;
                this.updateLocation();
                this.adjustActionState();
            }
        });
        this.refsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EditReferencesProvider.this.refsTable.rowAtPoint(e.getPoint()) != -1) {
                    if (e.getClickCount() == 1) {
                        EditReferencesProvider.this.followSelectedReference();
                    } else if (e.getClickCount() == 2) {
                        EditReferencesProvider.this.editCallback();
                    }
                }
            }
        });
        TableColumn col = this.refsTable.getColumnModel().getColumn(4);
        col.setMinWidth(75);
        col.setMaxWidth(75);
        col.setResizable(false);
        col = this.refsTable.getColumnModel().getColumn(5);
        col.setMinWidth(80);
        col.setMaxWidth(80);
        col.setResizable(false);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.refsTable));
        this.dropTargetAdapter = new DropTgtAdapter(this.dropHandler, 3, ACCEPTABLE_DROP_FLAVORS);
        this.tableDropTarget = new DropTarget((Component)((Object)this.refsTable), 3, (DropTargetListener)this.dropTargetAdapter, true);
        this.scrollPaneDropTarget = new DropTarget(sp, 3, (DropTargetListener)this.dropTargetAdapter, true);
        this.tableDropTarget.setActive(false);
        this.scrollPaneDropTarget.setActive(false);
        TableColumnModel columnModel = this.refsTable.getColumnModel();
        RefCellTextRenderer textCellRenderer = new RefCellTextRenderer();
        RefCellBooleanRenderer booleanCellRenderer = new RefCellBooleanRenderer();
        RefCellBooleanEditor booleanCellEditor = new RefCellBooleanEditor();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            if (i == 4) {
                column.setCellRenderer((TableCellRenderer)((Object)booleanCellRenderer));
                column.setCellEditor(booleanCellEditor);
                continue;
            }
            if (i == 3) {
                column.setCellRenderer((TableCellRenderer)((Object)textCellRenderer));
                column.setCellEditor(new RefTypeCellEditor());
                continue;
            }
            column.setCellRenderer((TableCellRenderer)((Object)textCellRenderer));
        }
        this.adjustTableColumns();
        this.panel.add((Component)sp, "Center");
        int opIndex = MNEMONIC_OPINDEX;
        int subIndex = -1;
        if (this.currentLocation instanceof OperandFieldLocation) {
            opIndex = ((OperandFieldLocation)this.currentLocation).getOperandIndex();
            subIndex = ((OperandFieldLocation)this.currentLocation).getSubOperandIndex();
        }
        this.init(opIndex, subIndex);
        return this.panel;
    }

    private void adjustTableColumns() {
        this.refsTable.sizeColumnsToFit(-1);
        TableColumn column = this.refsTable.getColumn("Operand");
        column.setPreferredWidth(80);
        column = this.refsTable.getColumn("Destination");
        column.setPreferredWidth(100);
        column = this.refsTable.getColumn("Label");
        column.setPreferredWidth(150);
        column = this.refsTable.getColumn("Ref-Type");
        column.setPreferredWidth(150);
        column = this.refsTable.getColumn("Primary?");
        column.setPreferredWidth(60);
        column = this.refsTable.getColumn("Source");
        column.setPreferredWidth(70);
    }

    private void updateLocation() {
        if (this.currentLocation != null) {
            int opIndex = this.instrPanel.getSelectedOpIndex();
            this.currentLocation = opIndex == MNEMONIC_OPINDEX ? new MnemonicFieldLocation(this.currentLocation.getProgram(), this.currentLocation.getAddress(), this.currentLocation.getComponentPath(), "", 0) : new OperandFieldLocation(this.currentLocation.getProgram(), this.currentLocation.getAddress(), this.currentLocation.getComponentPath(), null, "", opIndex, 0);
        }
    }

    private void adjustActionState() {
        boolean validCodeUnit = this.currentProgram != null && this.currentCodeUnit != null;
        int selRowCnt = this.refsTable.getSelectedRowCount();
        this.addRefAction.setEnabled(validCodeUnit);
        this.deleteRefAction.setEnabled(selRowCnt != 0 || this.refsTable.getSelectedRowCount() != 0);
        this.editRefAction.setEnabled(selRowCnt == 1);
        this.goHomeAction.setEnabled(validCodeUnit);
    }

    boolean isLocationLocked() {
        return this.followLocationToggleAction != null && !this.followLocationToggleAction.isSelected();
    }

    void enableFollowLocation(boolean state) {
        if (state) {
            this.enableGotoReferenceLocation(false);
        }
        this.followLocationToggleAction.setSelected(state);
        String descr = "Enable/Disable following tool location changes";
        this.followLocationToggleAction.setDescription(HTMLUtilities.toHTML((String)descr));
        this.plugin.setDefaultFollowOnLocation(state);
    }

    void enableGotoReferenceLocation(boolean state) {
        if (state) {
            this.enableFollowLocation(false);
        }
        this.gotoReferenceLocationToggleAction.setSelected(state);
        String descr = "Enable/Disable sending location change for selected row";
        this.gotoReferenceLocationToggleAction.setDescription(HTMLUtilities.toHTML((String)descr));
        if (state) {
            this.followSelectedReference();
        }
        this.plugin.setDefaultGotoReferenceLocation(state);
    }

    private void followSelectedReference() {
        if (this.refsTable == null) {
            return;
        }
        if (this.gotoReferenceLocationToggleAction.isSelected() && this.refsTable.getSelectedRowCount() == 1) {
            Reference ref = this.tableModel.getReference(this.refsTable.getSelectedRow());
            Variable var = this.currentProgram.getReferenceManager().getReferencedVariable(ref);
            if (var != null) {
                this.plugin.goTo(this.currentProgram, (ProgramLocation)new VariableNameFieldLocation(this.currentProgram, var, 0));
            } else if (ref.getToAddress().isMemoryAddress()) {
                this.plugin.goTo(this.currentProgram, ref.getToAddress());
            }
        }
    }

    private void addCallback() {
        if (this.currentCodeUnit != null) {
            this.plugin.popupAddReferenceDialog(this.currentCodeUnit, this.instrPanel.getSelectedOpIndex(), this.instrPanel.getSelectedSubOpIndex(), this);
        }
    }

    private void editCallback() {
        Reference ref;
        if (this.currentCodeUnit != null && this.refsTable.getSelectedRowCount() == 1 && (ref = this.tableModel.getReference(this.refsTable.getSelectedRow())) != null) {
            this.plugin.popupEditReferenceDialog(this.currentCodeUnit, ref, this);
        }
    }

    private void deleteCallback() {
        this.refsTable.editingCanceled(new ChangeEvent((Object)this.refsTable));
        int[] selRows = this.refsTable.getSelectedRows();
        if (selRows.length != 0) {
            Reference[] refs = new Reference[selRows.length];
            for (int i = 0; i < selRows.length; ++i) {
                refs[i] = this.tableModel.getReference(selRows[i]);
            }
            this.plugin.deleteReferences(this.currentProgram, refs);
        }
    }

    public synchronized void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (this.currentProgram == null) {
            return;
        }
        this.updateMgr.updateLater();
    }

    private class ReferenceInfo {
        private Program program;
        private CodeUnit codeUnit;
        private int opIndex = 0;
        private int subIndex = -1;

        private ReferenceInfo() {
        }
    }

    private class RefCellTextRenderer
    extends GTableCellRenderer {
        RefCellTextRenderer() {
            this.defaultFont = this.getFont();
            this.boldFont = this.defaultFont.deriveFont(this.defaultFont.getStyle() | 1);
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            int row = data.getRowViewIndex();
            boolean isSelected = data.isSelected();
            Reference ref = EditReferencesProvider.this.tableModel.getReference(row);
            Address addr = ref.getToAddress();
            Memory memory = EditReferencesProvider.this.tableModel.getProgram().getMemory();
            boolean bad = addr.isMemoryAddress() ? !memory.contains(addr) : false;
            this.setOpaque(isSelected);
            if (bad) {
                this.setForeground(this.getErrorForegroundColor(isSelected));
                this.setFont(this.boldFont);
            } else {
                this.setFont(this.defaultFont);
            }
            if (!isSelected && ref.getOperandIndex() == EditReferencesProvider.this.instrPanel.getSelectedOpIndex()) {
                this.setBackground(BG_COLOR_ACTIVE_OPERAND);
                this.setOpaque(true);
            }
            return this;
        }
    }

    private class RefCellBooleanRenderer
    extends GBooleanCellRenderer {
        RefCellBooleanRenderer() {
            this.cb.setOpaque(true);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            JTable table = data.getTable();
            int row = data.getRowViewIndex();
            int column = data.getColumnModelIndex();
            boolean isSelected = data.isSelected();
            Reference ref = EditReferencesProvider.this.tableModel.getReference(row);
            boolean enabled = false;
            if (column == 4) {
                enabled = EditReferencesProvider.this.tableModel.isCellEditable(row, column);
            }
            this.cb.setEnabled(enabled);
            this.cb.setFont(table.getFont());
            this.cb.setBackground(this.getBackground());
            if (!isSelected && ref.getOperandIndex() == EditReferencesProvider.this.instrPanel.getSelectedOpIndex()) {
                this.cb.setBackground(BG_COLOR_ACTIVE_OPERAND);
                this.setBackground(BG_COLOR_ACTIVE_OPERAND);
            }
            return this;
        }

        public boolean shouldAlternateRowBackgroundColor() {
            return false;
        }
    }

    private class RefCellBooleanEditor
    extends DefaultCellEditor {
        private JCheckBox checkbox;

        RefCellBooleanEditor() {
            super((JCheckBox)new GCheckBox());
            this.setClickCountToStart(1);
            this.checkbox = (JCheckBox)this.editorComponent;
            this.checkbox.setOpaque(false);
            this.checkbox.setHorizontalAlignment(0);
            this.checkbox.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            column = table.convertColumnIndexToModel(column);
            Reference ref = EditReferencesProvider.this.tableModel.getReference(row);
            this.checkbox.setSelected((Boolean)value);
            this.checkbox.setEnabled(column == 4);
            this.checkbox.setFont(table.getFont());
            if (isSelected) {
                this.checkbox.setForeground(table.getSelectionForeground());
                this.checkbox.setBackground(table.getSelectionBackground());
                this.checkbox.setOpaque(true);
            } else if (ref.getOperandIndex() == EditReferencesProvider.this.instrPanel.getSelectedOpIndex()) {
                this.checkbox.setForeground(table.getForeground());
                this.checkbox.setBackground(BG_COLOR_ACTIVE_OPERAND);
                this.checkbox.setOpaque(true);
            } else {
                this.checkbox.setForeground(table.getForeground());
                this.checkbox.setBackground(table.getBackground());
                this.checkbox.setOpaque(false);
            }
            return this.checkbox;
        }
    }

    private class RefTypeCellEditor
    extends DefaultCellEditor {
        private CellEditComboBox comboBox;

        RefTypeCellEditor() {
            super(new CellEditComboBox());
            this.comboBox = (CellEditComboBox)this.editorComponent;
            this.comboBox.setFont(EditReferencesProvider.this.refsTable.getFont());
            this.comboBox.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    RefTypeCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if ((column = table.convertColumnIndexToModel(column)) != 3) {
                throw new RuntimeException("Incorrect column for RefTypeCellRenderer");
            }
            Reference ref = EditReferencesProvider.this.tableModel.getReference(row);
            RefType[] refTypes = EditReferencesModel.getAllowedRefTypes(EditReferencesProvider.this.currentProgram, ref);
            this.comboBox.removeAllItems();
            int selectedIndex = -1;
            for (RefType rt : refTypes) {
                if (rt == value) {
                    selectedIndex = this.comboBox.getItemCount();
                }
                this.comboBox.addItem(rt);
            }
            if (selectedIndex < 0) {
                this.comboBox.insertItemAt((RefType)value, 0);
                selectedIndex = 0;
            }
            this.comboBox.setSelectedIndex(selectedIndex);
            return this.comboBox;
        }
    }

    private class CellEditComboBox
    extends JComboBox<RefType> {
        private CellEditComboBox() {
        }

        @Override
        public void setSelectedIndex(int anIndex) {
            if (EditReferencesProvider.this.refsTable.getRowCount() == 0) {
                EditReferencesProvider.this.refsTable.editingCanceled(null);
                return;
            }
            super.setSelectedIndex(anIndex);
        }
    }
}

