/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.resources;

import docking.Tool;
import docking.action.builder.ActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import generic.util.image.ImageUtils;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.util.viewer.field.ResourceFieldLocation;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.data.DataImage;
import ghidra.program.model.listing.Data;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Data resource actions", description="This plugin provides actions related to embedded resources in the Listing.")
public class ResourceActionsPlugin
extends Plugin {
    public static final GhidraFileFilter GRAPHIC_FORMATS_FILTER = ExtensionFileFilter.forExtensions((String)"Graphic Images", (String[])new String[]{"png", "gif", "bmp", "jpg"});

    public ResourceActionsPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        new ActionBuilder("Save Image New Format", this.getName()).withContext(ProgramLocationActionContext.class).validContextWhen(plac -> plac.getLocation() instanceof ResourceFieldLocation && ((ResourceFieldLocation)plac.getLocation()).isDataImageResource()).onAction(plac -> this.saveImageAsNewImage((ResourceFieldLocation)plac.getLocation())).popupMenuPath(new String[]{"Data", "Save Image", "As New Format"}).buildAndInstall((Tool)this.tool);
        new ActionBuilder("Save Image Original Bytes", this.getName()).withContext(ProgramLocationActionContext.class).validContextWhen(plac -> plac.getLocation() instanceof ResourceFieldLocation && ((ResourceFieldLocation)plac.getLocation()).isDataImageResource()).onAction(plac -> this.saveImageOriginalBytes((ResourceFieldLocation)plac.getLocation())).popupMenuPath(new String[]{"Data", "Save Image", "Original Bytes"}).buildAndInstall((Tool)this.tool);
        this.tool.setMenuGroup(new String[]{"Data", "Save Image"}, "A_save_image");
    }

    private void saveImageAsNewImage(ResourceFieldLocation imageLocation) {
        Data data = imageLocation.getResourceData();
        if (data == null || !(data.getValue() instanceof DataImage)) {
            return;
        }
        DataImage dataImage = (DataImage)data.getValue();
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.tool.getActiveWindow());
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        chooser.setTitle("Save Image File As");
        chooser.setApproveButtonText("Save Image As");
        chooser.addFileFilter(GRAPHIC_FORMATS_FILTER);
        File f = chooser.getSelectedFile();
        chooser.dispose();
        if (f != null) {
            if (f.exists() && OptionDialog.showYesNoDialog((Component)this.tool.getActiveWindow(), (String)"Overwrite Existing File?", (String)("Overwrite " + f.getName() + "?")) != 1) {
                return;
            }
            String extension = FilenameUtils.getExtension((String)f.getName());
            if (extension.isBlank()) {
                Msg.showError((Object)((Object)this), null, (String)"Missing File Type", (Object)"Filename must specify a supported graphics format extension.");
                return;
            }
            try {
                ImageIcon icon = dataImage.getImageIcon();
                BufferedImage buffy = ImageUtils.getBufferedImage((Image)icon.getImage());
                boolean success = ImageIO.write((RenderedImage)buffy, extension, f);
                if (!success) {
                    Msg.showError((Object)((Object)this), null, (String)"Image File Error", (Object)("Failed to save " + f.getName() + ".\n\nEither unsupported image format or incompatible image features with selected image format."));
                    return;
                }
                this.tool.setStatusInfo("Image resource at " + data.getAddress() + " saved as: " + f.getName());
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)"Image File Error", (Object)("Failed to save " + f.getName()), (Throwable)e);
            }
        }
    }

    private void saveImageOriginalBytes(ResourceFieldLocation imageLocation) {
        Data data = imageLocation.getResourceData();
        if (data == null) {
            return;
        }
        try {
            GhidraFileChooser chooser = new GhidraFileChooser((Component)this.tool.getActiveWindow());
            chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
            chooser.setTitle("Save Image File As");
            chooser.setApproveButtonText("Save Image As");
            chooser.addFileFilter(GRAPHIC_FORMATS_FILTER);
            File f = chooser.getSelectedFile();
            chooser.dispose();
            if (f != null) {
                if (f.exists() && OptionDialog.showYesNoDialog((Component)this.tool.getActiveWindow(), (String)"Overwrite Existing File?", (String)("Overwrite " + f.getName() + "?")) != 1) {
                    return;
                }
                byte[] bytes = data.getBytes();
                FileUtilities.writeBytes((File)f, (byte[])bytes);
                this.tool.setStatusInfo("Image resource at " + data.getAddress() + " saved as: " + f.getName());
            }
        }
        catch (MemoryAccessException | IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Error Saving Image File", (Object)"Failed to save image", (Throwable)e);
        }
    }
}

