/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem;

import docking.widgets.button.GRadioButton;
import ghidra.app.plugin.core.searchmem.SearchData;
import ghidra.app.plugin.core.searchmem.SearchFormat;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DecimalSearchFormat
extends SearchFormat {
    private static final String MINUS_SIGN = "-";
    private static final int BYTE = 0;
    private static final int WORD = 1;
    private static final int DWORD = 2;
    private static final int QWORD = 3;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 5;
    private int decimalFormat = 1;

    public DecimalSearchFormat(ChangeListener listener) {
        super("Decimal", listener);
    }

    @Override
    public String getToolTip() {
        return HTMLUtilities.toHTML((String)"Interpret values as a sequence of\ndecimal numbers, separated by spaces");
    }

    private void setDecimalFormat(int format) {
        this.decimalFormat = format;
        this.changeListener.stateChanged(new ChangeEvent(this));
    }

    @Override
    public JPanel getOptionsPanel() {
        ButtonGroup decimalGroup = new ButtonGroup();
        GRadioButton decimalByte = new GRadioButton("Byte", false);
        GRadioButton decimalWord = new GRadioButton("Word", true);
        GRadioButton decimalDWord = new GRadioButton("DWord", false);
        GRadioButton decimalQWord = new GRadioButton("QWord", false);
        GRadioButton decimalFloat = new GRadioButton("Float", false);
        GRadioButton decimalDouble = new GRadioButton("Double", false);
        decimalByte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DecimalSearchFormat.this.setDecimalFormat(0);
            }
        });
        decimalWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DecimalSearchFormat.this.setDecimalFormat(1);
            }
        });
        decimalDWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DecimalSearchFormat.this.setDecimalFormat(2);
            }
        });
        decimalQWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DecimalSearchFormat.this.setDecimalFormat(3);
            }
        });
        decimalFloat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DecimalSearchFormat.this.setDecimalFormat(4);
            }
        });
        decimalDouble.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DecimalSearchFormat.this.setDecimalFormat(5);
            }
        });
        decimalGroup.add((AbstractButton)decimalByte);
        decimalGroup.add((AbstractButton)decimalWord);
        decimalGroup.add((AbstractButton)decimalDWord);
        decimalGroup.add((AbstractButton)decimalQWord);
        decimalGroup.add((AbstractButton)decimalFloat);
        decimalGroup.add((AbstractButton)decimalDouble);
        JPanel decimalOptionsPanel = new JPanel();
        decimalOptionsPanel.setLayout(new GridLayout(3, 2));
        decimalOptionsPanel.add((Component)decimalByte);
        decimalOptionsPanel.add((Component)decimalWord);
        decimalOptionsPanel.add((Component)decimalDWord);
        decimalOptionsPanel.add((Component)decimalQWord);
        decimalOptionsPanel.add((Component)decimalFloat);
        decimalOptionsPanel.add((Component)decimalDouble);
        decimalOptionsPanel.setBorder(BorderFactory.createTitledBorder("Format Options"));
        return decimalOptionsPanel;
    }

    @Override
    public SearchData getSearchData(String input) {
        ArrayList<Byte> bytesList = new ArrayList<Byte>();
        StringTokenizer tokenizer = new StringTokenizer(input);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.equals(MINUS_SIGN)) {
                if (!input.endsWith(MINUS_SIGN)) {
                    return SearchData.createInvalidInputSearchData("Cannot have space after a '-'");
                }
                return SearchData.createIncompleteSearchData("");
            }
            try {
                bytesList.addAll(this.getBytes(tok));
            }
            catch (NumberFormatException ex) {
                return SearchData.createInvalidInputSearchData("");
            }
            catch (RuntimeException re) {
                return SearchData.createInvalidInputSearchData(re.getMessage());
            }
        }
        return SearchData.createSearchData(input, this.getDataBytes(bytesList), null);
    }

    private byte[] getDataBytes(List<Byte> bytesList) {
        byte[] bytes = new byte[bytesList.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = bytesList.get(i);
        }
        return bytes;
    }

    private List<Byte> getBytes(long value, int n) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (int i = 0; i < n; ++i) {
            byte b = (byte)value;
            list.add(b);
            value >>= 8;
        }
        if (this.isBigEndian) {
            Collections.reverse(list);
        }
        return list;
    }

    private void checkValue(long value, long min, long max) {
        if (value < min || value > max) {
            throw new RuntimeException("Number must be in the range [" + min + "," + max + "]");
        }
    }

    private List<Byte> getBytes(String tok) {
        switch (this.decimalFormat) {
            case 0: {
                long value = Short.parseShort(tok);
                this.checkValue(value, -128L, 255L);
                return this.getBytes(value, 1);
            }
            case 1: {
                long value = Integer.parseInt(tok);
                this.checkValue(value, -32768L, 65535L);
                return this.getBytes(value, 2);
            }
            case 2: {
                long value = Long.parseLong(tok);
                this.checkValue(value, Integer.MIN_VALUE, 0xFFFFFFFFL);
                return this.getBytes(value, 4);
            }
            case 3: {
                long value = Long.parseLong(tok);
                return this.getBytes(value, 8);
            }
            case 4: {
                tok = this.preProcessFloat(tok);
                float floatValue = Float.parseFloat(tok);
                long value = Float.floatToIntBits(floatValue);
                return this.getBytes(value, 4);
            }
            case 5: {
                tok = this.preProcessFloat(tok);
                double dvalue = Double.parseDouble(tok);
                long value = Double.doubleToLongBits(dvalue);
                return this.getBytes(value, 8);
            }
        }
        throw new AssertException("Unexpected format type");
    }

    private String preProcessFloat(String tok) {
        if (tok.indexOf(100) >= 0 || tok.indexOf(68) >= 0 || tok.indexOf(70) >= 0 || tok.indexOf(102) >= 0) {
            throw new NumberFormatException();
        }
        if (tok.endsWith("E") || tok.endsWith("e")) {
            tok = tok.substring(0, tok.length() - 1);
        }
        if (tok.endsWith("E-") || tok.endsWith("e-")) {
            tok = tok.substring(0, tok.length() - 2);
        }
        return tok;
    }
}

