/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal;

import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.FieldLocationListener;
import docking.widgets.fieldpanel.listener.FieldSelectionListener;
import docking.widgets.fieldpanel.listener.IndexMapper;
import docking.widgets.fieldpanel.listener.LayoutListener;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.indexedscrollpane.IndexedScrollPane;
import generic.theme.GColor;
import generic.theme.Gui;
import ghidra.app.plugin.core.terminal.TerminalAwtEventEncoder;
import ghidra.app.plugin.core.terminal.TerminalClipboardProvider;
import ghidra.app.plugin.core.terminal.TerminalFinder;
import ghidra.app.plugin.core.terminal.TerminalLayout;
import ghidra.app.plugin.core.terminal.TerminalLayoutModel;
import ghidra.app.plugin.core.terminal.TerminalListener;
import ghidra.app.plugin.core.terminal.TerminalProvider;
import ghidra.app.plugin.core.terminal.vt.AnsiColorResolver;
import ghidra.app.plugin.core.terminal.vt.VtHandler;
import ghidra.app.plugin.core.terminal.vt.VtOutput;
import ghidra.app.plugin.core.terminal.vt.VtResponseEncoder;
import ghidra.app.services.ClipboardService;
import ghidra.util.ColorUtils;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TerminalPanel
extends JPanel
implements FieldLocationListener,
FieldSelectionListener,
LayoutListener,
AnsiColorResolver {
    protected static final int MAX_TITLE_STACK_SIZE = 20;
    protected static final String DEFAULT_FONT_ID = "font.plugin.terminal";
    protected static final GColor COLOR_BACKGROUND = new GColor("color.bg.plugin.terminal");
    protected static final GColor COLOR_FOREGROUND = new GColor("color.fg.plugin.terminal");
    protected static final GColor COLOR_CURSOR_FOCUSED = new GColor("color.cursor.focused.terminal");
    protected static final GColor COLOR_CURSOR_UNFOCUSED = new GColor("color.cursor.unfocused.terminal");
    protected static final GColor COLOR_0_BLACK = new GColor("color.fg.plugin.terminal.normal.black");
    protected static final GColor COLOR_1_RED = new GColor("color.fg.plugin.terminal.normal.red");
    protected static final GColor COLOR_2_GREEN = new GColor("color.fg.plugin.terminal.normal.green");
    protected static final GColor COLOR_3_YELLOW = new GColor("color.fg.plugin.terminal.normal.yellow");
    protected static final GColor COLOR_4_BLUE = new GColor("color.fg.plugin.terminal.normal.blue");
    protected static final GColor COLOR_5_MAGENTA = new GColor("color.fg.plugin.terminal.normal.magenta");
    protected static final GColor COLOR_6_CYAN = new GColor("color.fg.plugin.terminal.normal.cyan");
    protected static final GColor COLOR_7_WHITE = new GColor("color.fg.plugin.terminal.normal.white");
    protected static final GColor COLOR_0_BRIGHT_BLACK = new GColor("color.fg.plugin.terminal.bright.black");
    protected static final GColor COLOR_1_BRIGHT_RED = new GColor("color.fg.plugin.terminal.bright.red");
    protected static final GColor COLOR_2_BRIGHT_GREEN = new GColor("color.fg.plugin.terminal.bright.green");
    protected static final GColor COLOR_3_BRIGHT_YELLOW = new GColor("color.fg.plugin.terminal.bright.yellow");
    protected static final GColor COLOR_4_BRIGHT_BLUE = new GColor("color.fg.plugin.terminal.bright.blue");
    protected static final GColor COLOR_5_BRIGHT_MAGENTA = new GColor("color.fg.plugin.terminal.bright.magenta");
    protected static final GColor COLOR_6_BRIGHT_CYAN = new GColor("color.fg.plugin.terminal.bright.cyan");
    protected static final GColor COLOR_7_BRIGHT_WHITE = new GColor("color.fg.plugin.terminal.bright.white");
    protected static final int[] CUBE_STEPS = new int[]{0, 95, 135, 175, 215, 255};
    protected FontMetrics metrics;
    protected final TerminalLayoutModel model;
    protected final TerminalFieldPanel fieldPanel;
    protected final IndexedScrollPane scroller;
    protected boolean fixedSize = false;
    protected String title;
    protected final Deque<String> titleStack = new LinkedList<String>();
    protected final TerminalProvider provider;
    protected ClipboardService clipboardService;
    protected TerminalClipboardProvider clipboardProvider;
    protected String selectedText;
    protected final ArrayList<TerminalListener> terminalListeners = new ArrayList();
    protected VtOutput outputCb;
    protected final TerminalAwtEventEncoder eventEncoder;
    protected final VtResponseEncoder responseEncoder;

    protected TerminalPanel(Charset charset, final TerminalProvider provider) {
        this.provider = provider;
        this.clipboardProvider = new TerminalClipboardProvider(provider);
        Gui.registerFont((Component)this, (String)DEFAULT_FONT_ID);
        this.metrics = this.getFontMetrics(this.getFont());
        this.model = new TerminalLayoutModel(this, charset, this.metrics, this);
        this.fieldPanel = new TerminalFieldPanel(this.model);
        this.fieldPanel.addFieldSelectionListener(this);
        this.fieldPanel.addFieldLocationListener(this);
        this.fieldPanel.addLayoutListener(this);
        this.setBackground((Color)COLOR_BACKGROUND);
        this.fieldPanel.setBackgroundColor((Color)COLOR_BACKGROUND);
        this.scroller = new IndexedScrollPane((JComponent)((Object)this.fieldPanel));
        this.scroller.setBackground((Color)COLOR_BACKGROUND);
        this.scroller.setVerticalScrollBarPolicy(22);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (TerminalPanel.this.fixedSize) {
                    return;
                }
                TerminalPanel.this.resizeTerminalToWindow();
            }
        });
        this.setPreferredSize(new Dimension(600, 400));
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroller);
        this.eventEncoder = new TerminalAwtEventEncoder(charset){

            @Override
            public void generateBytes(ByteBuffer buf) {
                if (TerminalPanel.this.outputCb != null) {
                    TerminalPanel.this.outputCb.out(buf);
                }
            }
        };
        this.responseEncoder = new VtResponseEncoder(charset){

            @Override
            protected void generateBytes(ByteBuffer buf) {
                if (TerminalPanel.this.outputCb != null) {
                    TerminalPanel.this.outputCb.out(buf);
                }
            }
        };
        for (KeyListener r : this.fieldPanel.getKeyListeners()) {
            this.fieldPanel.removeKeyListener(r);
        }
        this.fieldPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (provider.isLocalActionKeyBinding(e)) {
                    return;
                }
                TerminalPanel.this.eventEncoder.keyPressed(e, TerminalPanel.this.model.cursorKeyMode, TerminalPanel.this.model.keypadMode);
                e.consume();
            }

            @Override
            public void keyTyped(KeyEvent e) {
                TerminalPanel.this.eventEncoder.keyTyped(e);
                e.consume();
            }
        });
        this.fieldPanel.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (TerminalPanel.this.model.reportMousePress && !e.isShiftDown()) {
                    FieldLocation location = TerminalPanel.this.fieldPanel.getLocationForPoint(e.getX(), e.getY());
                    TerminalPanel.this.eventEncoder.mousePressed(e, location.getIndex().intValueExact(), location.getCol());
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TerminalPanel.this.model.reportMousePress && !e.isShiftDown()) {
                    FieldLocation location = TerminalPanel.this.fieldPanel.getLocationForPoint(e.getX(), e.getY());
                    TerminalPanel.this.eventEncoder.mouseReleased(e, location.getIndex().intValueExact(), location.getCol());
                    e.consume();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                FieldLocation location = TerminalPanel.this.fieldPanel.getLocationForPoint(e.getX(), e.getY());
                if (TerminalPanel.this.model.reportMousePress && !e.isShiftDown()) {
                    e.consume();
                    return;
                }
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    TerminalPanel.this.selectWordAt(location, EventTrigger.GUI_ACTION);
                    e.consume();
                } else if (e.getButton() == 2) {
                    String text = TerminalPanel.this.getSelectedText();
                    if (text == null) {
                        return;
                    }
                    TerminalPanel.this.paste(text);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.fieldPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TerminalPanel.this.model.reportMousePress && !e.isShiftDown()) {
                    e.consume();
                    return;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.fieldPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                FieldLocation location = TerminalPanel.this.fieldPanel.getLocationForPoint(e.getX(), e.getY());
                if (TerminalPanel.this.model.reportMousePress && !e.isShiftDown()) {
                    TerminalPanel.this.eventEncoder.mouseWheelMoved(e, location.getIndex().intValueExact(), location.getCol());
                    e.consume();
                }
            }
        });
        this.fieldPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (TerminalPanel.this.model.reportFocus) {
                    TerminalPanel.this.eventEncoder.focusGained();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (TerminalPanel.this.model.reportFocus) {
                    TerminalPanel.this.eventEncoder.focusLost();
                }
            }
        });
    }

    public void addTerminalListener(TerminalListener listener) {
        this.terminalListeners.add(listener);
    }

    public void removeTerminalListener(TerminalListener listener) {
        this.terminalListeners.remove(listener);
    }

    protected void notifyTerminalResized(short cols, short rows) {
        for (TerminalListener l : this.terminalListeners) {
            try {
                l.resized(cols, rows);
            }
            catch (Throwable t) {
                Msg.showError((Object)this, null, (String)"Error", (Object)t.getMessage(), (Throwable)t);
            }
        }
    }

    protected void notifyTerminalRetitled(String title) {
        for (TerminalListener l : this.terminalListeners) {
            try {
                l.retitled(title);
            }
            catch (Throwable t) {
                Msg.showError((Object)this, null, (String)"Error", (Object)t.getMessage(), (Throwable)t);
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.metrics = this.getFontMetrics(font);
        if (this.model != null) {
            this.model.setFontMetrics(this.metrics);
        }
    }

    public TerminalFieldPanel getFieldPanel() {
        return this.fieldPanel;
    }

    public void layoutsChanged(List<AnchoredLayout> layouts) {
        if (!Objects.equals(this.selectedText, this.getSelectedText())) {
            this.fieldPanel.clearSelection();
        }
    }

    public void selectionChanged(FieldSelection selection, EventTrigger trigger) {
        this.selectedText = this.getSelectedText();
        this.clipboardProvider.selectionChanged(selection);
    }

    public void fieldLocationChanged(FieldLocation location, Field field, EventTrigger trigger) {
        if (trigger == EventTrigger.GUI_ACTION) {
            this.placeCursor(false);
        }
    }

    public void selectWordAt(FieldLocation location, EventTrigger trigger) {
        BigInteger index = location.getIndex();
        TerminalLayout layout = this.model.getLayout(index);
        if (layout == null) {
            return;
        }
        int start = Math.min(location.col, layout.line.findWord(location.col, false));
        int end = Math.max(location.col + 1, layout.line.findWord(location.col, true));
        FieldSelection sel = new FieldSelection();
        sel.addRange(new FieldLocation(index, 0, 0, start), new FieldLocation(index, 0, 0, end));
        this.fieldPanel.setSelection(sel, trigger);
    }

    public void processInput(ByteBuffer buffer) {
        this.model.processInput(buffer);
    }

    protected Color resolveDefaultColor(AnsiColorResolver.WhichGround ground, boolean reverseVideo) {
        if (ground == AnsiColorResolver.WhichGround.BACKGROUND) {
            if (reverseVideo) {
                return COLOR_FOREGROUND;
            }
            return null;
        }
        if (reverseVideo) {
            return COLOR_BACKGROUND;
        }
        return COLOR_FOREGROUND;
    }

    protected Color resolveStandardColor(VtHandler.AnsiStandardColor standard) {
        return switch (standard) {
            default -> throw new IncompatibleClassChangeError();
            case VtHandler.AnsiStandardColor.BLACK -> COLOR_0_BLACK;
            case VtHandler.AnsiStandardColor.RED -> COLOR_1_RED;
            case VtHandler.AnsiStandardColor.GREEN -> COLOR_2_GREEN;
            case VtHandler.AnsiStandardColor.YELLOW -> COLOR_3_YELLOW;
            case VtHandler.AnsiStandardColor.BLUE -> COLOR_4_BLUE;
            case VtHandler.AnsiStandardColor.MAGENTA -> COLOR_5_MAGENTA;
            case VtHandler.AnsiStandardColor.CYAN -> COLOR_6_CYAN;
            case VtHandler.AnsiStandardColor.WHITE -> COLOR_7_WHITE;
        };
    }

    protected Color resolveIntenseColor(VtHandler.AnsiIntenseColor intense) {
        return switch (intense) {
            default -> throw new IncompatibleClassChangeError();
            case VtHandler.AnsiIntenseColor.BLACK -> COLOR_0_BRIGHT_BLACK;
            case VtHandler.AnsiIntenseColor.RED -> COLOR_1_BRIGHT_RED;
            case VtHandler.AnsiIntenseColor.GREEN -> COLOR_2_BRIGHT_GREEN;
            case VtHandler.AnsiIntenseColor.YELLOW -> COLOR_3_BRIGHT_YELLOW;
            case VtHandler.AnsiIntenseColor.BLUE -> COLOR_4_BRIGHT_BLUE;
            case VtHandler.AnsiIntenseColor.MAGENTA -> COLOR_5_BRIGHT_MAGENTA;
            case VtHandler.AnsiIntenseColor.CYAN -> COLOR_6_BRIGHT_CYAN;
            case VtHandler.AnsiIntenseColor.WHITE -> COLOR_7_BRIGHT_WHITE;
        };
    }

    protected Color resolve216Color(VtHandler.Ansi216Color cube) {
        return ColorUtils.getColor((int)CUBE_STEPS[cube.r()], (int)CUBE_STEPS[cube.g()], (int)CUBE_STEPS[cube.b()]);
    }

    protected Color resolveGrayscaleColor(VtHandler.AnsiGrayscaleColor gray) {
        return ColorUtils.getColor((int)(gray.v() * 10 + 8));
    }

    protected Color resolve24BitColor(VtHandler.Ansi24BitColor rgb) {
        return ColorUtils.getColor((int)rgb.r(), (int)rgb.g(), (int)rgb.b());
    }

    @Override
    public Color resolveColor(VtHandler.AnsiColor color, AnsiColorResolver.WhichGround ground, VtHandler.Intensity intensity, boolean reverseVideo) {
        if (color == VtHandler.AnsiDefaultColor.INSTANCE) {
            return this.resolveDefaultColor(ground, reverseVideo);
        }
        if (color instanceof VtHandler.AnsiStandardColor) {
            VtHandler.AnsiStandardColor standard = (VtHandler.AnsiStandardColor)color;
            return this.resolveStandardColor(standard);
        }
        if (color instanceof VtHandler.AnsiIntenseColor) {
            VtHandler.AnsiIntenseColor intense = (VtHandler.AnsiIntenseColor)color;
            return this.resolveIntenseColor(intense);
        }
        if (color instanceof VtHandler.Ansi216Color) {
            VtHandler.Ansi216Color cube = (VtHandler.Ansi216Color)color;
            return this.resolve216Color(cube);
        }
        if (color instanceof VtHandler.AnsiGrayscaleColor) {
            VtHandler.AnsiGrayscaleColor gray = (VtHandler.AnsiGrayscaleColor)color;
            return this.resolveGrayscaleColor(gray);
        }
        if (color instanceof VtHandler.Ansi24BitColor) {
            VtHandler.Ansi24BitColor rgb = (VtHandler.Ansi24BitColor)color;
            return this.resolve24BitColor(rgb);
        }
        throw new AssertionError();
    }

    public void setClipboardService(ClipboardService clipboardService) {
        if (this.clipboardService == clipboardService) {
            return;
        }
        if (this.clipboardService != null) {
            this.clipboardService.deRegisterClipboardContentProvider(this.clipboardProvider);
        }
        this.clipboardService = clipboardService;
        if (this.clipboardService != null) {
            this.clipboardService.registerClipboardContentProvider(this.clipboardProvider);
        }
    }

    public void setOutputCallback(VtOutput outputCb) {
        this.outputCb = outputCb;
    }

    protected void placeCursor(boolean scroll) {
        int scrollBack = this.model.getScrollBackSize();
        this.fieldPanel.setCursorPosition(BigInteger.valueOf(this.model.getCursorRow() + scrollBack), 0, 0, this.model.getCursorColumn());
        if (scroll) {
            this.fieldPanel.scrollTo(new FieldLocation(this.model.resetCursorBottom() + scrollBack));
        }
    }

    protected void saveTitle() {
        this.titleStack.push(this.title);
        if (this.titleStack.size() > 20) {
            this.titleStack.pollLast();
        }
    }

    protected void restoreTitle() {
        this.title = this.titleStack.poll();
        this.notifyTerminalRetitled(this.title);
    }

    protected void setTitle(String title) {
        this.title = title;
        this.notifyTerminalRetitled(this.title);
    }

    public void reportCursorPos(int row, int col) {
        this.responseEncoder.reportCursorPos(row, col);
    }

    public void dispose() {
        if (this.clipboardService != null) {
            this.clipboardService.deRegisterClipboardContentProvider(this.clipboardProvider);
        }
    }

    public void paste(String text) {
        if (this.model.bracketedPaste) {
            this.responseEncoder.reportPasteStart();
        }
        try {
            this.eventEncoder.sendText(text);
        }
        finally {
            if (this.model.bracketedPaste) {
                this.responseEncoder.reportPasteEnd();
            }
        }
    }

    public String getSelectedText() {
        FieldSelection sel = this.fieldPanel.getSelection();
        if (sel == null || sel.getNumRanges() != 1) {
            return null;
        }
        return this.getSelectedText(sel.getFieldRange(0));
    }

    public String getSelectedText(FieldRange range) {
        return this.model.getSelectedText(range);
    }

    public FieldRange find(String text, Set<FindOptions> options, FieldLocation start, boolean forward) {
        TerminalFinder finder = options.contains((Object)FindOptions.REGEX) ? new TerminalFinder.RegexTerminalFinder(this.model, start, forward, text, options) : new TerminalFinder.TextTerminalFinder(this.model, start, forward, text, options);
        return finder.find();
    }

    protected void resizeTerminalToWindow() {
        Rectangle bounds = this.scroller.getViewportBorderBounds();
        int cols = bounds.width / this.metrics.charWidth('M');
        int rows = bounds.height / this.metrics.getHeight();
        this.resizeTerminal((short)cols, (short)rows);
    }

    protected void resizeTerminal(short cols, short rows) {
        if (this.model.resizeTerminal(Short.toUnsignedInt(cols), Short.toUnsignedInt(rows))) {
            this.notifyTerminalResized((short)this.model.getCols(), (short)this.model.getRows());
        }
    }

    public void setFixedTerminalSize(short cols, short rows) {
        this.fixedSize = true;
        this.scroller.setVerticalScrollBarPolicy(20);
        this.scroller.setHorizontalScrollBarPolicy(30);
        this.resizeTerminal(cols, rows);
    }

    public void setDynamicTerminalSize() {
        this.fixedSize = false;
        this.scroller.setVerticalScrollBarPolicy(22);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.resizeTerminalToWindow();
    }

    public int getColumns() {
        return this.model.getCols();
    }

    public int getRows() {
        return this.model.getRows();
    }

    public int getCursorColumn() {
        return this.model.getCursorColumn();
    }

    public int getCursorRow() {
        return this.model.getCursorRow();
    }

    protected class TerminalFieldPanel
    extends FieldPanel {
        public TerminalFieldPanel(LayoutModel model) {
            super(model, "Terminal");
            this.setFieldDescriptionProvider((l, f) -> {
                if (f == null) {
                    return null;
                }
                return "line " + (l.getIndex().intValue() + 1) + ": " + f.getText();
            });
            this.paintContext.setFocusedCursorColor((Color)COLOR_CURSOR_FOCUSED);
            this.paintContext.setNotFocusedCursorColor((Color)COLOR_CURSOR_UNFOCUSED);
            this.paintContext.setCursorFocused(true);
        }

        public void modelSizeChanged(IndexMapper indexMapper) {
            this.setCursorOn(false);
            super.modelSizeChanged(indexMapper);
            this.setCursorOn(true);
        }
    }

    public static enum FindOptions {
        CASE_SENSITIVE,
        WRAP,
        WHOLE_WORD,
        REGEX;

    }
}

