/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal.vt;

import ghidra.app.plugin.core.terminal.vt.AnsiColorResolver;
import ghidra.app.plugin.core.terminal.vt.VtHandler;
import java.awt.Color;

public record VtAttributes(VtHandler.AnsiColor fg, VtHandler.AnsiColor bg, VtHandler.Intensity intensity, VtHandler.AnsiFont font, VtHandler.Underline underline, VtHandler.Blink blink, boolean reverseVideo, boolean hidden, boolean strikeThrough, boolean proportionalSpacing) {
    public static final VtAttributes DEFAULTS = new VtAttributes(VtHandler.AnsiDefaultColor.INSTANCE, VtHandler.AnsiDefaultColor.INSTANCE, VtHandler.Intensity.NORMAL, VtHandler.AnsiFont.NORMAL, VtHandler.Underline.NONE, VtHandler.Blink.NONE, false, false, false, false);

    public VtAttributes fg(VtHandler.AnsiColor fg) {
        return new VtAttributes(fg, this.bg, this.intensity, this.font, this.underline, this.blink, this.reverseVideo, this.hidden, this.strikeThrough, this.proportionalSpacing);
    }

    public VtAttributes bg(VtHandler.AnsiColor bg) {
        return new VtAttributes(this.fg, bg, this.intensity, this.font, this.underline, this.blink, this.reverseVideo, this.hidden, this.strikeThrough, this.proportionalSpacing);
    }

    public VtAttributes intensity(VtHandler.Intensity intensity) {
        return new VtAttributes(this.fg, this.bg, intensity, this.font, this.underline, this.blink, this.reverseVideo, this.hidden, this.strikeThrough, this.proportionalSpacing);
    }

    public VtAttributes font(VtHandler.AnsiFont font) {
        return new VtAttributes(this.fg, this.bg, this.intensity, font, this.underline, this.blink, this.reverseVideo, this.hidden, this.strikeThrough, this.proportionalSpacing);
    }

    public VtAttributes underline(VtHandler.Underline underline) {
        return new VtAttributes(this.fg, this.bg, this.intensity, this.font, underline, this.blink, this.reverseVideo, this.hidden, this.strikeThrough, this.proportionalSpacing);
    }

    public VtAttributes blink(VtHandler.Blink blink) {
        return new VtAttributes(this.fg, this.bg, this.intensity, this.font, this.underline, blink, this.reverseVideo, this.hidden, this.strikeThrough, this.proportionalSpacing);
    }

    public VtAttributes reverseVideo(boolean reverseVideo) {
        return new VtAttributes(this.fg, this.bg, this.intensity, this.font, this.underline, this.blink, reverseVideo, this.hidden, this.strikeThrough, this.proportionalSpacing);
    }

    public VtAttributes hidden(boolean hidden) {
        return new VtAttributes(this.fg, this.bg, this.intensity, this.font, this.underline, this.blink, this.reverseVideo, hidden, this.strikeThrough, this.proportionalSpacing);
    }

    public VtAttributes strikeThrough(boolean strikeThrough) {
        return new VtAttributes(this.fg, this.bg, this.intensity, this.font, this.underline, this.blink, this.reverseVideo, this.hidden, strikeThrough, this.proportionalSpacing);
    }

    public VtAttributes proportionalSpacing(boolean proportionalSpacing) {
        return new VtAttributes(this.fg, this.bg, this.intensity, this.font, this.underline, this.blink, this.reverseVideo, this.hidden, this.strikeThrough, proportionalSpacing);
    }

    public Color resolveForeground(AnsiColorResolver colors) {
        return colors.resolveColor(this.reverseVideo ? this.bg : this.fg, AnsiColorResolver.WhichGround.FOREGROUND, this.intensity, this.reverseVideo);
    }

    public Color resolveBackground(AnsiColorResolver colors) {
        return colors.resolveColor(this.reverseVideo ? this.fg : this.bg, AnsiColorResolver.WhichGround.BACKGROUND, VtHandler.Intensity.NORMAL, this.reverseVideo);
    }
}

