/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal.vt;

import ghidra.app.plugin.core.terminal.vt.VtCharset;
import ghidra.util.Msg;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface VtHandler {
    public static final byte[] _4 = VtHandler.ascii("4");
    public static final byte[] Q1 = VtHandler.ascii("?1");
    public static final byte[] Q7 = VtHandler.ascii("?7");
    public static final byte[] Q12 = VtHandler.ascii("?12");
    public static final byte[] Q25 = VtHandler.ascii("?25");
    public static final byte[] Q47 = VtHandler.ascii("?47");
    public static final byte[] Q1000 = VtHandler.ascii("?1000");
    public static final byte[] Q1004 = VtHandler.ascii("?1004");
    public static final byte[] Q1034 = VtHandler.ascii("?1034");
    public static final byte[] Q1047 = VtHandler.ascii("?1047");
    public static final byte[] Q1048 = VtHandler.ascii("?1048");
    public static final byte[] Q1049 = VtHandler.ascii("?1049");
    public static final byte[] Q2004 = VtHandler.ascii("?2004");
    public static final Pattern PAT_OSC_WINDOW_TITLE = Pattern.compile("0;(?<title>.*)");
    public static final Pattern PAT_OSC_COLOR_QUERY = Pattern.compile("1[0-9];\\?");

    public static byte[] ascii(String str) {
        try {
            return str.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean bufEq(ByteBuffer buf, byte[] arr) {
        return Arrays.equals(buf.array(), buf.position(), buf.limit(), arr, 0, arr.length);
    }

    public static String charInfo(byte b) {
        return Character.toString(b) + " (" + Integer.toHexString(b & 0xFF) + ")";
    }

    public static String strBuf(ByteBuffer buf) {
        byte[] arr = new byte[buf.remaining()];
        buf.get(buf.position(), arr);
        try {
            return new String(arr, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void handleChar(byte var1) throws Exception;

    default public void handleCharExc(byte b) {
        try {
            switch (b) {
                case 7: {
                    this.handleBell();
                    return;
                }
                case 8: {
                    this.handleBackSpace();
                    return;
                }
                case 9: {
                    this.handleTab();
                    return;
                }
                case 10: {
                    this.handleLineFeed();
                    return;
                }
                case 13: {
                    this.handleCarriageReturn();
                    return;
                }
                case 14: {
                    this.handleAltCharset(true);
                    return;
                }
                case 15: {
                    this.handleAltCharset(false);
                    return;
                }
            }
            this.handleChar(b);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Exception handling terminal character output " + VtHandler.charInfo(b) + ":" + e), (Throwable)e);
        }
    }

    public static PrimitiveIterator.OfInt parseCsiInts(ByteBuffer csiParam) {
        final ByteBuffer buf = csiParam.duplicate();
        return new PrimitiveIterator.OfInt(){
            int next = this.prepareNext();

            private int prepareNext() {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                int value = 0;
                while (buf.hasRemaining()) {
                    byte b = buf.get();
                    if (48 <= b && b <= 57) {
                        value = value * 10 + (b - 48);
                        continue;
                    }
                    if (b == 59 || b == 58) {
                        return value;
                    }
                    throw new UnknownCsiException();
                }
                return value;
            }

            @Override
            public boolean hasNext() {
                return this.next != -1;
            }

            @Override
            public int nextInt() {
                int ret = this.next;
                this.next = this.prepareNext();
                return ret;
            }
        };
    }

    default public void handleHOrLStuff(ByteBuffer csiParam, boolean en) {
        if (VtHandler.bufEq(csiParam, _4)) {
            this.handleInsertMode(en);
        } else if (VtHandler.bufEq(csiParam, Q1)) {
            this.handleCursorKeyMode(en ? KeyMode.APPLICATION : KeyMode.NORMAL);
        } else if (VtHandler.bufEq(csiParam, Q7)) {
            this.handleAutoWrapMode(en);
        } else if (VtHandler.bufEq(csiParam, Q12)) {
            this.handleBlinkCursor(en);
        } else if (VtHandler.bufEq(csiParam, Q25)) {
            this.handleShowCursor(en);
        } else if (VtHandler.bufEq(csiParam, Q47)) {
            this.handleAltScreenBuffer(en, false);
        } else if (VtHandler.bufEq(csiParam, Q1000)) {
            this.handleReportMouseEvents(en, en);
        } else if (VtHandler.bufEq(csiParam, Q1004)) {
            this.handleReportFocus(en);
        } else if (VtHandler.bufEq(csiParam, Q1034)) {
            this.handleMetaKey(en);
        } else if (VtHandler.bufEq(csiParam, Q1047)) {
            this.handleAltScreenBuffer(en, false);
        } else if (VtHandler.bufEq(csiParam, Q1048)) {
            if (en) {
                this.handleSaveCursorPos();
            } else {
                this.handleRestoreCursorPos();
            }
        } else if (VtHandler.bufEq(csiParam, Q1049)) {
            if (en) {
                this.handleSaveCursorPos();
                this.handleAltScreenBuffer(en, true);
            } else {
                this.handleAltScreenBuffer(en, true);
                this.handleRestoreCursorPos();
            }
        } else if (VtHandler.bufEq(csiParam, Q2004)) {
            this.handleBracketedPasteMode(en);
        } else {
            throw new UnknownCsiException();
        }
    }

    default public void handleWindowManipulation(ByteBuffer csiParam) {
        PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
        if (!bits.hasNext()) {
            throw new UnknownCsiException();
        }
        switch (bits.nextInt()) {
            case 22: {
                switch (bits.nextInt()) {
                    case 0: {
                        this.handleSaveIconTitle();
                        this.handleSaveWindowTitle();
                        return;
                    }
                    case 1: {
                        this.handleSaveIconTitle();
                        return;
                    }
                    case 2: {
                        this.handleSaveWindowTitle();
                        return;
                    }
                }
                throw new UnknownCsiException();
            }
            case 23: {
                switch (bits.nextInt()) {
                    case 0: {
                        this.handleRestoreIconTitle();
                        this.handleRestoreWindowTitle();
                        return;
                    }
                    case 1: {
                        this.handleRestoreIconTitle();
                        return;
                    }
                    case 2: {
                        this.handleRestoreWindowTitle();
                        return;
                    }
                }
                throw new UnknownCsiException();
            }
        }
        throw new UnknownCsiException();
    }

    default public void handleCsi(ByteBuffer csiParam, ByteBuffer csiInter, byte csiFinal) throws Exception {
        try {
            switch (csiFinal) {
                case 64: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleInsertCharacters(n);
                    return;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: {
                    Direction dir = Direction.forCsiFinal(csiFinal);
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleMoveCursor(dir, n);
                    return;
                }
                case 71: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleMoveCursorCol(n - 1);
                    return;
                }
                case 72: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    int m = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleMoveCursor(n - 1, m - 1);
                    return;
                }
                case 74: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 0;
                    this.handleErase(Erasure.fromED(n));
                    return;
                }
                case 75: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 0;
                    this.handleErase(Erasure.fromEL(n));
                    return;
                }
                case 76: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleInsertLines(n);
                    return;
                }
                case 77: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleDeleteLines(n);
                    return;
                }
                case 80: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleDeleteCharacters(n);
                    return;
                }
                case 83: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleScrollLinesUp(n, false);
                    return;
                }
                case 84: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleScrollLinesDown(n);
                    return;
                }
                case 88: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleEraseCharacters(n);
                    return;
                }
                case 90: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleBackwardTab(n);
                    return;
                }
                case 99: {
                    Msg.trace((Object)this, (Object)"TODO: Send Device Attributes");
                    return;
                }
                case 100: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    int n = bits.hasNext() ? bits.nextInt() : 1;
                    this.handleMoveCursorRow(n - 1);
                    return;
                }
                case 104: {
                    this.handleHOrLStuff(csiParam, true);
                    return;
                }
                case 108: {
                    this.handleHOrLStuff(csiParam, false);
                    return;
                }
                case 109: {
                    PrimitiveIterator.OfInt bits;
                    if (csiParam.hasRemaining()) {
                        switch (csiParam.get(csiParam.position())) {
                            case 62: {
                                Msg.trace((Object)this, (Object)"TODO: Set key modifier options");
                                return;
                            }
                            case 63: {
                                Msg.trace((Object)this, (Object)"TODO: Query key modifier options");
                                return;
                            }
                        }
                    }
                    if (!(bits = VtHandler.parseCsiInts(csiParam)).hasNext()) {
                        this.handleResetAttributes();
                    }
                    while (bits.hasNext()) {
                        this.handleSgrAttribute(bits);
                    }
                    return;
                }
                case 110: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    if (!bits.hasNext()) {
                        throw new UnknownCsiException();
                    }
                    switch (bits.nextInt()) {
                        case 6: {
                            this.handleReportCursorPos();
                            return;
                        }
                    }
                    throw new UnknownCsiException();
                }
                case 112: {
                    this.handleFullReset();
                    return;
                }
                case 114: {
                    PrimitiveIterator.OfInt bits = VtHandler.parseCsiInts(csiParam);
                    Integer start = bits.hasNext() ? Integer.valueOf(bits.nextInt() - 1) : null;
                    Integer end = bits.hasNext() ? Integer.valueOf(bits.nextInt() - 1) : null;
                    this.handleSetScrollRange(start, end);
                    return;
                }
                case 115: {
                    this.handleSaveCursorPos();
                    return;
                }
                case 116: {
                    this.handleWindowManipulation(csiParam);
                    return;
                }
                case 117: {
                    this.handleRestoreCursorPos();
                    return;
                }
            }
            throw new UnknownCsiException();
        }
        catch (UnknownCsiException e) {
            Msg.error((Object)this, (Object)("Unknown CSI sequence: param:'" + VtHandler.strBuf(csiParam) + "' inter:'" + VtHandler.strBuf(csiInter) + "' final:" + VtHandler.charInfo(csiFinal)));
            return;
        }
    }

    default public void handleCsiExc(ByteBuffer csiParam, ByteBuffer csiInter, byte csiFinal) {
        try {
            this.handleCsi(csiParam, csiInter, csiFinal);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Exception handling terminal CSI sequence", (Throwable)e);
        }
    }

    public static String truncateAtNull(String str) {
        return str.split("\u0000", 2)[0];
    }

    default public void handleOsc(ByteBuffer oscParam) throws Exception {
        try {
            String paramStr = VtHandler.strBuf(oscParam);
            Matcher matcher = PAT_OSC_WINDOW_TITLE.matcher(paramStr);
            if (matcher.matches()) {
                this.handleWindowTitle(VtHandler.truncateAtNull(matcher.group("title")));
                return;
            }
            matcher = PAT_OSC_COLOR_QUERY.matcher(paramStr);
            if (matcher.matches()) {
                Msg.trace((Object)this, (Object)"TODO: OSC Color Query");
                return;
            }
            throw new UnknownOscException();
        }
        catch (UnknownOscException e) {
            Msg.error((Object)this, (Object)("Unknown OSC sequence: param:'" + VtHandler.strBuf(oscParam) + "'"));
            return;
        }
    }

    default public void handleOscExc(ByteBuffer oscParam) {
        try {
            this.handleOsc(oscParam);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Exception handling terminal OSC sequence", (Throwable)e);
        }
    }

    default public AnsiColor decodeColor(int colorCode, PrimitiveIterator.OfInt bits, Intensity intensity) {
        if (colorCode < 8) {
            return intensity == Intensity.BOLD ? AnsiIntenseColor.get(colorCode) : AnsiStandardColor.get(colorCode);
        }
        if (colorCode == 8) {
            return this.decodeExtendedColor(bits);
        }
        if (colorCode == 9) {
            return AnsiDefaultColor.INSTANCE;
        }
        Msg.error((Object)this, (Object)("Unrecognized color code: " + colorCode));
        return null;
    }

    default public AnsiColor decodeExtendedColor(PrimitiveIterator.OfInt bits) {
        if (!bits.hasNext()) {
            Msg.error((Object)this, (Object)"Missing color type in extended color code");
            return null;
        }
        int type = bits.nextInt();
        if (type == 5) {
            if (!bits.hasNext()) {
                return null;
            }
            return this.decode8BitColor(bits.nextInt());
        }
        if (type == 2) {
            if (!bits.hasNext()) {
                return null;
            }
            int r = bits.nextInt();
            if (!bits.hasNext()) {
                return null;
            }
            int g = bits.nextInt();
            if (!bits.hasNext()) {
                return null;
            }
            int b = bits.nextInt();
            return new Ansi24BitColor(r, g, b);
        }
        Msg.error((Object)this, (Object)("Unrecognized extended color type: " + type));
        return null;
    }

    default public AnsiColor decode8BitColor(int code) {
        if (code < 8) {
            return AnsiStandardColor.get(code);
        }
        if (code < 16) {
            return AnsiIntenseColor.get(code - 8);
        }
        if (code < 232) {
            int b = (code -= 16) % 6;
            int g = code / 6 % 6;
            int r = code / 36 % 6;
            return new Ansi216Color(r, g, b);
        }
        if (code < 256) {
            return new AnsiGrayscaleColor(code);
        }
        Msg.warn((Object)this, (Object)("Invalid 8-bit color code: " + code));
        return null;
    }

    default public void handleSgrAttribute(PrimitiveIterator.OfInt bits) {
        int code = bits.nextInt();
        if (30 <= code && code < 50) {
            int colorCode = code % 10;
            AnsiColor color = this.decodeColor(colorCode, bits, Intensity.NORMAL);
            if (code < 40) {
                this.handleForegroundColor(color);
            } else {
                this.handleBackgroundColor(color);
            }
            return;
        }
        if (90 <= code && code < 110) {
            int colorCode = code % 10;
            AnsiColor color = this.decodeColor(colorCode, bits, Intensity.BOLD);
            if (code < 100) {
                this.handleForegroundColor(color);
            } else {
                this.handleBackgroundColor(color);
            }
            return;
        }
        switch (code) {
            case 0: {
                this.handleResetAttributes();
                return;
            }
            case 1: {
                this.handleIntensity(Intensity.BOLD);
                return;
            }
            case 2: {
                this.handleIntensity(Intensity.DIM);
                return;
            }
            case 3: {
                this.handleFont(AnsiFont.ITALIC);
                return;
            }
            case 4: {
                this.handleUnderline(Underline.SINGLE);
                return;
            }
            case 5: {
                this.handleBlink(Blink.SLOW);
                return;
            }
            case 6: {
                this.handleBlink(Blink.FAST);
                return;
            }
            case 7: {
                this.handleReverseVideo(true);
                return;
            }
            case 8: {
                this.handleHidden(true);
                return;
            }
            case 9: {
                this.handleStrikeThrough(true);
                return;
            }
            case 20: {
                this.handleFont(AnsiFont.BLACK_LETTER);
                return;
            }
            case 21: {
                this.handleUnderline(Underline.DOUBLE);
                return;
            }
            case 22: {
                this.handleIntensity(Intensity.NORMAL);
                return;
            }
            case 23: {
                this.handleFont(AnsiFont.NORMAL);
                return;
            }
            case 24: {
                this.handleUnderline(Underline.NONE);
                return;
            }
            case 25: {
                this.handleBlink(Blink.NONE);
                return;
            }
            case 26: {
                this.handleProportionalSpacing(true);
                return;
            }
            case 27: {
                this.handleReverseVideo(false);
                return;
            }
            case 28: {
                this.handleHidden(false);
                return;
            }
            case 29: {
                this.handleStrikeThrough(false);
                return;
            }
        }
        Msg.warn((Object)this, (Object)("Unrecognized SGR attribute: " + code));
    }

    public void handleBell();

    public void handleBackSpace();

    public void handleTab();

    public void handleBackwardTab(int var1);

    public void handleLineFeed();

    public void handleCarriageReturn();

    public void handleAltCharset(boolean var1);

    public void handleForegroundColor(AnsiColor var1);

    public void handleBackgroundColor(AnsiColor var1);

    public void handleResetAttributes();

    public void handleIntensity(Intensity var1);

    public void handleFont(AnsiFont var1);

    public void handleUnderline(Underline var1);

    public void handleBlink(Blink var1);

    public void handleReverseVideo(boolean var1);

    public void handleHidden(boolean var1);

    public void handleStrikeThrough(boolean var1);

    public void handleProportionalSpacing(boolean var1);

    public void handleInsertMode(boolean var1);

    public void handleCursorKeyMode(KeyMode var1);

    public void handleKeypadMode(KeyMode var1);

    public void handleAutoWrapMode(boolean var1);

    public void handleBlinkCursor(boolean var1);

    public void handleShowCursor(boolean var1);

    public void handleReportMouseEvents(boolean var1, boolean var2);

    public void handleReportFocus(boolean var1);

    public void handleMetaKey(boolean var1);

    public void handleAltScreenBuffer(boolean var1, boolean var2);

    public void handleBracketedPasteMode(boolean var1);

    public void handleSaveCursorPos();

    public void handleRestoreCursorPos();

    public void handleMoveCursor(Direction var1, int var2);

    public void handleMoveCursor(int var1, int var2);

    public void handleMoveCursorRow(int var1);

    public void handleMoveCursorCol(int var1);

    public void handleReportCursorPos();

    public void handleSaveIconTitle();

    public void handleSaveWindowTitle();

    public void handleRestoreIconTitle();

    public void handleRestoreWindowTitle();

    public void handleWindowTitle(String var1);

    public void handleErase(Erasure var1);

    public void handleInsertLines(int var1);

    public void handleDeleteLines(int var1);

    public void handleDeleteCharacters(int var1);

    public void handleEraseCharacters(int var1);

    public void handleInsertCharacters(int var1);

    public void handleSetScrollRange(Integer var1, Integer var2);

    public void handleScrollViewportDown(int var1, boolean var2);

    public void handleScrollViewportUp(int var1);

    default public void handleScrollLinesDown(int n) {
        this.handleScrollViewportUp(n);
    }

    default public void handleScrollLinesUp(int n, boolean intoScrollBack) {
        this.handleScrollViewportDown(n, intoScrollBack);
    }

    public void handleSetCharset(VtCharset.G var1, VtCharset var2);

    public void handleFullReset();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum KeyMode {
        NORMAL{

            @Override
            public <T> T choose(T normal, T application) {
                return normal;
            }
        }
        ,
        APPLICATION{

            @Override
            public <T> T choose(T normal, T application) {
                return application;
            }
        };


        public abstract <T> T choose(T var1, T var2);
    }

    public static class UnknownCsiException
    extends RuntimeException {
    }

    public static enum Direction {
        UP,
        DOWN,
        FORWARD,
        BACK;


        public static Direction forCsiFinal(byte b) {
            return switch (b) {
                case 65 -> UP;
                case 66 -> DOWN;
                case 67 -> FORWARD;
                case 68 -> BACK;
                default -> throw new AssertionError();
            };
        }
    }

    public static enum Erasure {
        TO_LINE_END,
        TO_LINE_START,
        FULL_LINE,
        TO_DISPLAY_END,
        TO_DISPLAY_START,
        FULL_DISPLAY,
        FULL_DISPLAY_AND_SCROLLBACK;


        public static Erasure fromED(int n) {
            return switch (n) {
                case 0 -> TO_DISPLAY_END;
                case 1 -> TO_DISPLAY_START;
                case 2 -> FULL_DISPLAY;
                case 3 -> FULL_DISPLAY_AND_SCROLLBACK;
                default -> TO_DISPLAY_END;
            };
        }

        public static Erasure fromEL(int n) {
            return switch (n) {
                case 0 -> TO_LINE_END;
                case 1 -> TO_LINE_START;
                case 2 -> FULL_LINE;
                default -> TO_LINE_END;
            };
        }
    }

    public static class UnknownOscException
    extends RuntimeException {
    }

    public static enum Intensity {
        NORMAL,
        BOLD,
        DIM;

    }

    public static enum AnsiIntenseColor implements AnsiColor
    {
        BLACK,
        RED,
        GREEN,
        YELLOW,
        BLUE,
        MAGENTA,
        CYAN,
        WHITE;

        public static final List<AnsiIntenseColor> ALL;

        public static AnsiIntenseColor get(int code) {
            return ALL.get(code);
        }

        static {
            ALL = List.of(AnsiIntenseColor.values());
        }
    }

    public static enum AnsiStandardColor implements AnsiColor
    {
        BLACK,
        RED,
        GREEN,
        YELLOW,
        BLUE,
        MAGENTA,
        CYAN,
        WHITE;

        public static final List<AnsiStandardColor> ALL;

        public static AnsiStandardColor get(int code) {
            return ALL.get(code);
        }

        static {
            ALL = List.of(AnsiStandardColor.values());
        }
    }

    public static interface AnsiColor {
    }

    public static enum AnsiDefaultColor implements AnsiColor
    {
        INSTANCE;

    }

    public record Ansi24BitColor(int r, int g, int b) implements AnsiColor
    {
    }

    public record Ansi216Color(int r, int g, int b) implements AnsiColor
    {
    }

    public record AnsiGrayscaleColor(int v) implements AnsiColor
    {
    }

    public static enum AnsiFont {
        NORMAL,
        ITALIC,
        BLACK_LETTER;

    }

    public static enum Underline {
        NONE,
        SINGLE,
        DOUBLE;

    }

    public static enum Blink {
        NONE,
        SLOW,
        FAST;

    }
}

