/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.functioncompare.FunctionComparison;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonModelListener;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.task.TaskLauncher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class FunctionComparisonModel {
    private List<FunctionComparison> comparisons = new ArrayList<FunctionComparison>();
    private List<FunctionComparisonModelListener> listeners = new ArrayList<FunctionComparisonModelListener>();

    public void addFunctionComparisonModelListener(FunctionComparisonModelListener listener) {
        this.listeners.add(listener);
    }

    public List<FunctionComparison> getComparisons() {
        ArrayList<FunctionComparison> toReturn = new ArrayList<FunctionComparison>();
        toReturn.addAll(this.comparisons);
        Collections.sort(toReturn);
        return toReturn;
    }

    public void setComparisons(List<FunctionComparison> comparisons) {
        this.comparisons = comparisons;
    }

    public void addComparison(FunctionComparison comparison) {
        this.comparisons.add(comparison);
    }

    public Set<Function> getTargets(Function source) {
        HashSet<Function> targets = new HashSet<Function>();
        for (FunctionComparison fc : this.comparisons) {
            if (!fc.getSource().equals(source)) continue;
            targets.addAll(fc.getTargets());
        }
        return targets;
    }

    public void compareFunctions(Set<Function> functions) {
        if (CollectionUtils.isEmpty(functions)) {
            return;
        }
        this.addToExistingComparisons(functions);
        this.createNewComparisons(functions);
        this.fireModelChanged();
    }

    public void compareFunctions(Function source, Function target) {
        FunctionComparison fc = this.getOrCreateComparison(source);
        fc.addTarget(target);
        this.fireModelChanged();
    }

    public void removeFunction(Function function) {
        this.doRemoveFunction(function);
        this.fireModelChanged();
    }

    public void removeFunctions(Collection<Function> functions) {
        for (Function function : functions) {
            this.doRemoveFunction(function);
        }
        this.fireModelChanged();
    }

    private void doRemoveFunction(Function function) {
        ArrayList<FunctionComparison> comparisonsToRemove = new ArrayList<FunctionComparison>();
        for (FunctionComparison fc : this.comparisons) {
            if (fc.getSource().equals(function)) {
                comparisonsToRemove.add(fc);
                continue;
            }
            fc.getTargets().remove(function);
        }
        this.comparisons.removeAll(comparisonsToRemove);
    }

    public void removeFunctions(Program program) {
        Set<Function> allFunctions = this.getSourceFunctions();
        allFunctions.addAll(this.getTargetFunctions());
        Set<Function> functionsToRemove = allFunctions.stream().filter(f -> f.getProgram().equals(program)).collect(Collectors.toSet());
        this.removeFunctions(functionsToRemove);
    }

    public Set<Function> getSourceFunctions() {
        HashSet<Function> items = new HashSet<Function>();
        for (FunctionComparison fc : this.comparisons) {
            items.add(fc.getSource());
        }
        return items;
    }

    public Set<Function> getTargetFunctions() {
        HashSet<Function> items = new HashSet<Function>();
        for (FunctionComparison fc : this.comparisons) {
            items.addAll(fc.getTargets());
        }
        return items;
    }

    public Set<Function> getTargetFunctions(Function source) {
        HashSet<Function> items = new HashSet<Function>();
        for (FunctionComparison fc : this.comparisons) {
            if (!fc.getSource().equals(source)) continue;
            items.addAll(fc.getTargets());
        }
        return items;
    }

    private void createNewComparisons(Set<Function> functions) {
        TaskLauncher.launchModal((String)"Creating Comparisons", monitor -> {
            functions.removeIf(f -> this.comparisons.stream().anyMatch(fc -> f.equals(fc.getSource())));
            monitor.setIndeterminate(false);
            monitor.setMessage("Creating new comparisons");
            monitor.initialize((long)functions.size());
            Set<Function> existingTargets = this.getTargetFunctions();
            for (Function f2 : functions) {
                if (monitor.isCancelled()) {
                    Msg.info((Object)this, (Object)"Function comparison operation cancelled");
                    return;
                }
                FunctionComparison fc = new FunctionComparison();
                fc.setSource(f2);
                fc.addTargets(functions);
                fc.addTargets(existingTargets);
                this.comparisons.add(fc);
                monitor.incrementProgress(1L);
            }
        });
    }

    private FunctionComparison getOrCreateComparison(Function source) {
        for (FunctionComparison fc : this.comparisons) {
            if (!fc.getSource().equals(source)) continue;
            return fc;
        }
        FunctionComparison fc = new FunctionComparison();
        fc.setSource(source);
        this.comparisons.add(fc);
        return fc;
    }

    private void addToExistingComparisons(Set<Function> functions) {
        for (FunctionComparison fc : this.comparisons) {
            fc.getTargets().addAll(functions);
        }
    }

    private void fireModelChanged() {
        this.listeners.forEach(l -> l.modelChanged(this.comparisons));
    }
}

