/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.MutableByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.util.Msg;
import ghidra.util.datastruct.LRUMap;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.AccessMode;
import org.apache.commons.collections4.map.ReferenceMap;

public class FileByteProvider
implements MutableByteProvider {
    static final int BUFFER_SIZE = 65536;
    private static final int BUFFERS_TO_PIN = 4;
    private FSRL fsrl;
    private File file;
    private RandomAccessFile raf;
    private ReferenceMap<Long, Buffer> buffers = new ReferenceMap();
    private LRUMap<Long, Buffer> lruBuffers = new LRUMap(4);
    private long currentLength;
    private AccessMode accessMode;

    public FileByteProvider(File file, FSRL fsrl, AccessMode accessMode) throws IOException {
        this.file = file;
        this.fsrl = fsrl;
        this.accessMode = accessMode;
        this.raf = new RandomAccessFile(file, this.accessModeToString(accessMode));
        this.currentLength = this.raf.length();
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
        this.buffers.clear();
        this.lruBuffers.clear();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.fsrl != null ? this.fsrl.getName() : this.file.getName();
    }

    @Override
    public String getAbsolutePath() {
        return this.fsrl != null ? this.fsrl.getPath() : this.file.getAbsolutePath();
    }

    @Override
    public FSRL getFSRL() {
        return this.fsrl;
    }

    @Override
    public long length() throws IOException {
        return this.currentLength;
    }

    @Override
    public boolean isValidIndex(long index) {
        return 0L <= index && index < this.currentLength;
    }

    @Override
    public byte readByte(long index) throws IOException {
        this.ensureBounds(index, 1L);
        Buffer fileBuffer = this.getBufferFor(index);
        int ofs = fileBuffer.getBufferOffset(index);
        return fileBuffer.bytes[ofs];
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        this.ensureBounds(index, length);
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        int len = (int)length;
        byte[] result = new byte[len];
        int bytesRead = this.readBytes(index, result, 0, len);
        if (bytesRead != len) {
            throw new IOException("Unable to read " + len + " bytes at " + index);
        }
        return result;
    }

    public int readBytes(long index, byte[] buffer, int offset, int length) throws IOException {
        this.ensureBounds(index, 0L);
        length = (int)Math.min(this.currentLength - index, (long)length);
        int totalBytesRead = 0;
        while (length > 0) {
            Buffer fileBuffer = this.getBufferFor(index);
            int ofs = fileBuffer.getBufferOffset(index);
            int bytesToReadFromThisBuffer = Math.min(fileBuffer.len - ofs, length);
            System.arraycopy(fileBuffer.bytes, ofs, buffer, totalBytesRead, bytesToReadFromThisBuffer);
            length -= bytesToReadFromThisBuffer;
            index += (long)bytesToReadFromThisBuffer;
            totalBytesRead += bytesToReadFromThisBuffer;
        }
        return totalBytesRead;
    }

    protected void finalize() {
        if (this.raf != null) {
            Msg.warn((Object)this, (Object)("FAIL TO CLOSE " + this.file));
        }
    }

    public synchronized void writeBytes(long index, byte[] buffer, int offset, int length) throws IOException {
        if (this.accessMode != AccessMode.WRITE) {
            throw new IOException("Not write mode");
        }
        this.doWriteBytes(index, buffer, offset, length);
        long writeEnd = index + (long)length;
        this.currentLength = Math.max(this.currentLength, writeEnd);
        while (length > 0) {
            long bufferPos = this.getBufferPos(index);
            int bufferOfs = (int)(index - bufferPos);
            int bytesAvailForThisBuffer = Math.min(length, 65536 - bufferOfs);
            Buffer fileBuffer = (Buffer)this.buffers.get((Object)bufferPos);
            if (fileBuffer != null) {
                if (bufferOfs == 0 && length >= 65536) {
                    System.arraycopy(buffer, offset, fileBuffer.bytes, 0, 65536);
                    fileBuffer.len = 65536;
                } else {
                    this.buffers.remove((Object)bufferPos);
                    this.lruBuffers.remove((Object)bufferPos);
                }
            }
            index += (long)bytesAvailForThisBuffer;
            offset += bytesAvailForThisBuffer;
            length -= bytesAvailForThisBuffer;
        }
    }

    @Override
    public void writeByte(long index, byte value) throws IOException {
        this.writeBytes(index, new byte[]{value}, 0, 1);
    }

    @Override
    public void writeBytes(long index, byte[] values) throws IOException {
        this.writeBytes(index, values, 0, values.length);
    }

    protected int doReadBytes(long index, byte[] buffer) throws IOException {
        this.raf.seek(index);
        return this.raf.read(buffer, 0, buffer.length);
    }

    protected void doWriteBytes(long index, byte[] buffer, int offset, int length) throws IOException {
        this.raf.seek(index);
        this.raf.write(buffer, offset, length);
    }

    private void ensureBounds(long index, long length) throws IOException {
        if (index < 0L || index > this.currentLength) {
            throw new IOException("Invalid index: " + index);
        }
        if (index + length > this.currentLength) {
            throw new IOException("Unable to read past EOF: " + index + ", " + length);
        }
    }

    private long getBufferPos(long index) {
        return index / 65536L * 65536L;
    }

    private synchronized Buffer getBufferFor(long pos) throws IOException {
        long bufferPos = this.getBufferPos(pos);
        if (bufferPos >= this.currentLength) {
            throw new EOFException();
        }
        Buffer buffer = (Buffer)this.buffers.get((Object)bufferPos);
        if (buffer == null) {
            buffer = new Buffer(bufferPos, (int)Math.min(this.currentLength - bufferPos, 65536L));
            int bytesRead = this.doReadBytes(bufferPos, buffer.bytes);
            if (bytesRead != buffer.len) {
                buffer.len = bytesRead;
            }
            this.buffers.put((Object)bufferPos, (Object)buffer);
        }
        this.lruBuffers.put((Object)bufferPos, (Object)buffer);
        return buffer;
    }

    private String accessModeToString(AccessMode mode) {
        switch (mode) {
            default: {
                return "r";
            }
            case WRITE: 
        }
        return "rw";
    }

    private static class Buffer {
        long pos;
        int len;
        byte[] bytes;

        Buffer(long pos, int len) {
            this.pos = pos;
            this.len = len;
            this.bytes = new byte[len];
        }

        int getBufferOffset(long filePos) throws EOFException {
            int ofs = (int)(filePos - this.pos);
            if (ofs >= this.len) {
                throw new EOFException();
            }
            return ofs;
        }
    }
}

