/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.line;

import ghidra.app.util.bin.BinaryReader;
import ghidra.program.model.data.LEB128;
import java.io.IOException;

public class FileEntry {
    private String fileName;
    private long directoryIndex;
    private long lastModifiedTime;
    private long fileLengthInBytes;

    FileEntry(BinaryReader reader) throws IOException {
        this.fileName = reader.readNextAsciiString();
        if (this.fileName.length() == 0) {
            return;
        }
        this.directoryIndex = reader.readNext(LEB128::unsigned);
        this.lastModifiedTime = reader.readNext(LEB128::unsigned);
        this.fileLengthInBytes = reader.readNext(LEB128::unsigned);
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getDirectoryIndex() {
        return this.directoryIndex;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getFileLengthInBytes() {
        return this.fileLengthInBytes;
    }

    public String toString() {
        return this.fileName;
    }
}

