/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.DWARFLine;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFIdentifierCase;
import java.io.File;
import java.io.IOException;

public class DWARFCompileUnit {
    private final String name;
    private final String producer;
    private final String comp_dir;
    private final Number high_pc;
    private final Number low_pc;
    private final Number language;
    private final DWARFIdentifierCase identifier_case;
    private final boolean hasDWO;
    private DWARFLine line = null;

    public static DWARFCompileUnit read(DIEAggregate diea) throws IOException, DWARFException {
        if (diea.getTag() != 17) {
            throw new IOException("Expecting a DW_TAG_compile_unit DIE, found " + diea.getTag());
        }
        String name = diea.getString(3, null);
        String producer = diea.getString(37, null);
        String comp_dir = diea.getString(27, null);
        Long high_pc = null;
        Long low_pc = null;
        Long language = null;
        if (diea.hasAttribute(17)) {
            low_pc = diea.getLowPC(0L);
        }
        if (diea.hasAttribute(18) && !diea.isLowPCEqualHighPC()) {
            high_pc = diea.getHighPC();
        }
        if (diea.hasAttribute(19)) {
            language = diea.getUnsignedLong(19, -1L);
        }
        DWARFIdentifierCase identifier_case = null;
        if (diea.hasAttribute(66)) {
            identifier_case = DWARFIdentifierCase.find(diea.getUnsignedLong(66, -1L));
        }
        boolean hasDWO = diea.hasAttribute(8497) && diea.hasAttribute(8496);
        DWARFLine line = DWARFLine.read(diea);
        return new DWARFCompileUnit(name, producer, comp_dir, low_pc, high_pc, language, identifier_case, hasDWO, line);
    }

    public DWARFCompileUnit(String name, String producer, String comp_dir, Number low_pc, Number high_pc, Number language, DWARFIdentifierCase identifier_case, boolean hasDWO, DWARFLine line) {
        this.name = name;
        this.producer = producer;
        this.comp_dir = comp_dir;
        this.low_pc = low_pc;
        this.high_pc = high_pc;
        this.language = language;
        this.identifier_case = identifier_case;
        this.hasDWO = hasDWO;
        this.line = line;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.getName() == null ? null : new File(this.getName()).getName();
    }

    public String getFullFileByIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative file index was given.");
        }
        if (this.line == null) {
            return null;
        }
        return this.line.getFullFile(index, this.comp_dir);
    }

    public String getFileByIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative file index was given.");
        }
        if (this.line == null) {
            return null;
        }
        return this.line.getFile(index, this.comp_dir);
    }

    public boolean isValidFileIndex(int index) {
        return this.line.isValidFileIndex(index);
    }

    public String getProducer() {
        return this.producer;
    }

    public String getCompileDirectory() {
        return this.comp_dir;
    }

    public Number getHighPC() {
        return this.high_pc;
    }

    public Number getLowPC() {
        return this.low_pc;
    }

    public int getLanguage() {
        return this.language == null ? -1 : this.language.intValue();
    }

    public DWARFIdentifierCase getIdentifierCase() {
        return this.identifier_case;
    }

    public boolean hasDWO() {
        return this.hasDWO;
    }

    public String toString() {
        return "DWARFCompileUnit [name=" + this.name + ", producer=" + this.producer + ", comp_dir=" + this.comp_dir + ", high_pc=" + this.high_pc + ", low_pc=" + this.low_pc + ", language=" + this.language + ", identifier_case=" + this.identifier_case + ", hasDWO=" + this.hasDWO + ", line=" + this.line + "]";
    }
}

