/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.funcfixup;

import ghidra.app.util.bin.format.dwarf4.funcfixup.DWARFFunctionFixup;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunction;
import ghidra.app.util.bin.format.dwarf4.next.DWARFVariable;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPointProperties;

@ExtensionPointProperties(priority=2000)
public class OutputParamCheckDWARFFunctionFixup
implements DWARFFunctionFixup {
    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc) {
        for (DWARFVariable dvar : dfunc.params) {
            if (!dvar.isOutputParameter || !dvar.isMissingStorage()) continue;
            Msg.warn((Object)this, (Object)"Unsupported output parameter for %s@%s".formatted(dfunc.name.getName(), dfunc.address));
        }
    }
}

