/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.funcfixup;

import ghidra.app.util.bin.format.dwarf4.funcfixup.DWARFFunctionFixup;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunction;
import ghidra.app.util.bin.format.dwarf4.next.DWARFVariable;
import ghidra.util.classfinder.ExtensionPointProperties;

@ExtensionPointProperties(priority=2000)
public class ParamSpillDWARFFunctionFixup
implements DWARFFunctionFixup {
    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc) {
        for (DWARFVariable param : dfunc.params) {
            long paramStackOffset;
            if (!param.isStackStorage() || !dfunc.isInLocalVarStorageArea(paramStackOffset = param.getStackOffset()) || dfunc.getLocalVarByOffset(paramStackOffset) != null) continue;
            DWARFVariable paramSpill = DWARFVariable.fromDataType(dfunc, param.type);
            String paramName = param.name.getName();
            paramSpill.name = param.name.replaceName(paramName + "-local", paramName + "-local");
            paramSpill.setStackStorage(paramStackOffset);
            dfunc.localVars.add(paramSpill);
            param.clearStorage();
        }
    }
}

