/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.funcfixup;

import ghidra.app.util.bin.format.dwarf4.funcfixup.DWARFFunctionFixup;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunction;
import ghidra.app.util.bin.format.dwarf4.next.DWARFVariable;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPointProperties;

@ExtensionPointProperties(priority=3000)
public class ThisCallingConventionDWARFFunctionFixup
implements DWARFFunctionFixup {
    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc) {
        if (dfunc.params.isEmpty() || dfunc.callingConventionName != null) {
            return;
        }
        DWARFVariable firstParam = dfunc.params.get(0);
        if (firstParam.isThis) {
            if (!firstParam.name.isAnon() && !"this".equals(firstParam.name.getOriginalName())) {
                Msg.warn((Object)this, (Object)"Renaming %s to %s in function %s@%s".formatted(firstParam.name.getName(), "this", dfunc.name.getName(), dfunc.address));
            }
            firstParam.name = firstParam.name.replaceName("this", "this");
            dfunc.callingConventionName = "__thiscall";
        }
    }
}

