/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.plugin.core.analysis.AnalysisOptionsUpdater;
import ghidra.framework.options.Options;

public class DWARFImportOptions {
    private static final String OPTION_IMPORT_DATATYPES = "Import Data Types";
    private static final String OPTION_IMPORT_DATATYPES_DESC = "Import data types defined in the DWARF debug info.";
    private static final String OPTION_PRELOAD_ALL_DIES = "Preload All DIEs";
    private static final String OPTION_PRELOAD_ALL_DIES_DESC = "Preload all DIE records. Requires more memory, but necessary for some non-standard layouts.";
    private static final String OPTION_IMPORT_FUNCS = "Import Functions";
    private static final String OPTION_IMPORT_FUNCS_DESC = "Import function information defined in the DWARF debug info\n(implies 'Import Data Types' is selected).";
    private static final String OPTION_IMPORT_LIMIT_DIE_COUNT = "Debug Item Limit";
    private static final String OPTION_IMPORT_LIMIT_DIE_COUNT_DESC = "If the number of DWARF debug items are greater than this setting, DWARF analysis will be skipped.";
    private static final String OPTION_OUTPUT_SOURCE_INFO = "Output Source Info";
    private static final String OPTION_OUTPUT_SOURCE_INFO_DESC = "Include source code location info (filename:linenumber) in comments attached to the Ghidra datatype or function or variable created.";
    private static final String OPTION_OUTPUT_DWARF_DIE_INFO = "Output DWARF DIE Info";
    private static final String OPTION_OUTPUT_DWARF_DIE_INFO_DESC = "Include DWARF DIE offset info in comments attached to the Ghidra datatype or function or variable created.";
    private static final String OPTION_NAME_LENGTH_CUTOFF = "Maximum Name Length";
    private static final String OPTION_NAME_LENGTH_CUTOFF_DESC = "Truncate symbol and type names longer than this limit.  Range 20..2000";
    private static final String OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS = "Add Lexical Block Comments";
    private static final String OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS_DESC = "Add comments to the start of lexical blocks";
    private static final String OPTION_OUTPUT_INLINE_FUNC_COMMENTS = "Add Inlined Functions Comments";
    private static final String OPTION_OUTPUT_INLINE_FUNC_COMMENTS_DESC = "Add comments to the start of inlined functions";
    private static final String OPTION_OUTPUT_FUNC_SIGS = "Create Function Signatures";
    private static final String OPTION_OUTPUT_FUNC_SIGS_DESC = "Create function signature data types for each function encountered in the DWARF debug data.";
    private static final String OPTION_TRY_PACK_STRUCTS = "Try To Pack Structs";
    private static final String OPTION_TRY_PACK_STRUCTS_DESC = "Try to pack structure/union data types.";
    private static final String OPTION_IMPORT_LOCAL_VARS = "Import Local Variable Info";
    private static final String OPTION_IMPORT_LOCAL_VARS_DESC = "Import local variable information from DWARF and attempt to create Ghidra local variables.";
    private static final String OPTION_IMPORT_DATATYPES_OLD = "Import data types";
    private static final String OPTION_PRELOAD_ALL_DIES_OLD = "Preload all DIEs";
    private static final String OPTION_IMPORT_FUNCS_OLD = "Import functions";
    private static final String OPTION_IMPORT_LIMIT_DIE_COUNT_OLD = "Debug item count limit";
    private static final String OPTION_OUTPUT_SOURCE_INFO_OLD = "Output Source info";
    private static final String OPTION_OUTPUT_DWARF_DIE_INFO_OLD = "Output DWARF DIE info";
    private static final String OPTION_NAME_LENGTH_CUTOFF_OLD = "Name length cutoff";
    private static final String OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS_OLD = "Lexical block comments";
    private static final String OPTION_OUTPUT_INLINE_FUNC_COMMENTS_OLD = "Inlined functions comments";
    private static final String OPTION_OUTPUT_FUNC_SIGS_OLD = "Output function signatures";
    private static final int DEFAULT_IMPORT_LIMIT_DIE_COUNT = 2000000;
    private AnalysisOptionsUpdater optionsUpdater = new AnalysisOptionsUpdater();
    private boolean outputDWARFLocationInfo = false;
    private boolean outputDWARFDIEInfo = false;
    private boolean elideTypedefsWithSameName = true;
    private boolean importDataTypes = true;
    private boolean importFuncs = true;
    private int importLimitDIECount = 2000000;
    private int nameLengthCutoff = 2000;
    private boolean preloadAllDIEs = false;
    private boolean outputInlineFuncComments = false;
    private boolean outputLexicalBlockComments = false;
    private boolean copyRenameAnonTypes = true;
    private boolean createFuncSignatures = true;
    private boolean organizeTypesBySourceFile = true;
    private boolean tryPackStructs = true;
    private boolean specialCaseSizedBaseTypes = true;
    private boolean importLocalVariables = true;

    public DWARFImportOptions() {
        this.optionsUpdater.registerReplacement(OPTION_IMPORT_DATATYPES, OPTION_IMPORT_DATATYPES_OLD);
        this.optionsUpdater.registerReplacement(OPTION_PRELOAD_ALL_DIES, OPTION_PRELOAD_ALL_DIES_OLD);
        this.optionsUpdater.registerReplacement(OPTION_IMPORT_FUNCS, OPTION_IMPORT_FUNCS_OLD);
        this.optionsUpdater.registerReplacement(OPTION_IMPORT_LIMIT_DIE_COUNT, OPTION_IMPORT_LIMIT_DIE_COUNT_OLD);
        this.optionsUpdater.registerReplacement(OPTION_OUTPUT_SOURCE_INFO, OPTION_OUTPUT_SOURCE_INFO_OLD);
        this.optionsUpdater.registerReplacement(OPTION_OUTPUT_DWARF_DIE_INFO, OPTION_OUTPUT_DWARF_DIE_INFO_OLD);
        this.optionsUpdater.registerReplacement(OPTION_NAME_LENGTH_CUTOFF, OPTION_NAME_LENGTH_CUTOFF_OLD);
        this.optionsUpdater.registerReplacement(OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS, OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS_OLD);
        this.optionsUpdater.registerReplacement(OPTION_OUTPUT_INLINE_FUNC_COMMENTS, OPTION_OUTPUT_INLINE_FUNC_COMMENTS_OLD);
        this.optionsUpdater.registerReplacement(OPTION_OUTPUT_FUNC_SIGS, OPTION_OUTPUT_FUNC_SIGS_OLD);
    }

    public AnalysisOptionsUpdater getOptionsUpdater() {
        return this.optionsUpdater;
    }

    public boolean isOutputSourceLocationInfo() {
        return this.outputDWARFLocationInfo;
    }

    public void setOutputSourceLocationInfo(boolean output_DWARF_location_info) {
        this.outputDWARFLocationInfo = output_DWARF_location_info;
    }

    public boolean isOutputDIEInfo() {
        return this.outputDWARFDIEInfo;
    }

    public void setOutputDIEInfo(boolean output_DWARF_die_info) {
        this.outputDWARFDIEInfo = output_DWARF_die_info;
    }

    public boolean isElideTypedefsWithSameName() {
        return this.elideTypedefsWithSameName;
    }

    public void setElideTypedefsWithSameName(boolean elide_typedefs_with_same_name) {
        this.elideTypedefsWithSameName = elide_typedefs_with_same_name;
    }

    public boolean isImportDataTypes() {
        return this.importDataTypes;
    }

    public void setImportDataTypes(boolean importDataTypes) {
        this.importDataTypes = importDataTypes;
    }

    public boolean isImportFuncs() {
        return this.importFuncs;
    }

    public void setImportFuncs(boolean output_Funcs) {
        this.importFuncs = output_Funcs;
    }

    public int getImportLimitDIECount() {
        return this.importLimitDIECount;
    }

    public void setImportLimitDIECount(int import_limit_die_count) {
        this.importLimitDIECount = import_limit_die_count;
    }

    public int getNameLengthCutoff() {
        return this.nameLengthCutoff;
    }

    public void setNameLengthCutoff(int name_length_cutoff) {
        this.nameLengthCutoff = name_length_cutoff;
    }

    public boolean isPreloadAllDIEs() {
        return this.preloadAllDIEs;
    }

    public void setPreloadAllDIEs(boolean b) {
        this.preloadAllDIEs = b;
    }

    public boolean isOutputInlineFuncComments() {
        return this.outputInlineFuncComments;
    }

    public void setOutputInlineFuncComments(boolean output_InlineFunc_comments) {
        this.outputInlineFuncComments = output_InlineFunc_comments;
    }

    public boolean isOutputLexicalBlockComments() {
        return this.outputLexicalBlockComments;
    }

    public void setOutputLexicalBlockComments(boolean output_LexicalBlock_comments) {
        this.outputLexicalBlockComments = output_LexicalBlock_comments;
    }

    public boolean isCopyRenameAnonTypes() {
        return this.copyRenameAnonTypes;
    }

    public void setCopyRenameAnonTypes(boolean b) {
        this.copyRenameAnonTypes = b;
    }

    public boolean isCreateFuncSignatures() {
        return this.createFuncSignatures;
    }

    public void setCreateFuncSignatures(boolean createFuncSignatures) {
        this.createFuncSignatures = createFuncSignatures;
    }

    public boolean isOrganizeTypesBySourceFile() {
        return this.organizeTypesBySourceFile;
    }

    public void setOrganizeTypesBySourceFile(boolean organizeTypesBySourceFile) {
        this.organizeTypesBySourceFile = organizeTypesBySourceFile;
    }

    public boolean isTryPackStructs() {
        return this.tryPackStructs;
    }

    public void setTryPackDataTypes(boolean tryPackStructs) {
        this.tryPackStructs = tryPackStructs;
    }

    public boolean isSpecialCaseSizedBaseTypes() {
        return this.specialCaseSizedBaseTypes;
    }

    public void setSpecialCaseSizedBaseTypes(boolean b) {
        this.specialCaseSizedBaseTypes = b;
    }

    public boolean isImportLocalVariables() {
        return this.importLocalVariables;
    }

    public void setImportLocalVariables(boolean importLocalVariables) {
        this.importLocalVariables = importLocalVariables;
    }

    public void registerOptions(Options options) {
        options.registerOption(OPTION_IMPORT_DATATYPES, (Object)this.isImportDataTypes(), null, OPTION_IMPORT_DATATYPES_DESC);
        options.registerOption(OPTION_PRELOAD_ALL_DIES, (Object)this.isPreloadAllDIEs(), null, OPTION_PRELOAD_ALL_DIES_DESC);
        options.registerOption(OPTION_IMPORT_FUNCS, (Object)this.isImportFuncs(), null, OPTION_IMPORT_FUNCS_DESC);
        options.registerOption(OPTION_OUTPUT_DWARF_DIE_INFO, (Object)this.isOutputDIEInfo(), null, OPTION_OUTPUT_DWARF_DIE_INFO_DESC);
        options.registerOption(OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS, (Object)this.isOutputLexicalBlockComments(), null, OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS_DESC);
        options.registerOption(OPTION_OUTPUT_INLINE_FUNC_COMMENTS, (Object)this.isOutputInlineFuncComments(), null, OPTION_OUTPUT_INLINE_FUNC_COMMENTS_DESC);
        options.registerOption(OPTION_OUTPUT_SOURCE_INFO, (Object)this.isOutputSourceLocationInfo(), null, OPTION_OUTPUT_SOURCE_INFO_DESC);
        options.registerOption(OPTION_IMPORT_LIMIT_DIE_COUNT, (Object)this.getImportLimitDIECount(), null, OPTION_IMPORT_LIMIT_DIE_COUNT_DESC);
        options.registerOption(OPTION_NAME_LENGTH_CUTOFF, (Object)this.getNameLengthCutoff(), null, OPTION_NAME_LENGTH_CUTOFF_DESC);
        options.registerOption(OPTION_OUTPUT_FUNC_SIGS, (Object)this.isCreateFuncSignatures(), null, OPTION_OUTPUT_FUNC_SIGS_DESC);
        options.registerOption(OPTION_TRY_PACK_STRUCTS, (Object)this.isTryPackStructs(), null, OPTION_TRY_PACK_STRUCTS_DESC);
        options.registerOption(OPTION_IMPORT_LOCAL_VARS, (Object)this.isImportLocalVariables(), null, OPTION_IMPORT_LOCAL_VARS_DESC);
    }

    public void optionsChanged(Options options) {
        this.setOutputDIEInfo(options.getBoolean(OPTION_OUTPUT_DWARF_DIE_INFO, this.isOutputDIEInfo()));
        this.setPreloadAllDIEs(options.getBoolean(OPTION_PRELOAD_ALL_DIES, this.isPreloadAllDIEs()));
        this.setOutputSourceLocationInfo(options.getBoolean(OPTION_OUTPUT_SOURCE_INFO, this.isOutputSourceLocationInfo()));
        this.setOutputLexicalBlockComments(options.getBoolean(OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS, this.isOutputLexicalBlockComments()));
        this.setOutputInlineFuncComments(options.getBoolean(OPTION_OUTPUT_INLINE_FUNC_COMMENTS, this.isOutputInlineFuncComments()));
        this.setImportDataTypes(options.getBoolean(OPTION_IMPORT_DATATYPES, this.isImportDataTypes()));
        this.setImportFuncs(options.getBoolean(OPTION_IMPORT_FUNCS, this.isImportFuncs()));
        this.setImportLimitDIECount(options.getInt(OPTION_IMPORT_LIMIT_DIE_COUNT, this.getImportLimitDIECount()));
        this.setNameLengthCutoff(options.getInt(OPTION_NAME_LENGTH_CUTOFF, this.getNameLengthCutoff()));
        this.setCreateFuncSignatures(options.getBoolean(OPTION_OUTPUT_FUNC_SIGS, this.isCreateFuncSignatures()));
        this.setTryPackDataTypes(options.getBoolean(OPTION_TRY_PACK_STRUCTS, this.isTryPackStructs()));
        this.setImportLocalVariables(options.getBoolean(OPTION_IMPORT_LOCAL_VARS, this.isImportLocalVariables()));
    }
}

