/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next.sectionprovider;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProvider;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileCache;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;

public class CompressedSectionProvider
implements DWARFSectionProvider {
    private static final int ZLIB_MAGIC_BE = 1514948930;
    private final DWARFSectionProvider sp;
    private Map<String, ByteProvider> decompressedSectionCache = new HashMap<String, ByteProvider>();

    public CompressedSectionProvider(DWARFSectionProvider sp) {
        this.sp = sp;
    }

    @Override
    public boolean hasSection(String ... sectionNames) {
        if (this.sp.hasSection(sectionNames)) {
            return true;
        }
        for (String sectionName : sectionNames) {
            if (this.sp.hasSection("z" + sectionName)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteProvider getSectionAsByteProvider(String sectionName, TaskMonitor monitor) throws IOException {
        ByteProvider bp = this.sp.getSectionAsByteProvider(sectionName, monitor);
        if (bp != null) {
            return bp;
        }
        bp = this.decompressedSectionCache.get(sectionName);
        if (bp != null) {
            return bp;
        }
        bp = this.sp.getSectionAsByteProvider("z" + sectionName, monitor);
        if (bp != null) {
            FileSystemService fsService = FileSystemService.getInstance();
            try (InputStream is = this.getInputStreamForCompressedSection(bp);){
                ByteProvider byteProvider;
                block17: {
                    FileCache.FileCacheEntryBuilder tmpFile = fsService.createTempFile(bp.length());
                    try {
                        FSUtilities.streamCopy(is, tmpFile, monitor);
                        FileCache.FileCacheEntry fce = tmpFile.finish();
                        ByteProvider decompressedBP = fsService.getNamedTempFile(fce, "uncompressed_" + sectionName);
                        this.decompressedSectionCache.put(sectionName, decompressedBP);
                        byteProvider = decompressedBP;
                        if (tmpFile == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (tmpFile != null) {
                            try {
                                tmpFile.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    tmpFile.close();
                }
                return byteProvider;
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
        return null;
    }

    private InputStream getInputStreamForCompressedSection(ByteProvider compressedBP) throws IOException {
        BinaryReader reader = new BinaryReader(compressedBP, false);
        int magic = reader.readInt(0L);
        if (magic == 1514948930) {
            int streamStart = 12;
            return new InflaterInputStream(compressedBP.getInputStream(streamStart));
        }
        throw new IOException("Unknown compressed section format: " + Integer.toHexString(magic));
    }

    @Override
    public void close() {
        for (ByteProvider bp : this.decompressedSectionCache.values()) {
            FSUtilities.uncheckedClose(bp, null);
        }
        this.decompressedSectionCache.clear();
        this.sp.close();
    }
}

