/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.golang.rtti.GoFuncData;
import ghidra.app.util.bin.format.golang.rtti.GoFunctabEntry;
import ghidra.app.util.bin.format.golang.rtti.GoItab;
import ghidra.app.util.bin.format.golang.rtti.GoPcHeader;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringUTF8DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@StructureMapping(structureName="runtime.moduledata")
public class GoModuledata
implements StructureMarkup<GoModuledata> {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoModuledata> structureContext;
    @FieldMapping
    @MarkupReference
    private long pcHeader;
    @FieldMapping
    @MarkupReference
    private long text;
    @FieldMapping(fieldName={"types"})
    private long typesOffset;
    @FieldMapping(fieldName={"etypes"})
    private long typesEndOffset;
    @FieldMapping(optional=true)
    private long gofunc;
    @FieldMapping(fieldName={"typelinks"})
    private GoSlice typeLinks;
    @FieldMapping
    private GoSlice funcnametab;
    @FieldMapping
    private GoSlice cutab;
    @FieldMapping
    private GoSlice filetab;
    @FieldMapping
    private GoSlice pctab;
    @FieldMapping
    private GoSlice pclntable;
    @FieldMapping
    private GoSlice ftab;
    @FieldMapping
    private GoSlice itablinks;
    @FieldMapping
    private GoSlice textsectmap;

    public boolean matchesPclntab(GoPcHeader pclntab) {
        return (!pclntab.hasTextStart() || pclntab.getTextStart().equals((Object)this.getText())) && pclntab.getFuncnameAddress().equals((Object)this.funcnametab.getArrayAddress());
    }

    @Markup
    public GoPcHeader getPcHeader() throws IOException {
        return this.programContext.readStructure(GoPcHeader.class, this.pcHeader);
    }

    public Address getText() {
        return this.programContext.getCodeAddress(this.text);
    }

    public long getTypesOffset() {
        return this.typesOffset;
    }

    public long getTypesEndOffset() {
        return this.typesEndOffset;
    }

    public long getGofunc() {
        return this.gofunc;
    }

    public GoFuncData getFuncDataInstance(long offset) throws IOException {
        return this.programContext.readStructure(GoFuncData.class, this.pclntable.getArrayOffset() + offset);
    }

    public boolean containsFuncDataInstance(long offset) {
        return this.pclntable.containsOffset(offset, 1);
    }

    public GoSlice getFunctabEntriesSlice() {
        long sliceElementCount = this.ftab.getLen() > 0L ? this.ftab.getLen() - 1L : 0L;
        int entryLen = this.programContext.getStructureMappingInfo(GoFunctabEntry.class).getStructureLength();
        GoSlice subSlice = this.ftab.getSubSlice(0L, sliceElementCount, entryLen);
        return subSlice;
    }

    public boolean isValid() {
        MemoryBlock txtBlock = this.programContext.getProgram().getMemory().getBlock(".text");
        if (txtBlock != null && !txtBlock.contains(this.getText())) {
            return false;
        }
        MemoryBlock typelinkBlock = this.programContext.getProgram().getMemory().getBlock(".typelink");
        if (typelinkBlock != null && typelinkBlock.getStart().getOffset() != this.typeLinks.getArrayOffset()) {
            return false;
        }
        return this.typeLinks.isFull() && this.filetab.isFull() && this.pctab.isFull() && this.pclntable.isFull() && this.ftab.isFull();
    }

    public GoSlice getFuncnametab() {
        return this.funcnametab;
    }

    public List<GoFuncData> getAllFunctionData() throws IOException {
        List<GoFunctabEntry> functabentries = this.getFunctabEntriesSlice().readList(GoFunctabEntry.class);
        ArrayList<GoFuncData> result = new ArrayList<GoFuncData>();
        for (GoFunctabEntry functabEntry : functabentries) {
            result.add(functabEntry.getFuncData());
        }
        return result;
    }

    public GoSlice getCutab() {
        return this.cutab;
    }

    public GoSlice getFiletab() {
        return this.filetab;
    }

    public String getFilename(long fileoff) throws IOException {
        return this.programContext.getReader(this.filetab.getElementOffset(1L, fileoff)).readNextUtf8String();
    }

    public GoSlice getPctab() {
        return this.pctab;
    }

    public GoRttiMapper getGoBinary() {
        return this.programContext;
    }

    @Override
    public StructureContext<GoModuledata> getStructureContext() {
        return this.structureContext;
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException, CancelledException {
        this.typeLinks.markupArray("moduledata.typeLinks", null, this.programContext.getInt32DT(), false, session);
        this.typeLinks.markupElementReferences(4, this.getTypeList(), session);
        this.itablinks.markupArray("moduledata.itablinks", null, GoItab.class, true, session);
        this.markupStringTable(this.funcnametab.getArrayAddress(), this.funcnametab.getLen(), session);
        this.markupStringTable(this.filetab.getArrayAddress(), this.filetab.getLen(), session);
        GoSlice subSlice = this.getFunctabEntriesSlice();
        subSlice.markupArray("moduledata.ftab", null, GoFunctabEntry.class, false, session);
        subSlice.markupArrayElements(GoFunctabEntry.class, session);
        Structure textsectDT = this.programContext.getGhidraDataType("runtime.textsect", Structure.class);
        if (textsectDT != null) {
            this.textsectmap.markupArray("runtime.textsectionmap", null, (DataType)textsectDT, false, session);
        }
    }

    @Markup
    public List<GoItab> getItabs() throws IOException {
        long[] itabAddrs;
        ArrayList<GoItab> result = new ArrayList<GoItab>();
        for (long itabAddr : itabAddrs = this.itablinks.readUIntList(this.programContext.getPtrSize())) {
            GoItab itab = this.programContext.readStructure(GoItab.class, itabAddr);
            result.add(itab);
        }
        return result;
    }

    private void markupStringTable(Address addr, long stringTableLength, MarkupSession session) {
        StringUTF8DataType stringDT = StringUTF8DataType.dataType;
        long startOfString = addr.getOffset();
        long endOfStringTable = startOfString + stringTableLength;
        BinaryReader reader = this.programContext.getReader(startOfString);
        try {
            while (startOfString < endOfStringTable) {
                reader.readNextUtf8String();
                long len = reader.getPointerIndex() - startOfString;
                if (len > 0L && len < Integer.MAX_VALUE) {
                    Address stringAddr = addr.getNewAddress(startOfString);
                    session.markupAddress(stringAddr, (DataType)stringDT, (int)len);
                }
                startOfString = reader.getPointerIndex();
            }
        }
        catch (IOException e) {
            Msg.warn((Object)this, (Object)("Failed when marking up string table at: " + addr), (Throwable)e);
        }
    }

    @Markup
    public Iterator<GoType> iterateTypes() throws IOException {
        return this.getTypeList().stream().map(addr -> {
            try {
                return this.programContext.getGoType((Address)addr);
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).iterator();
    }

    public List<Address> getTypeList() throws IOException {
        long[] typeOffsets = this.typeLinks.readUIntList(4);
        Address typesBaseAddr = this.programContext.getDataAddress(this.typesOffset);
        List<Address> result = Arrays.stream(typeOffsets).mapToObj(offset -> typesBaseAddr.add(offset)).toList();
        return result;
    }

    static GoModuledata getFirstModuledata(GoRttiMapper context) throws IOException {
        Program program = context.getProgram();
        Symbol firstModuleDataSymbol = SymbolUtilities.getUniqueSymbol((Program)program, (String)"runtime.firstmoduledata");
        if (firstModuleDataSymbol == null) {
            return null;
        }
        return context.readStructure(GoModuledata.class, firstModuleDataSymbol.getAddress());
    }

    static GoModuledata findFirstModule(GoRttiMapper context, Address pclntabAddress, GoPcHeader pclntab, AddressRange range, TaskMonitor monitor) throws IOException {
        if (range == null) {
            return null;
        }
        Program program = context.getProgram();
        Memory memory = program.getMemory();
        int ptrSize = context.getPtrSize();
        byte[] searchBytes = new byte[ptrSize];
        context.getDataConverter().putValue(pclntabAddress.getOffset(), ptrSize, searchBytes, 0);
        Address moduleAddr = memory.findBytes(range.getMinAddress(), range.getMaxAddress(), searchBytes, null, true, monitor);
        if (moduleAddr == null) {
            return null;
        }
        GoModuledata moduleData = context.readStructure(GoModuledata.class, moduleAddr);
        return moduleData.matchesPclntab(pclntab) ? moduleData : null;
    }
}

