/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.structmapping;

import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataInstanceHelper;
import ghidra.app.util.bin.format.golang.structmapping.DataTypeMapper;
import ghidra.app.util.bin.format.golang.structmapping.FieldContext;
import ghidra.app.util.bin.format.golang.structmapping.FieldMappingInfo;
import ghidra.app.util.bin.format.golang.structmapping.FieldMarkupFunction;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMappingInfo;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkupFunction;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MarkupSession {
    protected Program program;
    protected DataTypeMapper mappingContext;
    protected Set<Address> markedupStructs = new HashSet<Address>();
    protected AddressSet markedupAddrs = new AddressSet();
    protected TaskMonitor monitor;

    public MarkupSession(DataTypeMapper programContext, TaskMonitor monitor) {
        this.mappingContext = programContext;
        this.monitor = monitor;
        this.program = programContext.getProgram();
    }

    public Program getProgram() {
        return this.program;
    }

    public DataTypeMapper getMappingContext() {
        return this.mappingContext;
    }

    public AddressSet getMarkedupAddresses() {
        return this.markedupAddrs;
    }

    public <T> void markup(T obj, boolean nested) throws IOException, CancelledException {
        this.monitor.checkCancelled();
        if (obj == null) {
            return;
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            for (Object listElement : list) {
                this.markup(listElement, nested);
            }
        } else if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                this.markup(Array.get(obj, i), nested);
            }
        } else if (obj instanceof Iterator) {
            Iterator it = (Iterator)obj;
            while (it.hasNext()) {
                Object itElement = it.next();
                this.markup(itElement, nested);
            }
        } else {
            StructureContext<T> structureContext = this.mappingContext.getStructureContextOfInstance(obj);
            if (structureContext == null) {
                throw new IllegalArgumentException();
            }
            this.monitor.increment();
            this.markupStructure(structureContext, nested);
        }
    }

    public void markupAddress(Address addr, DataType dt) throws IOException {
        this.markupAddress(addr, dt, -1);
    }

    public void markupAddress(Address addr, DataType dt, int length) throws IOException {
        DWARFDataInstanceHelper dihUtil = new DWARFDataInstanceHelper(this.program).setAllowTruncating(false);
        if (dihUtil.isDataTypeCompatibleWithAddress(dt, addr)) {
            try {
                Data data = DataUtilities.createData((Program)this.program, (Address)addr, (DataType)dt, (int)length, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
                this.markedupAddrs.add(data.getMinAddress(), data.getMaxAddress());
            }
            catch (CodeUnitInsertionException e) {
                throw new IOException(e);
            }
        }
    }

    public void markupAddressIfUndefined(Address addr, DataType dt) throws IOException {
        Data data = DataUtilities.getDataAtAddress((Program)this.program, (Address)addr);
        if (data == null || Undefined.isUndefined((DataType)data.getBaseDataType())) {
            this.markupAddress(addr, dt);
        }
    }

    public <T> void labelStructure(T obj, String symbolName, String namespaceName) throws IOException {
        Address addr = this.mappingContext.getAddressOfStructure(obj);
        this.labelAddress(addr, symbolName, namespaceName);
    }

    public void labelAddress(Address addr, String symbolName) throws IOException {
        this.labelAddress(addr, symbolName, null);
    }

    public void labelAddress(Address addr, String symbolName, String namespaceName) throws IOException {
        try {
            SymbolTable symbolTable = this.program.getSymbolTable();
            Namespace ns = null;
            try {
                ns = namespaceName == null || namespaceName.isBlank() ? this.program.getGlobalNamespace() : this.program.getSymbolTable().getOrCreateNameSpace(this.program.getGlobalNamespace(), namespaceName, SourceType.IMPORTED);
            }
            catch (DuplicateNameException e) {
                ns = this.program.getGlobalNamespace();
            }
            symbolName = SymbolUtilities.replaceInvalidChars((String)symbolName, (boolean)true);
            Symbol newLabelSym = symbolTable.createLabel(addr, symbolName, ns, SourceType.IMPORTED);
            newLabelSym.setPrimary();
        }
        catch (InvalidInputException e) {
            throw new IOException(e);
        }
    }

    public void appendComment(FieldContext<?> fieldContext, int commentType, String prefix, String comment, String sep) throws IOException {
        DWARFUtil.appendComment(this.program, fieldContext.getAddress(), commentType, prefix, comment, sep);
    }

    public void appendComment(StructureContext<?> structureContext, int commentType, String prefix, String comment, String sep) throws IOException {
        DWARFUtil.appendComment(this.program, structureContext.getStructureAddress(), commentType, prefix, comment, sep);
    }

    public void appendComment(Function func, String prefix, String comment) {
        if (func != null) {
            DWARFUtil.appendComment(this.program, func.getEntryPoint(), 3, prefix, comment, "\n");
        }
    }

    public <T> void markupStructure(StructureContext<T> structureContext, boolean nested) throws IOException, CancelledException {
        StructureMarkup sm;
        Address addr = structureContext.getStructureAddress();
        if (!nested && !this.markedupStructs.add(addr)) {
            return;
        }
        T instance = structureContext.getStructureInstance();
        if (!nested) {
            try {
                Structure structDT = structureContext.getStructureDataType();
                if (structDT.isDeleted()) {
                    throw new IOException("Structure mapping data type invalid: " + structDT);
                }
                this.markupAddress(addr, (DataType)structDT);
            }
            catch (IOException e) {
                StructureMappingInfo<T> mappingInfo = structureContext.getMappingInfo();
                throw new IOException("Markup failed for structure %s at %s".formatted(mappingInfo.getDescription(), addr), e);
            }
            if (instance instanceof StructureMarkup) {
                sm = (StructureMarkup)instance;
                String structureLabel = sm.getStructureLabel();
                String namespaceName = sm.getStructureNamespace();
                if (structureLabel != null && !structureLabel.isBlank()) {
                    this.labelAddress(addr, structureLabel, namespaceName);
                }
            }
        }
        this.markupFields(structureContext);
        if (instance instanceof StructureMarkup) {
            sm = (StructureMarkup)instance;
            sm.additionalMarkup(this);
        }
    }

    <T> void markupFields(StructureContext<T> structureContext) throws IOException, CancelledException {
        T structureInstance = structureContext.getStructureInstance();
        StructureMappingInfo<T> mappingInfo = structureContext.getMappingInfo();
        for (FieldMappingInfo<T> fieldMappingInfo : mappingInfo.getFields()) {
            for (FieldMarkupFunction<T> func : fieldMappingInfo.getMarkupFuncs()) {
                FieldContext<T> fieldContext = structureContext.createFieldContext(fieldMappingInfo, false);
                func.markupField(fieldContext, this);
            }
        }
        if (structureInstance instanceof StructureMarkup) {
            StructureMarkup sm = (StructureMarkup)structureInstance;
            for (Object externalInstance : sm.getExternalInstancesToMarkup()) {
                this.markup(externalInstance, false);
            }
        }
        for (StructureMarkupFunction structureMarkupFunction : mappingInfo.getMarkupFuncs()) {
            structureMarkupFunction.markupStructure(structureContext, this);
        }
    }

    public void markupArrayElementReferences(Address arrayAddr, int elementSize, List<Address> targetAddrs) throws IOException {
        if (!targetAddrs.isEmpty()) {
            ReferenceManager refMgr = this.program.getReferenceManager();
            for (Address targetAddr : targetAddrs) {
                if (targetAddr != null) {
                    refMgr.addMemoryReference(arrayAddr, targetAddr, RefType.DATA, SourceType.IMPORTED, 0);
                }
                arrayAddr = arrayAddr.add((long)elementSize);
            }
        }
    }

    public Function createFunctionIfMissing(String name, Namespace ns, Address addr) {
        Function function = this.program.getListing().getFunctionAt(addr);
        if (function == null) {
            if (!this.program.getMemory().getLoadedAndInitializedAddressSet().contains(addr)) {
                Msg.warn((Object)this, (Object)"Unable to create function not contained within loaded memory: %s@%s".formatted(name, addr));
                return null;
            }
            try {
                function = this.program.getFunctionManager().createFunction(name, ns, addr, (AddressSetView)new AddressSet(addr), SourceType.IMPORTED);
            }
            catch (OverlappingFunctionException | InvalidInputException | IllegalArgumentException e) {
                Msg.error((Object)this, (Object)e);
                return null;
            }
        }
        try {
            function.setName(name, SourceType.IMPORTED);
            function.setParentNamespace(ns);
        }
        catch (CircularDependencyException | DuplicateNameException | InvalidInputException e) {
            Msg.error((Object)this, (Object)e);
        }
        return function;
    }

    public void addReference(FieldContext<?> fieldContext, Address refDest) {
        ReferenceManager refMgr = this.program.getReferenceManager();
        Address fieldAddr = fieldContext.getAddress();
        refMgr.addMemoryReference(fieldAddr, refDest, RefType.DATA, SourceType.IMPORTED, 0);
    }
}

