/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedFixupHeader;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedStartsInImage;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedStartsInSegment;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class DyldChainedFixupsCommand
extends LinkEditDataCommand {
    private DyldChainedFixupHeader chainHeader;

    DyldChainedFixupsCommand(BinaryReader loadCommandReader, BinaryReader dataReader) throws IOException {
        super(loadCommandReader, dataReader);
        this.chainHeader = new DyldChainedFixupHeader(dataReader);
    }

    @Override
    public String getCommandName() {
        return "dyld_chained_fixups_command";
    }

    @Override
    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address addr = this.fileOffsetToAddress(program, header, this.dataoff, this.datasize);
        if (addr == null) {
            return;
        }
        super.markup(program, header, source, monitor, log);
        try {
            DataUtilities.createData((Program)program, (Address)addr, (DataType)this.chainHeader.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            this.chainHeader.markup(program, addr, header, monitor, log);
        }
        catch (Exception e) {
            log.appendMsg(DyldChainedFixupsCommand.class.getSimpleName(), "Failed to markup: " + this.getContextualName(source, null));
        }
    }

    @Override
    public void markupRawBinary(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        try {
            super.markupRawBinary(header, api, baseAddress, parentModule, monitor, log);
            List addrs = api.getCurrentProgram().getMemory().locateAddressesForFileOffset((long)this.getLinkerDataOffset());
            if (addrs.size() <= 0) {
                throw new Exception("Chain Header does not exist in program");
            }
            Address dyldChainedHeader = (Address)addrs.get(0);
            this.markupChainedFixupHeader(header, api, dyldChainedHeader, parentModule, monitor);
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
            log.appendException((Throwable)e);
        }
    }

    private void markupChainedFixupHeader(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor) throws DuplicateNameException, IOException, CodeUnitInsertionException, Exception {
        DataType cHeader = this.chainHeader.toDataType();
        api.createData(baseAddress, cHeader);
        Address segsAddr = baseAddress.add((long)this.chainHeader.getStartsOffset());
        DyldChainedStartsInImage chainedStartsInImage = this.chainHeader.getChainedStartsInImage();
        int[] segInfoOffset = chainedStartsInImage.getSegInfoOffset();
        List<DyldChainedStartsInSegment> chainedStarts = chainedStartsInImage.getChainedStarts();
        for (int i = 0; i < chainedStarts.size(); ++i) {
            DyldChainedStartsInSegment startsInSeg = chainedStarts.get(i);
            DataType dataType = startsInSeg.toDataType();
            api.createData(segsAddr.add((long)segInfoOffset[i]), dataType);
        }
    }

    public DyldChainedFixupHeader getChainHeader() {
        return this.chainHeader;
    }
}

