/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.chained;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedFixupHeader;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedImport;
import ghidra.app.util.bin.format.macho.commands.dyld.BindingTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldChainedImports {
    private int importsCount;
    private int importsFormat;
    private long importsOffset;
    private DyldChainedImport[] chainedImports;

    DyldChainedImports(BinaryReader reader, DyldChainedFixupHeader cfh) throws IOException {
        long ptrIndex;
        this.importsOffset = ptrIndex = reader.getPointerIndex();
        this.importsCount = cfh.getImportsCount();
        this.importsFormat = cfh.getImportsFormat();
        ArrayList<DyldChainedImport> starts = new ArrayList<DyldChainedImport>();
        for (int i = 0; i < this.importsCount; ++i) {
            starts.add(new DyldChainedImport(reader, cfh, this.importsFormat));
        }
        this.chainedImports = (DyldChainedImport[])starts.toArray(DyldChainedImport[]::new);
    }

    public DyldChainedImports(List<BindingTable.Binding> bindings) {
        this.importsCount = bindings.size();
        this.chainedImports = new DyldChainedImport[bindings.size()];
        int i = 0;
        for (BindingTable.Binding binding : bindings) {
            this.chainedImports[i++] = new DyldChainedImport(binding);
        }
    }

    public int getImportsCount() {
        return this.importsCount;
    }

    public long getImportsOffset() {
        return this.importsOffset;
    }

    public DyldChainedImport[] getChainedImports() {
        return this.chainedImports;
    }

    public DyldChainedImport getChainedImport(int ordinal) {
        if (ordinal < 0 || ordinal >= this.importsCount) {
            return null;
        }
        return this.chainedImports[ordinal];
    }

    public void initSymbols(BinaryReader reader, DyldChainedFixupHeader dyldChainedFixupHeader) throws IOException {
        long ptrIndex = reader.getPointerIndex();
        for (DyldChainedImport dyldChainedImport : this.chainedImports) {
            reader.setPointerIndex(ptrIndex + dyldChainedImport.getNameOffset());
            dyldChainedImport.initString(reader);
        }
    }
}

