/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.format.pe.PEx64UnwindInfo;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.AssertException;

public class PEx64UnwindInfoDataType
extends DynamicDataType {
    public static final PEx64UnwindInfoDataType INSTANCE = new PEx64UnwindInfoDataType();
    private static final int UNWIND_VERSION_FIELD_LENGTH = 3;
    private static final int UNWIND_FLAGS_FIELD_LENGTH = 5;
    private static final int UNWIND_FRAME_REGISTER_LENGTH = 4;
    private static final int UNWIND_FRAME_OFFSET_LENGTH = 4;
    private static final int UNWIND_OP_FIELD_LENGTH = 4;
    private static final int UNWIND_OP_INFO_FIELD_LENGTH = 4;
    private static final DataType BYTE = ByteDataType.dataType;
    private static final DataType IBO32 = new IBO32DataType();
    private static EnumDataType unwindInfoFlagsEnum;
    private static EnumDataType unwindCodeOpcodeEnum;

    public PEx64UnwindInfoDataType() {
        this(null);
    }

    public PEx64UnwindInfoDataType(DataTypeManager dtm) {
        super("PEx64_UnwindInfo", dtm);
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new PEx64UnwindInfoDataType(dtm);
    }

    public String getDescription() {
        return "Dynamic structure for PE x86-64 Exception UNWIND_INFO";
    }

    public String getMnemonic(Settings settings) {
        return "UNWIND_INFO";
    }

    public String getDefaultLabelPrefix() {
        return "UNWIND_INFO";
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    private Structure getStructure(MemBuffer buf) {
        StructureDataType struct;
        try {
            byte flags = (byte)(buf.getByte(0) >> 3);
            struct = new StructureDataType("UNWIND_INFO", 0, this.dataMgr);
            struct.setPackingEnabled(true);
            try {
                struct.addBitField(BYTE, 3, "Version", null);
                struct.addBitField((DataType)this.defineUnwindInfoFlags(), 5, "Flags", null);
                struct.add(BYTE, "SizeOfProlog", null);
                struct.add(BYTE, "CountOfUnwindCodes", null);
                struct.addBitField(BYTE, 4, "FrameRegister", null);
                struct.addBitField(BYTE, 4, "FrameOffset", null);
                byte countOfUnwindCodes = buf.getByte(2);
                if (countOfUnwindCodes > 0) {
                    ArrayDataType unwindInfoArray = new ArrayDataType((DataType)this.defineUnwindCodeStructure(), (int)countOfUnwindCodes, -1);
                    struct.add((DataType)unwindInfoArray, "UnwindCodes", null);
                }
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException((Throwable)e);
            }
            if (this.hasExceptionHandler(flags) || this.hasUnwindHandler(flags)) {
                struct.add(IBO32, "ExceptionHandler", null);
                if (this.hasUnwindHandler(flags)) {
                    struct.add((DataType)new ArrayDataType((DataType)UnsignedLongDataType.dataType, 0, -1), "ExceptionData", null);
                }
            } else if (this.hasChainedUnwindInfo(flags)) {
                struct.add(IBO32, "FunctionStartAddress", null);
                struct.add(IBO32, "FunctionEndAddress", null);
                struct.add(IBO32, "FunctionUnwindInfoAddress", null);
            }
        }
        catch (MemoryAccessException e) {
            return null;
        }
        return struct;
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        Structure struct = this.getStructure(buf);
        if (struct == null) {
            return null;
        }
        return struct.getComponents();
    }

    private boolean hasExceptionHandler(int flags) {
        return (flags & 1) == 1;
    }

    private boolean hasUnwindHandler(int flags) {
        return (flags & 2) == 2;
    }

    private boolean hasChainedUnwindInfo(int flags) {
        return (flags & 4) == 4;
    }

    private Structure defineUnwindCodeStructure() {
        StructureDataType unwindCode = new StructureDataType("UnwindCode", 0, this.dataMgr);
        unwindCode.setPackingEnabled(true);
        try {
            unwindCode.add(BYTE, "OffsetInProlog", null);
            unwindCode.addBitField((DataType)PEx64UnwindInfoDataType.defineUnwindOpCodeEnum(), 4, "UnwindOpCode", null);
            unwindCode.addBitField(BYTE, 4, "UnwindOpInfo", null);
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException((Throwable)e);
        }
        return unwindCode;
    }

    private EnumDataType defineUnwindInfoFlags() {
        if (unwindInfoFlagsEnum == null) {
            unwindInfoFlagsEnum = new EnumDataType("UNW_FLAGS", 1);
            unwindInfoFlagsEnum.add("UNW_FLAG_NHANDLER", 0L);
            unwindInfoFlagsEnum.add("UNW_FLAG_EHANDLER", 1L);
            unwindInfoFlagsEnum.add("UNW_FLAG_UHANDLER", 2L);
            unwindInfoFlagsEnum.add("UNW_FLAG_CHAININFO", 4L);
        }
        return unwindInfoFlagsEnum;
    }

    private static synchronized EnumDataType defineUnwindOpCodeEnum() {
        if (unwindCodeOpcodeEnum == null) {
            unwindCodeOpcodeEnum = new EnumDataType("UNWIND_CODE_OPCODE", 1);
            for (PEx64UnwindInfo.UNWIND_CODE_OPCODE value : PEx64UnwindInfo.UNWIND_CODE_OPCODE.values()) {
                unwindCodeOpcodeEnum.add(value.name(), (long)value.id);
            }
        }
        return unwindCodeOpcodeEnum;
    }
}

