/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledTemplate;
import ghidra.app.util.demangler.DemanglerUtil;
import org.apache.commons.lang3.StringUtils;

public class DemangledType
implements Demangled {
    protected String mangled;
    private String originalDemangled;
    private String demangledName;
    private String name;
    protected Demangled namespace;
    protected DemangledTemplate template;
    private boolean isConst;
    private boolean isVolatile;

    public DemangledType(String mangled, String originaDemangled, String name) {
        this.mangled = mangled;
        this.originalDemangled = originaDemangled;
        this.setName(name);
    }

    @Override
    public String getDemangledName() {
        return this.demangledName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name cannot be blank");
        }
        this.demangledName = name;
        this.name = name;
        if (name != null) {
            this.name = DemanglerUtil.stripSuperfluousSignatureSpaces(name).replace(' ', '_');
        }
    }

    @Override
    public String getOriginalDemangled() {
        return this.originalDemangled;
    }

    @Override
    public String getMangledString() {
        return this.mangled;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setConst() {
        this.isConst = true;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setVolatile() {
        this.isVolatile = true;
    }

    @Override
    public Demangled getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(Demangled namespace) {
        if (this == namespace) {
            throw new IllegalArgumentException("Attempt to set this.namespace == this!");
        }
        this.namespace = namespace;
    }

    public DemangledTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(DemangledTemplate template) {
        this.template = template;
    }

    @Override
    public String getSignature() {
        return this.getNamespaceName();
    }

    @Override
    public String getNamespaceString() {
        return this.getName(true);
    }

    private String getName(boolean includeNamespace) {
        StringBuilder buffer = new StringBuilder();
        if (includeNamespace && this.namespace != null) {
            buffer.append(this.namespace.getNamespaceString());
            buffer.append("::");
        }
        buffer.append(this.demangledName);
        if (this.template != null) {
            buffer.append(this.template.toTemplate());
        }
        if (buffer.length() == 0) {
            return "";
        }
        return buffer.toString();
    }

    @Override
    public String getNamespaceName() {
        return this.name;
    }

    public String toString() {
        return this.getNamespaceString();
    }
}

