/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AddressSetPartitioner;
import ghidra.app.util.opinion.IntelHexRecord;
import ghidra.app.util.opinion.IntelHexRecordReader;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

class IntelHexMemImage {
    private HashMap<AddressRange, byte[]> rangeMap = new HashMap();
    private AddressSet set = new AddressSet();
    private HashSet<Address> partitions = new HashSet();
    private AddressSpace space;
    private Address base;
    private long startEIP = -1L;
    private int startCS = -1;
    private int startIP = -1;

    IntelHexMemImage(AddressSpace space, Address base) {
        this.base = base;
        this.space = space;
    }

    boolean hasDefinedBytes() {
        return !this.set.isEmpty();
    }

    void log(String line, String msg) {
        Msg.info((Object)this, (Object)("line: " + line));
        Msg.info((Object)this, (Object)("      " + msg + " (base " + this.base + ")"));
    }

    String parseLine(String line) {
        Object msg = null;
        try {
            IntelHexRecord record = IntelHexRecordReader.readRecord(line);
            if (!record.isReportedChecksumCorrect()) {
                msg = "WARNING: line checksum (is " + record.getReportedChecksum() + ") not correct (should be " + record.getActualChecksum() + ")";
            }
            int loadOffset = record.getLoadOffset();
            byte[] data = record.getData();
            switch (record.getRecordType()) {
                case 0: {
                    int rangeStartOffset = loadOffset;
                    int rangeEndOffset = loadOffset + data.length - 1;
                    Address rangeStart = this.base.addWrap((long)rangeStartOffset);
                    Address rangeEnd = this.base.addWrap((long)rangeEndOffset);
                    if (rangeEnd.compareTo((Object)rangeStart) < 0) {
                        long firstRangeEndOffset = this.findWrapPoint(rangeStartOffset, rangeEndOffset);
                        Address firstRangeEnd = this.base.addWrap(firstRangeEndOffset);
                        AddressRangeImpl firstRange = new AddressRangeImpl(rangeStart, firstRangeEnd);
                        int firstDataLength = (int)(firstRangeEndOffset - (long)loadOffset + 1L);
                        byte[] firstData = new byte[firstDataLength];
                        System.arraycopy(data, 0, firstData, 0, firstDataLength);
                        this.rangeMap.put((AddressRange)firstRange, firstData);
                        this.set.add((AddressRange)firstRange);
                        Address secondRangeStart = firstRangeEnd.addWrap(1L);
                        AddressRangeImpl secondRange = new AddressRangeImpl(secondRangeStart, rangeEnd);
                        int secondDataLength = data.length - firstDataLength;
                        byte[] secondData = new byte[secondDataLength];
                        System.arraycopy(data, firstDataLength, secondData, 0, secondDataLength);
                        this.rangeMap.put((AddressRange)secondRange, secondData);
                        this.set.add((AddressRange)secondRange);
                        break;
                    }
                    AddressRangeImpl range = new AddressRangeImpl(rangeStart, rangeEnd);
                    this.rangeMap.put((AddressRange)range, data);
                    this.set.add((AddressRange)range);
                    break;
                }
                case 1: {
                    this.space = AddressSpace.OTHER_SPACE;
                    this.base = this.space.getAddress(0L);
                    break;
                }
                case 4: {
                    long newBaseLong = this.ub(data[0]) << 24 | this.ub(data[1]) << 16;
                    this.base = this.space.getAddress(newBaseLong);
                    this.partitions.add(this.base);
                    break;
                }
                case 2: {
                    int newBaseSegment = this.ub(data[0]) << 8 | this.ub(data[1]);
                    if (this.space instanceof SegmentedAddressSpace) {
                        SegmentedAddressSpace sspace = (SegmentedAddressSpace)this.space;
                        this.base = sspace.getAddress(newBaseSegment, 0);
                    } else {
                        this.base = this.space.getAddress((long)(newBaseSegment <<= 4));
                    }
                    this.partitions.add(this.base);
                    break;
                }
                case 5: {
                    this.startEIP = this.ub(data[0]) << 24 | this.ub(data[1]) << 16 | this.ub(data[2]) << 8 | this.ub(data[3]);
                    break;
                }
                case 3: {
                    this.startCS = this.ub(data[0]) << 8 | this.ub(data[1]);
                    this.startIP = this.ub(data[2]) << 8 | this.ub(data[3]);
                    break;
                }
                default: {
                    msg = "Impossible record type: " + record.getRecordType() + " " + record.format();
                    break;
                }
            }
        }
        catch (Exception e) {
            msg = e.getMessage();
        }
        return msg;
    }

    private int ub(byte b) {
        return b & 0xFF;
    }

    private long findWrapPoint(int rangeStartOffset, int rangeEndOffset) {
        Address rangeStart = this.base.addWrap((long)rangeStartOffset);
        int leftPtr = rangeStartOffset;
        int rightPtr = rangeEndOffset;
        while (leftPtr + 1 < rightPtr) {
            int midpoint = (leftPtr + rightPtr) / 2;
            Address middle = this.base.addWrap((long)midpoint);
            if (middle.compareTo((Object)rangeStart) < 0) {
                rightPtr = midpoint;
                continue;
            }
            leftPtr = midpoint;
        }
        return leftPtr;
    }

    long getStartEIP() {
        return this.startEIP;
    }

    int getStartCS() {
        return this.startCS;
    }

    int getStartIP() {
        return this.startIP;
    }

    String createMemory(String creator, String progFile, String blockName, boolean isOverlay, Program program, TaskMonitor monitor) throws AddressOverflowException {
        MessageLog log = new MessageLog();
        AddressSetPartitioner partitioner = new AddressSetPartitioner(this.set, this.rangeMap, this.partitions);
        HashMap<AddressRange, byte[]> myRangeMap = new HashMap<AddressRange, byte[]>(partitioner.getPartionedRangeMap());
        for (AddressRange blockRange : partitioner) {
            Iterator<AddressRange> iter = myRangeMap.keySet().iterator();
            HashSet<AddressRange> blockSet = new HashSet<AddressRange>();
            while (iter.hasNext()) {
                AddressRange range = iter.next();
                if (!blockRange.intersects(range)) continue;
                blockSet.add(range);
            }
            boolean[] filled = new boolean[(int)blockRange.getLength()];
            byte[] data = new byte[(int)blockRange.getLength()];
            for (AddressRange range : blockSet) {
                byte[] rangeBytes = myRangeMap.get(range);
                int pos = (int)range.getMinAddress().getOffset() - (int)blockRange.getMinAddress().getOffset();
                IntelHexMemImage.rangeCheck(rangeBytes, 0, data, pos, rangeBytes.length);
                System.arraycopy(rangeBytes, 0, data, pos, rangeBytes.length);
                for (int jj = 0; jj < rangeBytes.length; ++jj) {
                    if (filled[pos + jj]) {
                        Msg.error((Object)this, (Object)("Hex format Overwrite of bytes at " + range.getMinAddress().add((long)(pos + jj))));
                    }
                    filled[pos + jj] = true;
                }
                myRangeMap.remove(range);
            }
            String name = blockName == null ? blockRange.getMinAddress().getAddressSpace().getName() : blockName;
            MemoryBlockUtils.createInitializedBlock(program, isOverlay, name, blockRange.getMinAddress(), new ByteArrayInputStream(data), (long)data.length, "Generated by " + creator, progFile, true, !isOverlay, !isOverlay, log, monitor);
        }
        return log.toString();
    }

    private static void rangeCheck(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        if (srcPos + length > src.length) {
            throw new IllegalArgumentException("src range check failed");
        }
        if (destPos + length > dest.length) {
            throw new IllegalArgumentException("dest range check failed");
        }
    }

    String createMemory(String creator, String progFile, Program program, TaskMonitor monitor) throws AddressOverflowException {
        return this.createMemory(creator, progFile, null, false, program, monitor);
    }

    void setBaseAddr(Address address) {
        this.base = address;
    }
}

