/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.util.Iterator;

public class DataTypeCleaner
implements Closeable {
    private final DataTypeManager targetDtm;
    private final boolean retainExistingComposites;
    private final StandAloneDataTypeManager cleanerDtm;
    private int txId;

    public DataTypeCleaner(DataTypeManager targetDtm, boolean retainExistingComposites) {
        this.targetDtm = targetDtm;
        this.retainExistingComposites = retainExistingComposites;
        this.cleanerDtm = new StandAloneDataTypeManager("CleanerDTM");
        this.txId = this.cleanerDtm.startTransaction("CleanerTx");
        ProgramArchitecture arch = targetDtm.getProgramArchitecture();
        if (arch != null) {
            try {
                this.cleanerDtm.setProgramArchitecture(arch.getLanguage(), arch.getCompilerSpec().getCompilerSpecID(), StandAloneDataTypeManager.LanguageUpdateOption.UNCHANGED, TaskMonitor.DUMMY);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public DataType clean(DataType dt) {
        if (this.txId == -1) {
            throw new IllegalStateException("DataTypeCleaner has been closed");
        }
        DataType cleanDt = this.cleanerDtm.resolve(dt, DataTypeConflictHandler.REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER);
        Iterator allComposites = this.cleanerDtm.getAllComposites();
        while (allComposites.hasNext()) {
            Composite c = (Composite)allComposites.next();
            if (c.isNotYetDefined() || this.retainExistingComposites && this.targetContainsComposite(c)) continue;
            StructureDataType replacement = null;
            if (c instanceof Structure) {
                Structure s = (Structure)c;
                replacement = new StructureDataType(c.getCategoryPath(), c.getName(), 0, (DataTypeManager)this.cleanerDtm);
            } else if (c instanceof Union) {
                Union u = (Union)c;
                replacement = new UnionDataType(c.getCategoryPath(), c.getName(), (DataTypeManager)this.cleanerDtm);
            }
            if (replacement == null) continue;
            replacement.setDescription(c.getDescription());
            c.replaceWith(replacement);
        }
        return cleanDt;
    }

    private boolean targetContainsComposite(Composite c) {
        Category category = this.targetDtm.getCategory(c.getCategoryPath());
        if (category == null) {
            return false;
        }
        String baseName = DataTypeUtilities.getNameWithoutConflict((DataType)c, (boolean)false);
        for (DataType dt : category.getDataTypesByBaseName(baseName)) {
            if (!dt.isEquivalent((DataType)c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.txId == -1) {
            return;
        }
        this.cleanerDtm.endTransaction(this.txId, true);
        this.cleanerDtm.close();
        this.txId = -1;
    }
}

