/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.theme.GThemeDefaults;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.DataTypeCleaner;
import ghidra.util.HTMLUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FunctionUtility {
    private FunctionUtility() {
    }

    public static void applyNameAndNamespace(Function target, Function source) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        String name = source.getName();
        Namespace targetNamespace = FunctionUtility.getOrCreateSourceNamespaceInTarget(target, source);
        Symbol symbol = target.getSymbol();
        symbol.setNameAndNamespace(name, targetNamespace, source.getSymbol().getSource());
    }

    public static void updateFunction(Function destinationFunction, Function sourceFunction) throws InvalidInputException, DuplicateNameException, CircularDependencyException {
        FunctionUtility.applySignature(destinationFunction, sourceFunction, false, DataTypeConflictHandler.DEFAULT_HANDLER);
    }

    public static void applySignature(Function destinationFunction, Function sourceFunction, boolean applyEmptyComposites, DataTypeConflictHandler conflictHandler) throws InvalidInputException, DuplicateNameException, CircularDependencyException {
        if (conflictHandler == null) {
            conflictHandler = DataTypeConflictHandler.DEFAULT_HANDLER;
        }
        FunctionUtility.updateFunctionExceptName(destinationFunction, sourceFunction, applyEmptyComposites, conflictHandler);
        FunctionUtility.applyNameAndNamespace(destinationFunction, sourceFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFunctionExceptName(Function destinationFunction, Function sourceFunction, boolean applyEmptyComposites, DataTypeConflictHandler conflictHandler) throws InvalidInputException, DuplicateNameException {
        Program sourceProgram = sourceFunction.getProgram();
        Program destinationProgram = destinationFunction.getProgram();
        boolean sameLanguage = FunctionUtility.isSameLanguageAndCompilerSpec(destinationProgram, sourceProgram);
        String callingConventionName = FunctionUtility.determineCallingConventionName(destinationFunction, sourceFunction, sameLanguage);
        boolean useCustomStorage = FunctionUtility.determineCustomStorageUse(destinationFunction, sourceFunction, sameLanguage);
        ProgramBasedDataTypeManager destinationDtm = destinationFunction.getProgram().getDataTypeManager();
        try (DataTypeCleaner dtCleaner = applyEmptyComposites ? new DataTypeCleaner((DataTypeManager)destinationDtm, true) : null;){
            SourceType source = sourceFunction.getSignatureSource();
            Variable returnValue = FunctionUtility.determineReturnValue(destinationFunction, sourceFunction, useCustomStorage, arg_0 -> FunctionUtility.lambda$updateFunctionExceptName$0((DataTypeManager)destinationDtm, dtCleaner, conflictHandler, arg_0));
            List<Parameter> newParams = FunctionUtility.determineParameters(destinationFunction, sourceFunction, useCustomStorage, arg_0 -> FunctionUtility.lambda$updateFunctionExceptName$1((DataTypeManager)destinationDtm, dtCleaner, conflictHandler, arg_0));
            FunctionUtility.setUniqueParameterNames(destinationFunction, newParams);
            destinationFunction.updateFunction(callingConventionName, returnValue, newParams, useCustomStorage ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, source);
        }
        FunctionUtility.applyInline(destinationFunction, sourceFunction);
        FunctionUtility.applyNoReturn(destinationFunction, sourceFunction);
        FunctionUtility.applyVarArgs(destinationFunction, sourceFunction);
        FunctionUtility.applyCallFixup(destinationFunction, sourceFunction, sameLanguage);
    }

    private static DataType prepareDataType(DataType dt, DataTypeManager destinationDtm, DataTypeCleaner dtCleaner, DataTypeConflictHandler conflictHandler) {
        if (dtCleaner != null) {
            dt = dtCleaner.clean(dt);
        }
        if (conflictHandler != DataTypeConflictHandler.DEFAULT_HANDLER) {
            dt = destinationDtm.resolve(dt, conflictHandler);
        }
        return dt;
    }

    public static void setUniqueParameterNames(Function function, List<Parameter> parameters) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = function.getProgram().getSymbolTable();
        HashSet<String> namesSoFar = new HashSet<String>();
        for (Parameter parameter : parameters) {
            String baseName = parameter.getName();
            String uniqueName = FunctionUtility.getUniqueReplacementParameterName(symbolTable, function, baseName, namesSoFar);
            namesSoFar.add(uniqueName);
            if (SystemUtilities.isEqual((Object)baseName, (Object)uniqueName)) continue;
            parameter.setName(uniqueName, parameter.getSource());
        }
    }

    private static String getUniqueReplacementParameterName(SymbolTable symbolTable, Function function, String name, Set<String> namesNotToBeUsed) {
        if (name == null || SymbolUtilities.isDefaultParameterName((String)name)) {
            return name;
        }
        return FunctionUtility.getUniqueNameIgnoringCurrentParameters(symbolTable, function, name, namesNotToBeUsed);
    }

    private static String getUniqueNameIgnoringCurrentParameters(SymbolTable symbolTable, Function function, String baseName, Set<String> namesNotToBeUsed) {
        Object name = baseName;
        if (name != null) {
            int cnt = 0;
            Symbol symbol = symbolTable.getVariableSymbol((String)name, function);
            while (symbol != null) {
                if (namesNotToBeUsed.contains(name)) continue;
                if (symbol.getSymbolType() == SymbolType.PARAMETER) {
                    return name;
                }
                name = baseName + ++cnt;
                symbol = symbolTable.getVariableSymbol((String)name, function);
            }
        }
        return name;
    }

    private static void applyInline(Function destinationFunction, Function sourceFunction) {
        boolean sourceInline = sourceFunction.isInline();
        boolean destInline = destinationFunction.isInline();
        if (destInline != sourceInline) {
            destinationFunction.setInline(sourceInline);
        }
    }

    private static void applyNoReturn(Function destinationFunction, Function sourceFunction) {
        boolean sourceNoReturn = sourceFunction.hasNoReturn();
        boolean destNoReturn = destinationFunction.hasNoReturn();
        if (destNoReturn != sourceNoReturn) {
            destinationFunction.setNoReturn(sourceNoReturn);
        }
    }

    private static void applyVarArgs(Function destinationFunction, Function sourceFunction) {
        boolean sourceVarArgs = sourceFunction.hasVarArgs();
        boolean destVarArgs = destinationFunction.hasVarArgs();
        if (destVarArgs != sourceVarArgs) {
            destinationFunction.setVarArgs(sourceVarArgs);
        }
    }

    private static void applyCallFixup(Function destinationFunction, Function sourceFunction, boolean sameLanguage) {
        String sourceCallFixup = sourceFunction.getCallFixup();
        String destCallFixup = destinationFunction.getCallFixup();
        if (SystemUtilities.isEqual((Object)destCallFixup, (Object)sourceCallFixup)) {
            return;
        }
        if (sameLanguage) {
            destinationFunction.setCallFixup(sourceCallFixup);
        }
    }

    static void setFunctionName(Function destinationFunction, Function sourceFunction) throws InvalidInputException, DuplicateNameException {
        String sourceName = sourceFunction.getName();
        Address sourceEntryPoint = sourceFunction.getEntryPoint();
        Namespace sourceNamespace = sourceFunction.getParentNamespace();
        String defaultFunctionName = SymbolUtilities.getDefaultFunctionName((Address)sourceEntryPoint);
        boolean isDefaultFunctionName = defaultFunctionName.equals(sourceName);
        if (isDefaultFunctionName) {
            return;
        }
        String destinationName = destinationFunction.getName();
        if (sourceName.equals(destinationName)) {
            return;
        }
        String baseName = FunctionUtility.getBaseName(sourceFunction);
        SymbolTable symbolTable = sourceFunction.getProgram().getSymbolTable();
        Symbol symbol = symbolTable.getSymbol(sourceName, sourceEntryPoint, sourceNamespace);
        SourceType source = symbol != null ? symbol.getSource() : SourceType.USER_DEFINED;
        try {
            destinationFunction.setName(baseName, source);
        }
        catch (DuplicateNameException e) {
            baseName = FunctionUtility.createConflictName(baseName, destinationFunction);
            destinationFunction.setName(baseName, source);
        }
    }

    static String createConflictName(String name, Function destinationFunction) {
        Address entryPoint = destinationFunction.getEntryPoint();
        return name + "@" + SymbolUtilities.getAddressString((Address)entryPoint);
    }

    static String getBaseName(Function function) {
        Address entryPoint = function.getEntryPoint();
        String conflictSuffix = "@" + SymbolUtilities.getAddressString((Address)entryPoint);
        String name = function.getName();
        if (name.endsWith(conflictSuffix)) {
            return name.substring(0, name.length() - conflictSuffix.length());
        }
        return name;
    }

    public static boolean isSameLanguageAndCompilerSpec(Program program1, Program program2) {
        Language language1 = program1.getLanguage();
        Language language2 = program2.getLanguage();
        if (language1.getLanguageID() != language2.getLanguageID()) {
            return false;
        }
        CompilerSpec compilerSpec1 = program1.getCompilerSpec();
        CompilerSpec compilerSpec2 = program2.getCompilerSpec();
        return compilerSpec1.getCompilerSpecID() == compilerSpec2.getCompilerSpecID();
    }

    private static String determineCallingConventionName(Function destinationFunction, Function sourceFunction, boolean sameLanguageAndCompilerSpec) {
        String sourceConv = sourceFunction.getCallingConventionName();
        if ("__thiscall".equals(sourceConv)) {
            return sourceConv;
        }
        return sameLanguageAndCompilerSpec ? sourceFunction.getCallingConventionName() : destinationFunction.getCallingConventionName();
    }

    private static boolean determineCustomStorageUse(Function destinationFunction, Function sourceFunction, boolean sameLanguage) {
        boolean useCustomStorage = sourceFunction.hasCustomVariableStorage();
        if (useCustomStorage) {
            return sameLanguage;
        }
        return false;
    }

    private static Variable determineReturnValue(Function destinationFunction, Function sourceFunction, boolean useCustomStorage, java.util.function.Function<DataType, DataType> prepareDataType) throws InvalidInputException {
        Program destinationProgram = destinationFunction.getProgram();
        Parameter sourceReturn = sourceFunction.getReturn();
        VariableStorage storage = useCustomStorage ? sourceReturn.getVariableStorage().clone((ProgramArchitecture)destinationProgram) : VariableStorage.UNASSIGNED_STORAGE;
        DataType dataType = prepareDataType.apply(sourceReturn.getDataType());
        if (dataType.isZeroLength()) {
            storage = VariableStorage.UNASSIGNED_STORAGE;
        }
        ReturnParameterImpl returnValue = new ReturnParameterImpl(dataType, storage, destinationProgram);
        return returnValue;
    }

    private static List<Parameter> determineParameters(Function destinationFunction, Function sourceFunction, boolean useCustomStorage, java.util.function.Function<DataType, DataType> prepareDataType) throws InvalidInputException {
        Parameter[] sourceParameters;
        Program destinationProgram = destinationFunction.getProgram();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter sourceParameter : sourceParameters = sourceFunction.getParameters()) {
            String name = sourceParameter.getName();
            VariableStorage storage = useCustomStorage ? sourceParameter.getVariableStorage().clone((ProgramArchitecture)destinationProgram) : VariableStorage.UNASSIGNED_STORAGE;
            DataType dataType = prepareDataType.apply(sourceParameter.getDataType());
            if (dataType.isZeroLength()) {
                storage = VariableStorage.UNASSIGNED_STORAGE;
            }
            SourceType source = sourceParameter.getSource();
            ParameterImpl parameter = new ParameterImpl(name, dataType, storage, destinationProgram, source);
            String comment = sourceParameter.getComment();
            if (comment != null) {
                parameter.setComment(comment);
            }
            parameters.add((Parameter)parameter);
        }
        return parameters;
    }

    public static boolean isDefaultFunctionName(Function function) {
        String defaultFunctionName = SymbolUtilities.getDefaultFunctionName((Address)function.getEntryPoint());
        return defaultFunctionName.equals(function.getName());
    }

    public static String getFunctionTitle(Function function) {
        if (function == null) {
            return HTMLUtilities.wrapAsHTML((String)"No Function");
        }
        StringBuffer buf = new StringBuffer();
        String padStr = HTMLUtilities.spaces((int)4);
        buf.append(padStr);
        String functionStr = HTMLUtilities.friendlyEncodeHTML((String)(function.getName() + "()"));
        String specialFunctionStr = HTMLUtilities.bold((String)functionStr);
        buf.append(specialFunctionStr);
        Program program = function.getProgram();
        if (program != null) {
            buf.append(" in ");
            String programStr = HTMLUtilities.friendlyEncodeHTML((String)program.getDomainFile().getPathname());
            String specialProgramStr = HTMLUtilities.colorString((Color)GThemeDefaults.Colors.Palette.DARK_GRAY, (String)programStr);
            buf.append(specialProgramStr);
            buf.append(padStr);
        }
        return HTMLUtilities.wrapAsHTML((String)buf.toString());
    }

    private static Namespace getOrCreateSourceNamespaceInTarget(Function target, Function source) throws DuplicateNameException, InvalidInputException {
        Namespace targetNamespace = target.getParentNamespace();
        Namespace sourceNamespace = source.getParentNamespace();
        if (targetNamespace.getName(true).equals(sourceNamespace.getName(true))) {
            return targetNamespace;
        }
        return FunctionUtility.getOrCreateTargetNamespace(target.getProgram(), sourceNamespace);
    }

    private static Namespace getOrCreateTargetNamespace(Program program, Namespace otherNamespace) throws DuplicateNameException, InvalidInputException {
        String otherName;
        if (otherNamespace.isGlobal()) {
            return program.getGlobalNamespace();
        }
        Namespace otherParent = otherNamespace.getParentNamespace();
        Namespace parent = FunctionUtility.getOrCreateTargetNamespace(program, otherParent);
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace namespace = symbolTable.getNamespace(otherName = otherNamespace.getName(), parent);
        if (namespace != null) {
            return namespace;
        }
        SourceType source = otherNamespace.getSymbol().getSource();
        if (otherNamespace instanceof GhidraClass) {
            return symbolTable.createClass(parent, otherName, source);
        }
        if (otherNamespace instanceof Library) {
            return symbolTable.createExternalLibrary(otherName, source);
        }
        return symbolTable.createNameSpace(parent, otherName, source);
    }

    private static /* synthetic */ DataType lambda$updateFunctionExceptName$1(DataTypeManager destinationDtm, DataTypeCleaner dtCleaner, DataTypeConflictHandler conflictHandler, DataType dt) {
        return FunctionUtility.prepareDataType(dt, destinationDtm, dtCleaner, conflictHandler);
    }

    private static /* synthetic */ DataType lambda$updateFunctionExceptName$0(DataTypeManager destinationDtm, DataTypeCleaner dtCleaner, DataTypeConflictHandler conflictHandler, DataType dt) {
        return FunctionUtility.prepareDataType(dt, destinationDtm, dtCleaner, conflictHandler);
    }
}

