/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.ByteCountSettingsDefinition;
import ghidra.util.table.field.MemoryOffsetSettingsDefinition;
import ghidra.util.table.field.MonospacedByteRenderer;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;

public class BytesTableColumn
extends ProgramLocationTableColumnExtensionPoint<Address, Byte[]> {
    private static final ByteCountSettingsDefinition BYTE_COUNT = ByteCountSettingsDefinition.DEF;
    private static final MemoryOffsetSettingsDefinition MEMORY_OFFSET = MemoryOffsetSettingsDefinition.DEF;
    private static final EndianSettingsDefinition ENDIANESS = EndianSettingsDefinition.DEF;
    private static final FormatSettingsDefinition FORMAT = FormatSettingsDefinition.DEF;
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[]{BYTE_COUNT, MEMORY_OFFSET, ENDIANESS, FORMAT};
    private final GColumnRenderer<Byte[]> monospacedRenderer = new MonospacedByteRenderer();

    public String getColumnDisplayName(Settings settings) {
        String offset;
        Object name = this.getColumnName();
        int byteCnt = BYTE_COUNT.getChoice(settings);
        if (byteCnt != 0) {
            name = (String)name + "[" + byteCnt + "]";
        }
        if (!"0".equals(offset = MEMORY_OFFSET.getDisplayValue(settings))) {
            name = (String)name + offset;
        }
        return name;
    }

    public String getColumnName() {
        return "Bytes";
    }

    public Byte[] getValue(Address rowObject, Settings settings, Program pgm, ServiceProvider serviceProvider) throws IllegalArgumentException {
        Address addr = rowObject;
        try {
            int offset = MEMORY_OFFSET.getOffset(settings);
            int byteCnt = BYTE_COUNT.getChoice(settings);
            byte[] bytes = null;
            if (offset != 0) {
                addr = addr.add((long)offset);
            }
            if (byteCnt == 0) {
                if (offset != 0) {
                    byteCnt = 1;
                } else {
                    CodeUnit cu = pgm.getListing().getCodeUnitContaining(addr);
                    if (cu == null) {
                        return new Byte[0];
                    }
                    if (cu instanceof Instruction) {
                        Instruction instr = (Instruction)cu;
                        bytes = instr.getParsedBytes();
                    } else {
                        bytes = cu.getBytes();
                    }
                }
            }
            if (bytes == null) {
                bytes = new byte[byteCnt];
                pgm.getMemory().getBytes(addr, bytes);
            }
            Byte[] bytesObj = new Byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                bytesObj[i] = bytes[i];
            }
            return bytesObj;
        }
        catch (MemoryAccessException memoryAccessException) {
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
        return new Byte[0];
    }

    public GColumnRenderer<Byte[]> getColumnRenderer() {
        return this.monospacedRenderer;
    }

    @Override
    public ProgramLocation getProgramLocation(Address rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        Address address = rowObject;
        int offset = MEMORY_OFFSET.getOffset(settings);
        if (offset != 0) {
            try {
                address = address.addNoWrap((long)offset);
            }
            catch (AddressOverflowException addressOverflowException) {
                // empty catch block
            }
        }
        return new BytesFieldLocation(program, address);
    }

    public SettingsDefinition[] getSettingsDefinitions() {
        return SETTINGS_DEFS;
    }
}

