/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database;

import db.BinaryField;
import db.ByteField;
import db.DBRecord;
import db.StringField;
import generic.RangeMapSetter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.model.Lifespan;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStoreFactory;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class DBTraceUtils
extends Enum<DBTraceUtils> {
    private static final /* synthetic */ DBTraceUtils[] $VALUES;

    public static DBTraceUtils[] values() {
        return (DBTraceUtils[])$VALUES.clone();
    }

    public static DBTraceUtils valueOf(String name) {
        return Enum.valueOf(DBTraceUtils.class, name);
    }

    public static String tableName(String baseName, AddressSpace space, long threadKey, int frameLevel) {
        if (space.isRegisterSpace()) {
            if (frameLevel == 0) {
                return baseName + "_" + space.getName() + "_" + threadKey;
            }
            return baseName + "_" + space.getName() + "_" + threadKey + "_" + frameLevel;
        }
        return baseName + "_" + space.getName();
    }

    public static <DR extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<?>> void makeWay(DR data, Lifespan span, BiConsumer<? super DR, Lifespan> lifespanSetter, Consumer<? super DR> deleter) {
        if (span.contains(data.getY1())) {
            deleter.accept(data);
            return;
        }
        lifespanSetter.accept(data, Lifespan.span(data.getY1(), span.lmin() - 1L));
    }

    public static <T> Iterator<T> covariantIterator(Iterator<? extends T> it) {
        return it;
    }

    public static AddressSetView getAddressSet(AddressFactory factory, Address start, boolean forward) {
        AddressSet all = factory.getAddressSet();
        if (forward) {
            Address max = all.getMaxAddress();
            return factory.getAddressSet(start, max);
        }
        Address min = all.getMinAddress();
        return factory.getAddressSet(min, start);
    }

    public static AddressRange toRange(Address min, Address max) {
        if (min.compareTo((Object)max) > 0) {
            throw new IllegalArgumentException("min must precede max");
        }
        return new AddressRangeImpl(min, max);
    }

    private static /* synthetic */ DBTraceUtils[] $values() {
        return new DBTraceUtils[0];
    }

    static {
        $VALUES = DBTraceUtils.$values();
    }

    public static abstract class LifespanMapSetter<E, V>
    extends RangeMapSetter<E, Long, Lifespan, V> {
        protected int compare(Long d1, Long d2) {
            return Lifespan.DOMAIN.compare(d1, d2);
        }

        protected Long getLower(Lifespan span) {
            return (Long)span.min();
        }

        protected Long getUpper(Lifespan span) {
            return (Long)span.max();
        }

        protected Lifespan toSpan(Long lower, Long upper) {
            return Lifespan.span(lower, upper);
        }

        protected Long getPrevious(Long d) {
            if (d == null || d == Long.MIN_VALUE) {
                return null;
            }
            return d - 1L;
        }

        protected Long getNext(Long d) {
            if (d == null || d == Long.MAX_VALUE) {
                return null;
            }
            return d + 1L;
        }
    }

    public static abstract class AddressRangeMapSetter<E, V>
    extends RangeMapSetter<E, Address, AddressRange, V> {
        protected int compare(Address d1, Address d2) {
            return d1.compareTo((Object)d2);
        }

        protected Address getLower(AddressRange range) {
            return range.getMinAddress();
        }

        protected Address getUpper(AddressRange range) {
            return range.getMaxAddress();
        }

        protected AddressRange toSpan(Address lower, Address upper) {
            return new AddressRangeImpl(lower, upper);
        }

        protected Address getPrevious(Address d) {
            return d.previous();
        }

        protected Address getNext(Address d) {
            return d.next();
        }
    }

    public static class RefTypeDBFieldCodec<OT extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<RefType, OT, ByteField> {
        public RefTypeDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(RefType.class, objectType, ByteField.class, field, column);
        }

        protected byte encode(RefType value) {
            return value == null ? (byte)-128 : (byte)value.getValue();
        }

        protected RefType decode(byte enc) {
            return enc == -128 ? null : RefTypeFactory.get((byte)enc);
        }

        public void store(RefType value, ByteField f) {
            f.setByteValue(this.encode(value));
        }

        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setByteValue(this.column, this.encode((RefType)this.getValue((DBAnnotatedObject)obj)));
        }

        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.setValue((DBAnnotatedObject)obj, this.decode(record.getByteValue(this.column)));
        }
    }

    public static class OffsetThenSnapDBFieldCodec<OT extends DBAnnotatedObject>
    extends AbstractOffsetSnapDBFieldCodec<OT> {
        public OffsetThenSnapDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(objectType, field, column);
        }

        @Override
        protected byte[] encode(OffsetSnap value) {
            ByteBuffer buf = ByteBuffer.allocate(16);
            buf.putLong(value.offset);
            buf.putLong(value.snap ^ Long.MIN_VALUE);
            return buf.array();
        }

        @Override
        protected OffsetSnap decode(byte[] arr) {
            ByteBuffer buf = ByteBuffer.wrap(arr);
            long offset = buf.getLong();
            long snap = buf.getLong() ^ Long.MIN_VALUE;
            return new OffsetSnap(offset, snap);
        }
    }

    public static abstract class AbstractOffsetSnapDBFieldCodec<OT extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<OffsetSnap, OT, BinaryField> {
        public AbstractOffsetSnapDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(OffsetSnap.class, objectType, BinaryField.class, field, column);
        }

        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            OffsetSnap value = (OffsetSnap)this.getValue((DBAnnotatedObject)obj);
            if (value == null) {
                record.setBinaryData(this.column, null);
            } else {
                record.setBinaryData(this.column, this.encode(value));
            }
        }

        public void store(OffsetSnap value, BinaryField f) {
            if (value == null) {
                f.setBinaryData(null);
            } else {
                f.setBinaryData(this.encode(value));
            }
        }

        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            byte[] data = record.getBinaryData(this.column);
            if (data == null) {
                this.setValue((DBAnnotatedObject)obj, null);
            } else {
                this.setValue((DBAnnotatedObject)obj, this.decode(data));
            }
        }

        protected abstract byte[] encode(OffsetSnap var1);

        protected abstract OffsetSnap decode(byte[] var1);
    }

    public static class CompilerSpecIDDBFieldCodec<OT extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<CompilerSpecID, OT, StringField> {
        public CompilerSpecIDDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(CompilerSpecID.class, objectType, StringField.class, field, column);
        }

        public void store(CompilerSpecID value, StringField f) {
            f.setString(value == null ? null : value.getIdAsString());
        }

        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            CompilerSpecID id = (CompilerSpecID)this.getValue((DBAnnotatedObject)obj);
            if (id == null) {
                record.setString(this.column, null);
            } else {
                record.setString(this.column, id.getIdAsString());
            }
        }

        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            String id = record.getString(this.column);
            if (id == null) {
                this.setValue((DBAnnotatedObject)obj, null);
            } else {
                this.setValue((DBAnnotatedObject)obj, new CompilerSpecID(id));
            }
        }
    }

    public static class LanguageIDDBFieldCodec<OT extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<LanguageID, OT, StringField> {
        public LanguageIDDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(LanguageID.class, objectType, StringField.class, field, column);
        }

        public void store(LanguageID value, StringField f) {
            f.setString(value == null ? null : value.getIdAsString());
        }

        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            LanguageID id = (LanguageID)this.getValue((DBAnnotatedObject)obj);
            if (id == null) {
                record.setString(this.column, null);
            } else {
                record.setString(this.column, id.getIdAsString());
            }
        }

        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            String id = record.getString(this.column);
            if (id == null) {
                this.setValue((DBAnnotatedObject)obj, null);
            } else {
                this.setValue((DBAnnotatedObject)obj, new LanguageID(id));
            }
        }
    }

    public static class URLDBFieldCodec<OT extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<URL, OT, StringField> {
        public URLDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(URL.class, objectType, StringField.class, field, column);
        }

        protected String encode(URL url) {
            if (url == null) {
                return null;
            }
            return url.toString();
        }

        public void store(URL value, StringField f) {
            f.setString(this.encode(value));
        }

        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setString(this.column, this.encode((URL)this.getValue((DBAnnotatedObject)obj)));
        }

        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            try {
                String data = record.getString(this.column);
                if (data == null) {
                    this.setValue((DBAnnotatedObject)obj, null);
                } else {
                    this.setValue((DBAnnotatedObject)obj, new URL(data));
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class OffsetSnap {
        public final long offset;
        public final long snap;

        public OffsetSnap(long offset, long snap) {
            this.offset = offset;
            this.snap = snap;
        }

        public String toString() {
            return String.format("%d,%08x", this.snap, this.offset);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OffsetSnap)) {
                return false;
            }
            OffsetSnap that = (OffsetSnap)obj;
            if (this.offset != that.offset) {
                return false;
            }
            return this.snap == that.snap;
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.snap);
        }

        public boolean isScratch() {
            return Lifespan.isScratch(this.snap);
        }
    }
}

