/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.stack;

import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.stack.TraceObjectStack;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.LockHold;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DBTraceObjectStack
implements TraceObjectStack,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final StackChangeTranslator translator;

    public DBTraceObjectStack(DBTraceObject object) {
        this.object = object;
        this.translator = new StackChangeTranslator(object, this);
    }

    @Override
    public TraceThread getThread() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceThread traceThread = this.object.queryAncestorsInterface(this.computeSpan(), TraceObjectThread.class).findAny().orElseThrow();
            return traceThread;
        }
    }

    @Override
    public long getSnap() {
        return this.computeMinSnap();
    }

    @Override
    public int getDepth() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            int n = this.object.querySuccessorsInterface(this.computeSpan(), TraceObjectStackFrame.class, true).map(f -> f.getLevel()).reduce(Integer::max).map(m -> m + 1).orElse(0);
            return n;
        }
    }

    protected TraceObjectStackFrame doAddStackFrame(int level) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            PathMatcher matcher = this.object.getTargetSchema().searchFor(TargetStackFrame.class, true);
            List relKeyList = matcher.applyKeys(new String[]{PathUtils.makeIndex((int)level)}).getSingletonPath();
            if (relKeyList == null) {
                throw new IllegalStateException("Could not determine where to create new frame");
            }
            List keyList = PathUtils.extend(this.object.getCanonicalPath().getKeyList(), (List)relKeyList);
            TraceObjectStackFrame traceObjectStackFrame = this.object.getManager().addStackFrame(keyList, this.getSnap());
            return traceObjectStackFrame;
        }
    }

    protected void copyFrameAttributes(TraceObjectStackFrame from, TraceObjectStackFrame to) {
        to.setProgramCounter(this.computeSpan(), from.getProgramCounter(this.computeMaxSnap()));
    }

    protected void shiftFrameAttributes(int from, int to, int count, List<TraceObjectStackFrame> frames) {
        if (from == to) {
            return;
        }
        if (from < to) {
            for (int i = count - 1; i >= 0; --i) {
                this.copyFrameAttributes(frames.get(from + i), frames.get(to + i));
            }
        } else {
            for (int i = 0; i < count; ++i) {
                this.copyFrameAttributes(frames.get(from + i), frames.get(to + i));
            }
        }
    }

    protected void clearFrameAttributes(int start, int end, List<TraceObjectStackFrame> frames) {
        for (int i = start; i < end; ++i) {
            TraceObjectStackFrame frame = frames.get(i);
            frame.setProgramCounter(frame.computeSpan(), null);
        }
    }

    @Override
    public void setDepth(int depth, boolean atInner) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            List frames = this.doGetFrames(this.computeMinSnap()).collect(Collectors.toCollection(ArrayList::new));
            int curDepth = frames.size();
            if (curDepth == depth) {
                return;
            }
            if (depth < curDepth) {
                if (atInner) {
                    int diff = curDepth - depth;
                    this.shiftFrameAttributes(diff, 0, depth, frames);
                }
                for (int i = depth; i < curDepth; ++i) {
                    ((TraceObjectStackFrame)frames.get(i)).getObject().removeTree(this.computeSpan());
                }
            } else {
                for (int i = curDepth; i < depth; ++i) {
                    frames.add(this.doAddStackFrame(i));
                }
                if (atInner) {
                    int diff = depth - curDepth;
                    this.shiftFrameAttributes(0, diff, curDepth, frames);
                    this.clearFrameAttributes(0, diff, frames);
                }
            }
        }
    }

    protected TraceStackFrame doGetFrame(int level) {
        TargetObjectSchema schema = this.object.getTargetSchema();
        PathMatcher matcher = schema.searchFor(TargetStackFrame.class, true);
        PathPredicates decMatcher = matcher.applyKeys(new String[]{PathUtils.makeIndex((int)level)});
        PathPredicates hexMatcher = matcher.applyKeys(new String[]{"0x" + Integer.toHexString(level)});
        Lifespan span = this.computeSpan();
        return this.object.getSuccessors(span, decMatcher).findAny().map(p -> p.getDestination(this.object).queryInterface(TraceObjectStackFrame.class)).or(() -> this.object.getSuccessors(span, hexMatcher).findAny().map(p -> p.getDestination(this.object).queryInterface(TraceObjectStackFrame.class))).orElse(null);
    }

    @Override
    public TraceStackFrame getFrame(int level, boolean ensureDepth) {
        if (ensureDepth) {
            try (LockHold hold = this.object.getTrace().lockWrite();){
                if (level >= this.getDepth()) {
                    this.setDepth(level + 1, false);
                }
                TraceStackFrame traceStackFrame = this.doGetFrame(level);
                return traceStackFrame;
            }
        }
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceStackFrame traceStackFrame = this.doGetFrame(level);
            return traceStackFrame;
        }
    }

    protected Stream<TraceObjectStackFrame> doGetFrames(long snap) {
        return this.object.querySuccessorsInterface(Lifespan.at(snap), TraceObjectStackFrame.class, true).sorted(Comparator.comparing(f -> f.getLevel()));
    }

    @Override
    public List<TraceStackFrame> getFrames(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            List<TraceStackFrame> list = this.doGetFrames(snap).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(this.computeSpan());
        }
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    @Override
    public boolean hasFixedFrames() {
        return false;
    }

    protected class StackChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceStack> {
        protected StackChangeTranslator(DBTraceObject object, TraceStack iface) {
            super(null, object, iface);
        }

        @Override
        protected TraceChangeType<TraceStack, Void> getAddedType() {
            return Trace.TraceStackChangeType.ADDED;
        }

        @Override
        protected TraceChangeType<TraceStack, Lifespan> getLifespanChangedType() {
            return null;
        }

        @Override
        protected TraceChangeType<TraceStack, ?> getChangedType() {
            return Trace.TraceStackChangeType.CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return false;
        }

        @Override
        protected TraceChangeType<TraceStack, Void> getDeletedType() {
            return Trace.TraceStackChangeType.DELETED;
        }
    }
}

