/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.thread;

import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;

public class DBTraceObjectThread
implements TraceObjectThread,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final ThreadChangeTranslator translator;

    public DBTraceObjectThread(DBTraceObject object) {
        this.object = object;
        this.translator = new ThreadChangeTranslator(object, this);
    }

    @Override
    public DBTraceObject getObject() {
        return this.object;
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public long getKey() {
        return this.object.getKey();
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public String getName() {
        return TraceObjectInterfaceUtils.getValue(this.object, this.getCreationSnap(), "_display", String.class, "");
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(this.computeSpan(), name);
        }
    }

    @Override
    public void setCreationSnap(long creationSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(Lifespan.span(creationSnap, this.getDestructionSnap()));
        }
    }

    @Override
    public long getCreationSnap() {
        return this.computeMinSnap();
    }

    @Override
    public void setDestructionSnap(long destructionSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(Lifespan.span(this.getCreationSnap(), destructionSnap));
        }
    }

    @Override
    public long getDestructionSnap() {
        return this.computeMaxSnap();
    }

    @Override
    public void setLifespan(Lifespan lifespan) throws DuplicateNameException {
        TraceObjectInterfaceUtils.setLifespan(TraceObjectThread.class, this.object, lifespan);
    }

    @Override
    public Lifespan getLifespan() {
        return this.computeSpan();
    }

    @Override
    public void setComment(String comment) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(this.getLifespan(), "_comment", comment);
        }
    }

    @Override
    public String getComment() {
        return TraceObjectInterfaceUtils.getValue(this.object, this.getCreationSnap(), "_comment", String.class, "");
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(this.computeSpan());
        }
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected class ThreadChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceThread> {
        protected ThreadChangeTranslator(DBTraceObject object, TraceThread iface) {
            super(null, object, iface);
        }

        @Override
        protected TraceChangeType<TraceThread, Void> getAddedType() {
            return Trace.TraceThreadChangeType.ADDED;
        }

        @Override
        protected TraceChangeType<TraceThread, Lifespan> getLifespanChangedType() {
            return Trace.TraceThreadChangeType.LIFESPAN_CHANGED;
        }

        @Override
        protected TraceChangeType<TraceThread, Void> getChangedType() {
            return Trace.TraceThreadChangeType.CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return "_comment".equals(key) || "_display".equals(key);
        }

        @Override
        protected TraceChangeType<TraceThread, Void> getDeletedType() {
            return Trace.TraceThreadChangeType.DELETED;
        }
    }
}

