/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.linux;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.linux.AbstractEmuLinuxSyscallUseropLibrary;
import ghidra.pcode.emu.unix.EmuUnixFileSystem;
import ghidra.pcode.emu.unix.EmuUnixUser;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class EmuLinuxAmd64SyscallUseropLibrary<T>
extends AbstractEmuLinuxSyscallUseropLibrary<T> {
    protected final Register regRAX;
    protected FileDataTypeManager clib64;

    public EmuLinuxAmd64SyscallUseropLibrary(PcodeMachine<T> machine, EmuUnixFileSystem<T> fs, Program program) {
        super(machine, fs, program);
        this.regRAX = machine.getLanguage().getRegister("RAX");
    }

    public EmuLinuxAmd64SyscallUseropLibrary(PcodeMachine<T> machine, EmuUnixFileSystem<T> fs, Program program, EmuUnixUser user) {
        super(machine, fs, program, user);
        this.regRAX = machine.getLanguage().getRegister("RAX");
    }

    @Override
    protected Collection<DataTypeManager> getAdditionalArchives() {
        try {
            ResourceFile file = Application.findDataFileInAnyModule((String)"typeinfo/generic/generic_clib_64.gdt");
            this.clib64 = FileDataTypeManager.openFileArchive((ResourceFile)file, (boolean)false);
            return List.of(this.clib64);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    protected void disposeAdditionalArchives() {
        this.clib64.close();
    }

    @Override
    public long readSyscallNumber(PcodeExecutorState<T> state, PcodeExecutorStatePiece.Reason reason) {
        return this.machine.getArithmetic().toLong(state.getVar(this.regRAX, reason), PcodeArithmetic.Purpose.OTHER);
    }

    @Override
    protected boolean returnErrno(PcodeExecutor<T> executor, int errno) {
        executor.getState().setVar(this.regRAX, executor.getArithmetic().fromConst((long)(-errno), this.regRAX.getMinimumByteSize()));
        return true;
    }
}

