/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.buffers.BufferFile;
import db.buffers.BufferFileBlock;
import db.buffers.BufferFileManager;
import db.buffers.ChangeMap;
import db.buffers.ChangeMapFile;
import db.buffers.DataBuffer;
import db.buffers.InputBlockStream;
import db.buffers.LocalBufferFile;
import db.buffers.ManagedBufferFile;
import db.buffers.OutputBlockStream;
import db.buffers.VersionFile;
import db.buffers.VersionFileHandler;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class LocalManagedBufferFile
extends LocalBufferFile
implements ManagedBufferFile {
    private VersionFileHandler versionFileHandler;
    private VersionFile versionOutFile;
    private ChangeMapFile changeMap;
    private int version = 0;
    private int minChangeDataVer = -1;
    private int nextChangeDataVer = -1;
    private String comment;
    private BufferFileManager bfMgr;
    private long checkinId = -1L;
    private LocalManagedBufferFile preSaveFile;
    private LocalManagedBufferFile saveFile;
    private LocalBufferFile saveChangeFile;
    private boolean preSaveFailed = false;
    private boolean preSaveBackoff = false;
    private Object preSaveLock = new Object();
    private PreSaveTask preSaveTask;

    public LocalManagedBufferFile(int bufferSize, BufferFileManager bfManager, long checkinId) throws IOException {
        super(bfManager.getBufferFile(1), bufferSize);
        if (bfManager.getCurrentVersion() != 0) {
            throw new AssertException();
        }
        this.version = 1;
        this.bfMgr = bfManager;
        this.checkinId = checkinId;
    }

    public LocalManagedBufferFile(BufferFileManager bfManager, boolean versionUpdateEnabled, int minChangeDataVer, long checkinId) throws IOException {
        super(bfManager.getBufferFile(bfManager.getCurrentVersion()), true);
        this.bfMgr = bfManager;
        this.version = bfManager.getCurrentVersion();
        this.minChangeDataVer = minChangeDataVer;
        this.checkinId = checkinId;
        if (versionUpdateEnabled) {
            this.startPreSave();
        }
    }

    public LocalManagedBufferFile(BufferFileManager bfManager, int version, int minChangeDataVer) throws IOException {
        super(bfManager.getBufferFile(bfManager.getCurrentVersion()), true);
        this.version = version;
        this.minChangeDataVer = minChangeDataVer;
        int curVer = bfManager.getCurrentVersion();
        this.versionFileHandler = new VersionFileHandler(bfManager, this.getFileId(), curVer, version);
        this.setFileId(this.versionFileHandler.getOriginalFileID());
        this.setBufferCount(this.versionFileHandler.getOriginalBufferCount());
        this.setFreeIndexes(this.versionFileHandler.getFreeIndexList());
        String[] names = this.versionFileHandler.getOldParameterNames();
        this.clearParameters();
        for (int i = 0; i < names.length; ++i) {
            this.setParameter(names[i], this.versionFileHandler.getOldParameter(names[i]));
        }
    }

    private LocalManagedBufferFile(File presaveFile, int bufferSize) throws IOException {
        super(presaveFile, bufferSize);
    }

    @Override
    public BufferFile getNextChangeDataFile(boolean getFirst) throws IOException {
        File changedDataFile;
        if (this.bfMgr == null) {
            return null;
        }
        if (getFirst || this.nextChangeDataVer == -1) {
            int n = this.nextChangeDataVer = this.minChangeDataVer != -1 ? this.minChangeDataVer : this.version - 1;
        }
        if (this.nextChangeDataVer >= this.version) {
            return null;
        }
        if ((changedDataFile = this.bfMgr.getChangeDataFile(this.nextChangeDataVer++)) != null && (this.minChangeDataVer != -1 || changedDataFile.exists())) {
            return new LocalBufferFile(changedDataFile, true);
        }
        return null;
    }

    @Override
    void putFreeBlock(int index, int nextFreeIndex) throws IOException {
        this.versionBufferIfNeeded(index);
        super.putFreeBlock(index, nextFreeIndex);
        if (this.changeMap != null) {
            this.changeMap.bufferChanged(index, true);
        }
    }

    int getVersion() {
        return this.version;
    }

    @Override
    public long getCheckinID() {
        return this.checkinId;
    }

    @Override
    public void setVersionComment(String comment) throws IOException {
        this.comment = comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DataBuffer get(DataBuffer buf, int index) throws IOException {
        DataBuffer vbuf;
        if (index > this.getBufferCount()) {
            throw new EOFException("Buffer index too large (" + index + " > " + this.getBufferCount() + ")");
        }
        if (this.versionFileHandler != null && (vbuf = this.versionFileHandler.getOldBuffer(buf, index)) != null) {
            return vbuf;
        }
        Object object = this.preSaveLock;
        synchronized (object) {
            this.preSaveBackoff = true;
        }
        return super.get(buf, index);
    }

    @Override
    public synchronized void put(DataBuffer buf, int index) throws IOException {
        if (this.isReadOnly()) {
            throw new IOException("File is read-only");
        }
        if (index > 0x7FFFFFFE) {
            throw new EOFException("Buffer index too large, exceeds max-int");
        }
        this.versionBufferIfNeeded(index);
        boolean empty = buf.isEmpty();
        super.put(buf, index);
        if (this.changeMap != null) {
            this.changeMap.bufferChanged(index, empty);
        }
    }

    private void versionBufferIfNeeded(int index) throws IOException {
        if (this.versionOutFile != null && this.versionOutFile.isPutOK(index)) {
            DataBuffer oldBuf = new DataBuffer();
            oldBuf = this.get(oldBuf, index);
            if (oldBuf.data == null) {
                Msg.error((Object)this, (Object)"ERROR! Unexpected condition detected in LocalBufferFile.versionBufferIfNeeded");
            } else {
                this.versionOutFile.putOldBuffer(oldBuf, index);
            }
        }
    }

    @Override
    public synchronized boolean setReadOnly() throws IOException {
        if (!this.flush()) {
            return false;
        }
        if (this.versionOutFile != null) {
            this.versionOutFile.close();
            this.versionOutFile = null;
        }
        if (this.changeMap != null) {
            this.changeMap.close();
            this.changeMap = null;
        }
        super.setReadOnly();
        if (this.bfMgr != null) {
            this.bfMgr.versionCreated(this.version, this.comment, this.checkinId);
            this.startPreSave();
        }
        return true;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.stopPreSave(true);
        if (this.versionFileHandler != null) {
            this.versionFileHandler.close();
        }
        boolean comit = false;
        try {
            comit = this.flush();
            if (comit) {
                if (this.versionOutFile != null) {
                    this.versionOutFile.close();
                    this.versionOutFile = null;
                }
                if (this.changeMap != null) {
                    this.changeMap.close();
                    this.changeMap = null;
                }
            }
            super.close();
        }
        finally {
            if (this.bfMgr != null) {
                if (comit) {
                    this.bfMgr.versionCreated(this.version, this.comment, this.checkinId);
                }
                if (!this.isReadOnly() || this.saveFile != null) {
                    this.bfMgr.updateEnded(this.checkinId);
                }
            }
            if (this.versionOutFile != null) {
                this.versionOutFile.abort();
            }
            if (this.changeMap != null) {
                this.changeMap.abort();
            }
            this.disposeSaveFiles();
        }
    }

    @Override
    public synchronized boolean delete() {
        if (this.isClosed() || this.isReadOnly()) {
            return false;
        }
        boolean success = false;
        try {
            success = super.delete();
            if (this.versionOutFile != null) {
                try {
                    this.versionOutFile.abort();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.versionOutFile = null;
            }
            if (this.changeMap != null) {
                this.changeMap.abort();
                this.changeMap = null;
            }
        }
        finally {
            if (this.bfMgr != null) {
                this.bfMgr.updateEnded(this.checkinId);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getForwardModMapData() throws IOException {
        if (this.bfMgr == null) {
            return null;
        }
        File mf = this.bfMgr.getChangeMapFile();
        if (mf == null || !mf.exists()) {
            return null;
        }
        try (ChangeMapFile modMap = new ChangeMapFile(mf, this);){
            byte[] byArray = modMap.getModData();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getForwardModMapData(int oldVersion) throws IOException {
        if (this.bfMgr == null) {
            return null;
        }
        if (oldVersion < 1 || oldVersion >= this.version) {
            throw new IOException("Invalid mod-map version requested: " + oldVersion);
        }
        try (VersionFileHandler modMapGenerator = new VersionFileHandler(this.bfMgr, this.getFileId(), this.version, oldVersion);){
            byte[] byArray = modMapGenerator.getForwardModMapData();
            return byArray;
        }
    }

    @Override
    public BufferFile getSaveChangeDataFile() throws IOException {
        return this.saveChangeFile;
    }

    private void comitSaveChangeDataFile() throws IOException {
        if (this.saveChangeFile == null || !this.saveChangeFile.getFile().exists()) {
            throw new FileNotFoundException("Saved change data file not found");
        }
        File changeFile = this.saveChangeFile.getFile();
        File cfile = this.bfMgr.getChangeDataFile(this.version);
        File bakFile = null;
        if (cfile.exists() && !cfile.renameTo(bakFile = new File(cfile.getParentFile(), cfile.getName() + ".bak"))) {
            throw new IOException("Failed to update change data");
        }
        if (changeFile.renameTo(cfile)) {
            if (bakFile != null) {
                bakFile.delete();
            }
        } else {
            if (bakFile != null) {
                bakFile.renameTo(cfile);
            }
            throw new IOException("Failed to update change data - file may be in use");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewVersion(ManagedBufferFile destFile, String fileComment, TaskMonitor monitor) throws CancelledException, IOException {
        ManagedBufferFile outFile;
        if (monitor != null) {
            monitor.checkCancelled();
            monitor.setMessage("Opening versioned file for update...");
            monitor.setProgress(0L);
        }
        if ((outFile = destFile.getSaveFile()) == null) {
            throw new IOException("File update not permitted");
        }
        boolean success = false;
        BufferFile newChangeFile = null;
        BufferFile changeDataFile = null;
        try {
            if (monitor != null) {
                monitor.checkCancelled();
                monitor.setMessage("Creating new file version...");
            }
            outFile.setVersionComment(fileComment);
            changeDataFile = this.getNextChangeDataFile(true);
            if (changeDataFile == null) {
                throw new IOException("Unexpected state for check-in file");
            }
            BufferFile nextChangeDataFile = this.getNextChangeDataFile(false);
            if (nextChangeDataFile != null) {
                nextChangeDataFile.dispose();
                throw new IOException("Unexpected state for check-in file");
            }
            ChangeMap newChangeMap = new ChangeMap(this.getForwardModMapData());
            LocalManagedBufferFile.copyFile(this, outFile, newChangeMap, monitor);
            newChangeFile = destFile.getSaveChangeDataFile();
            LocalManagedBufferFile.copyFile(changeDataFile, newChangeFile, null, monitor);
            newChangeFile.close();
            newChangeFile = null;
            success = true;
        }
        finally {
            if (changeDataFile != null) {
                changeDataFile.dispose();
            }
            if (newChangeFile != null) {
                newChangeFile.dispose();
            }
            try {
                destFile.saveCompleted(success);
            }
            finally {
                outFile.dispose();
            }
        }
    }

    @Override
    public synchronized ManagedBufferFile getSaveFile() throws IOException {
        try {
            return this.getSaveFile(TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            return null;
        }
    }

    public synchronized LocalManagedBufferFile getSaveFile(TaskMonitor monitor) throws IOException, CancelledException {
        if (this.saveFile != null) {
            throw new IOException("Save already in progress");
        }
        this.waitForPreSave(monitor);
        this.saveFile = this.preSaveFile;
        this.preSaveFile = null;
        if (this.saveFile != null) {
            File changeFile;
            File mFile;
            if (this.getBufferCount() != this.saveFile.getBufferCount()) {
                throw new AssertException();
            }
            File vfile = this.bfMgr.getVersionFile(this.version);
            if (vfile != null) {
                this.saveFile.versionOutFile = new VersionFile(this, this.saveFile, vfile);
            }
            if ((mFile = this.bfMgr.getChangeMapFile()) != null) {
                this.saveFile.changeMap = new ChangeMapFile(mFile, this, this.saveFile);
            }
            if ((changeFile = this.bfMgr.getChangeDataFile(this.version)) != null) {
                changeFile = new File(changeFile.getParentFile(), changeFile.getName() + ".tmp");
                changeFile.delete();
                this.saveChangeFile = new LocalBufferFile(changeFile, this.getBufferSize());
            }
        }
        return this.saveFile;
    }

    private void disposeSaveFiles() {
        if (this.saveChangeFile != null) {
            this.saveChangeFile.dispose();
            this.saveChangeFile = null;
        }
        if (this.saveFile != null) {
            this.saveFile.dispose();
            this.saveFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void saveCompleted(boolean commit) throws IOException {
        if (this.saveFile == null) {
            throw new IOException("Save is not in progress");
        }
        if (!commit) {
            this.disposeSaveFiles();
            this.startPreSave();
            return;
        }
        int newVersion = this.version + 1;
        File newFile = this.bfMgr.getBufferFile(newVersion);
        boolean success = false;
        try {
            if (this.saveChangeFile != null) {
                this.saveChangeFile.close();
            }
            if (this.saveFile.renameFile(newFile)) {
                this.saveFile.version = newVersion;
                this.saveFile.bfMgr = this.bfMgr;
                this.saveFile.checkinId = this.checkinId;
                if (this.saveChangeFile != null) {
                    this.comitSaveChangeDataFile();
                }
                LocalManagedBufferFile.cleanupOldPreSaveFiles(newFile.getParentFile(), 0L);
                this.saveFile.setReadOnly();
                success = true;
            }
        }
        finally {
            if (!success) {
                this.saveFile.delete();
            }
            this.saveFile = null;
            this.saveChangeFile = null;
        }
        if (!success) {
            throw new IOException("File error during save");
        }
    }

    @Override
    public synchronized boolean canSave() {
        return this.preSaveFile != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPreSave() {
        Object object = this.preSaveLock;
        synchronized (object) {
            try {
                this.preSaveTask = new PreSaveTask();
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)("Unexpected Exception creating Pre-save file in : " + this.getFile().getParent() + ": " + t.getMessage()), (Throwable)t);
                this.preSaveFile = null;
                this.preSaveTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPreSave(boolean endUpdate) {
        PreSaveTask task;
        Object object = this.preSaveLock;
        synchronized (object) {
            task = this.preSaveTask;
            this.preSaveTask = null;
        }
        if (task != null) {
            task.cancelTask();
        }
        object = this;
        synchronized (object) {
            if (endUpdate && this.bfMgr != null && (this.preSaveFailed || this.preSaveFile != null)) {
                this.bfMgr.updateEnded(this.checkinId);
            }
            if (this.preSaveFile != null) {
                this.preSaveFile.delete();
                this.preSaveFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPreSave(TaskMonitor monitor) throws CancelledException {
        PreSaveTask task;
        Object object = this.preSaveLock;
        synchronized (object) {
            task = this.preSaveTask;
        }
        if (task != null) {
            task.waitForTask(monitor);
        }
    }

    @Override
    public OutputBlockStream getOutputBlockStream(int blockCount) throws IOException {
        return new LocalManagedOutputBlockStream(blockCount);
    }

    @Override
    public InputBlockStream getInputBlockStream() throws IOException {
        if (this.versionFileHandler != null) {
            return new LocalBufferFile.LocalBufferInputBlockStream();
        }
        return super.getInputBlockStream();
    }

    public InputBlockStream getInputBlockStream(byte[] changeMapData) throws IOException {
        return new LocalBufferFile.LocalRandomInputBlockStream(changeMapData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateFrom(ManagedBufferFile versionedBufferFile, int oldVersion, TaskMonitor monitor) throws IOException, CancelledException {
        if (!this.canSave()) {
            throw new IOException("File does not allow update");
        }
        if (this.bfMgr == null) {
            throw new UnsupportedOperationException("Buffer file is not associated with BufferFileManager");
        }
        byte[] versionedChanges = versionedBufferFile.getForwardModMapData(oldVersion);
        ChangeMap newChangeMap = new ChangeMap(versionedChanges);
        byte[] myModifiedBuffers = this.getForwardModMapData();
        if (myModifiedBuffers != null) {
            newChangeMap.addChangeMapData(myModifiedBuffers);
        }
        newChangeMap.setChangedIndexes(this.getFreeIndexes());
        newChangeMap.setUnchangedIndexes(versionedBufferFile.getFreeIndexes());
        LocalManagedBufferFile bf = this.getSaveFile(monitor);
        boolean success = false;
        try {
            LocalManagedBufferFile.copyFile(versionedBufferFile, bf, newChangeMap, monitor);
            int indexCount = versionedBufferFile.getIndexCount();
            if (indexCount < bf.getIndexCount()) {
                bf.truncate(indexCount);
            }
            success = true;
        }
        finally {
            this.saveCompleted(success);
            if (!success) {
                this.bfMgr.updateEnded(this.checkinId);
            }
        }
    }

    private class PreSaveTask
    implements Runnable {
        private BufferFile srcFile;
        private volatile Thread taskThread;
        private Thread monitorThread;
        private TaskMonitor monitor;
        private int maxIndex;
        private int curIndex;

        PreSaveTask() throws IOException {
            File psFile = File.createTempFile("tmp", ".ps", LocalManagedBufferFile.this.getFile().getParentFile());
            psFile.delete();
            this.srcFile = new LocalManagedBufferFile(LocalManagedBufferFile.this.bfMgr, false, -1, LocalManagedBufferFile.this.checkinId);
            LocalManagedBufferFile.this.preSaveFile = new LocalManagedBufferFile(psFile, LocalManagedBufferFile.this.getBufferSize());
            this.taskThread = new Thread((Runnable)this, "Pre-Save");
            this.taskThread.setPriority(1);
            this.taskThread.start();
        }

        public void cancelTask() {
            if (this.taskThread.isAlive()) {
                this.taskThread.interrupt();
                try {
                    this.taskThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForTask(TaskMonitor taskMonitor) throws CancelledException {
            if (this.taskThread.isAlive()) {
                if (taskMonitor != null) {
                    Object object = LocalManagedBufferFile.this.preSaveLock;
                    synchronized (object) {
                        taskMonitor.initialize((long)this.maxIndex);
                        taskMonitor.setProgress((long)this.curIndex);
                        this.monitor = taskMonitor;
                        this.monitorThread = Thread.currentThread();
                    }
                }
                try {
                    this.taskThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (taskMonitor != null) {
                    taskMonitor.checkCancelled();
                }
            }
        }

        private void checkPreSaveMonitor() {
            if (this.monitor == null) {
                return;
            }
            if (this.taskThread.isInterrupted()) {
                this.monitor.cancel();
            }
            if (this.monitor.isCancelled()) {
                this.monitorThread.interrupt();
                this.monitor = null;
                this.monitorThread = null;
            } else {
                this.monitor.setProgress((long)this.curIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            DataBuffer buf = new DataBuffer(LocalManagedBufferFile.this.getBufferSize());
            boolean success = false;
            try {
                Thread.sleep(100L);
                int cnt = this.srcFile.getIndexCount();
                this.maxIndex = cnt - 1;
                this.curIndex = 0;
                block42: while (true) {
                    if (this.curIndex >= cnt) {
                        success = true;
                        return;
                    }
                    while (true) {
                        Object object = LocalManagedBufferFile.this.preSaveLock;
                        synchronized (object) {
                            this.checkPreSaveMonitor();
                            if (this.taskThread.isInterrupted()) {
                                return;
                            }
                            if (!LocalManagedBufferFile.this.preSaveBackoff) {
                                // MONITOREXIT @DISABLED, blocks:[0, 21, 42, 43, 45] lbl20 : MonitorExitStatement: MONITOREXIT : var4_14
                                this.srcFile.get(buf, this.curIndex);
                                LocalManagedBufferFile.this.preSaveFile.put(buf, this.curIndex);
                                ++this.curIndex;
                                continue block42;
                            }
                            LocalManagedBufferFile.this.preSaveBackoff = false;
                        }
                        Thread.sleep(50L);
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                this.checkPreSaveMonitor();
                return;
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)t);
                return;
            }
            finally {
                if (!success) {
                    LocalManagedBufferFile.this.preSaveFile.setTemporary(true);
                    try {
                        LocalManagedBufferFile.this.preSaveFile.close();
                    }
                    catch (IOException e) {
                        Msg.error((Object)this, (Object)e);
                    }
                    finally {
                        LocalManagedBufferFile.this.preSaveFile = null;
                        LocalManagedBufferFile.this.preSaveFailed = true;
                    }
                }
                try {
                    this.srcFile.close();
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)e);
                }
            }
        }
    }

    class LocalManagedOutputBlockStream
    extends LocalBufferFile.LocalOutputBlockStream {
        public LocalManagedOutputBlockStream(int blockCount) throws IOException {
            super(blockCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeBlock(BufferFileBlock block) throws IOException {
            LocalManagedBufferFile localManagedBufferFile = LocalManagedBufferFile.this;
            synchronized (localManagedBufferFile) {
                int bufferIndex = block.getIndex() - 1;
                if (bufferIndex >= 0) {
                    LocalManagedBufferFile.this.versionBufferIfNeeded(bufferIndex);
                }
                super.writeBlock(block);
                if (LocalManagedBufferFile.this.changeMap != null && bufferIndex >= 0) {
                    LocalManagedBufferFile.this.changeMap.bufferChanged(bufferIndex, false);
                }
            }
        }
    }
}

