/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.gadp;

import agent.frida.gadp.FridaGadpServer;
import ghidra.dbg.gadp.server.AbstractGadpLocalDebuggerModelFactory;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.program.model.listing.Program;
import java.util.List;

@ConfigurableFactory.FactoryDescription(brief="PROTOTYPE: Frida via GADP", htmlDetails="Connect to Frida.\nThis is an experimental connector. Use at your own risk.\nThis will protect Ghidra's JVM by using a subprocess to access the native API.")
public class FridaGadpDebuggerModelFactory
extends AbstractGadpLocalDebuggerModelFactory {
    public int getPriority(Program program) {
        String exe;
        String osname = System.getProperty("os.name").toLowerCase();
        if (!(osname.contains("mac os x") || osname.contains("linux") || osname.contains("windows"))) {
            return -1;
        }
        if (program != null && ((exe = program.getExecutablePath()) == null || exe.isBlank())) {
            return -1;
        }
        return 25;
    }

    protected String getThreadName() {
        return "Local Frida Agent stdout";
    }

    protected Class<?> getServerClass() {
        return FridaGadpServer.class;
    }

    protected void completeCommandLine(List<String> cmd) {
        cmd.add(this.getServerClass().getCanonicalName());
        cmd.addAll(List.of("-H", this.host));
        cmd.addAll(List.of("-p", Integer.toString(this.port)));
    }
}

