/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager;

import com.sun.jna.NativeLong;
import ghidra.util.Msg;

public enum FridaState {
    FRIDA_THREAD_RUNNING("running"),
    FRIDA_THREAD_STOPPED("stopped"),
    FRIDA_THREAD_WAITING("waiting"),
    FRIDA_THREAD_UNINTERRUPTIBLE("uninterruptible"),
    FRIDA_THREAD_HALTED("halted");

    final String str;

    private FridaState(String str) {
        this.str = str;
    }

    public String toString() {
        return this.str;
    }

    public static FridaState byValue(String val) {
        for (FridaState state : FridaState.values()) {
            if (!state.str.equals(val)) continue;
            return state;
        }
        Msg.warn(FridaState.class, (Object)("No such value: " + val));
        return null;
    }

    public static FridaState getState(NativeLong state) {
        return FridaState.values()[state.intValue()];
    }
}

