/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaExport;
import agent.frida.manager.FridaModule;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class FridaListModuleExportsCommand
extends AbstractFridaCommand<Map<String, FridaExport>> {
    protected final FridaModule module;
    private Map<String, FridaExport> exports;

    public FridaListModuleExportsCommand(FridaManagerImpl manager, FridaModule module) {
        super(manager);
        this.module = module;
    }

    @Override
    public Map<String, FridaExport> complete(FridaPendingCommand<?> pending) {
        return this.exports;
    }

    @Override
    public void invoke() {
        this.exports = new HashMap<String, FridaExport>();
        this.manager.loadScript(this, "list_module_Exports", "result = Process.findModuleByAddress('" + this.module.getRangeAddress() + "').enumerateExports();");
        for (FridaExport imp : this.exports.values()) {
            this.exports.put(FridaClient.getId(imp), imp);
        }
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        FridaExport export = new FridaExport(this.module);
        JsonObject symDetails = element.getAsJsonObject();
        export.setAddress(symDetails.get("address").getAsString());
        export.setName(symDetails.get("name").getAsString());
        export.setType(symDetails.get("type").getAsString());
        this.exports.put(FridaClient.getId(export), export);
    }
}

