/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;

public class FridaWatchMemoryCommand
extends AbstractFridaCommand<Void> {
    private Map<String, ?> arguments;

    public FridaWatchMemoryCommand(FridaManagerImpl manager, Map<String, ?> arguments) {
        super(manager);
        this.arguments = arguments;
    }

    @Override
    public void invoke() {
        Object addr = (String)this.arguments.get("Address");
        if (!((String)addr).startsWith("0x")) {
            addr = "0x" + (String)addr;
        }
        Long size = (Long)this.arguments.get("Size");
        String cmd = "MemoryAccessMonitor.enable({ base: ptr(" + (String)addr + "),   size: " + size + " }, { ";
        try {
            String onAccess = (String)this.arguments.get("OnAccess");
            FileInputStream fis = new FileInputStream(new File(onAccess));
            byte[] bytes = fis.readAllBytes();
            String str = new String(bytes);
            cmd = cmd + str + "});";
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.manager.loadPermanentScript(this, (String)this.arguments.get("Name"), cmd);
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        Msg.info((Object)this, (Object)element);
        this.manager.unloadPermanentScript(this.getName());
    }
}

