/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.model.iface1.FridaModelTargetConfigurable;
import agent.frida.model.iface2.FridaModelTargetAvailableDevice;
import agent.frida.model.iface2.FridaModelTargetAvailableDevicesContainer;
import agent.frida.model.iface2.FridaModelTargetRoot;
import agent.frida.model.impl.FridaModelTargetAvailableDeviceImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

@TargetObjectSchemaInfo(name="AvailableDevicesContainer", elements={@TargetElementType(type=FridaModelTargetAvailableDeviceImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ALWAYS, attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class FridaModelTargetAvailableDevicesContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetAvailableDevicesContainer,
FridaModelTargetConfigurable {
    protected final Map<String, FridaModelTargetAvailableDevice> attachablesById = new WeakValueHashMap();

    public FridaModelTargetAvailableDevicesContainerImpl(FridaModelTargetRoot root) {
        super(root.getModel(), (TargetObject)root, "AvailableDevices", "AvailableDevicesContainer");
        this.changeAttributes(List.of(), Map.of("_base", 16), "Initialized");
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getManager().listAvailableDevices().thenAccept(list -> {
            List available;
            FridaModelTargetAvailableDevicesContainerImpl fridaModelTargetAvailableDevicesContainerImpl = this;
            synchronized (fridaModelTargetAvailableDevicesContainerImpl) {
                available = list.stream().map(this::getTargetAttachableEx).collect(Collectors.toList());
            }
            this.setElements(available, Map.of(), "Refreshed");
        });
    }

    public synchronized FridaModelTargetAvailableDevice getTargetAttachableEx(Pair<String, String> pair) {
        return this.attachablesById.computeIfAbsent((String)pair.getLeft(), i -> new FridaModelTargetAvailableDeviceImpl(this, (String)pair.getLeft(), (String)pair.getRight()));
    }

    @Override
    public synchronized FridaModelTargetAvailableDevice getTargetAttachable(String pid) {
        return this.attachablesById.computeIfAbsent(pid, i -> new FridaModelTargetAvailableDeviceImpl(this, pid));
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (FridaModelTargetAvailableDevice child : this.attachablesById.values()) {
                        child.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.nil();
    }
}

