/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaSymbol;
import agent.frida.model.iface2.FridaModelTargetSymbol;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetSymbolContainerImpl;
import agent.frida.model.methods.FridaModelTargetFunctionInterceptorImpl;
import agent.frida.model.methods.FridaModelTargetUnloadScriptImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Symbol", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="_namespace", type=FridaModelTargetSymbolContainerImpl.class), @TargetAttributeType(name="_value", type=Address.class), @TargetAttributeType(name="_size", type=long.class), @TargetAttributeType(name="Name", type=String.class), @TargetAttributeType(name="Size", type=long.class), @TargetAttributeType(name="TypeId", type=int.class), @TargetAttributeType(name="Tag", type=int.class), @TargetAttributeType(type=Object.class)})
public class FridaModelTargetSymbolImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetSymbol {
    protected final boolean constant;
    protected Address value;
    protected long size;
    private FridaModelTargetFunctionInterceptorImpl intercept;
    private FridaModelTargetUnloadScriptImpl unload;

    protected static String indexSymbol(FridaSymbol symbol) {
        return symbol.getName();
    }

    protected static String keySymbol(FridaSymbol symbol) {
        return PathUtils.makeKey((String)FridaModelTargetSymbolImpl.indexSymbol(symbol));
    }

    public FridaModelTargetSymbolImpl(FridaModelTargetSymbolContainerImpl symbols, FridaSymbol symbol) {
        super(symbols.getModel(), (TargetObject)symbols, FridaModelTargetSymbolImpl.keySymbol(symbol), symbol, "Symbol");
        this.constant = false;
        try {
            this.value = symbols.getModel().getAddressSpace("ram").getAddress(symbol.getAddress());
        }
        catch (AddressFormatException e) {
            e.printStackTrace();
        }
        this.size = symbol.getSize();
        this.intercept = new FridaModelTargetFunctionInterceptorImpl(this);
        this.unload = new FridaModelTargetUnloadScriptImpl(this, this.intercept.getName());
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDescription(0), "_namespace", symbols, "_value", this.value, "_size", this.size), "Initialized");
        this.changeAttributes(List.of(), List.of(), Map.of("Name", symbol.getName(), "Address", symbol.getAddress(), "Size", this.size, "Type", symbol.getType(), "IsGlobal", symbol.isGlobal(), this.intercept.getName(), this.intercept, this.unload.getName(), this.unload), "Initialized");
        if (symbol.getSectionId() != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("Section", symbol.getSectionId()), "Initialized");
        }
    }

    @Override
    public String getDescription(int level) {
        FridaSymbol symbol = (FridaSymbol)this.getModelObject();
        return symbol.getName();
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public Address getValue() {
        return this.value;
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

