/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk.v2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.fbpk.FBPT_Entry;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class FBPTv2_Entry
extends FBPT_Entry {
    private String name;
    private String guid1;
    private String guid2;
    private String format;
    private int unknown1;
    private int unknown2;
    private int unknown3;
    private boolean isLast;

    public FBPTv2_Entry(BinaryReader reader, boolean isLast) throws IOException {
        this.isLast = isLast;
        this.name = reader.readNextAsciiString(36);
        this.guid1 = reader.readNextAsciiString(37);
        this.guid2 = reader.readNextAsciiString(37);
        this.format = reader.readNextAsciiString(14);
        this.unknown1 = reader.readNextInt();
        this.unknown2 = reader.readNextInt();
        this.unknown3 = reader.readNextInt();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getGuid1() {
        return this.guid1;
    }

    public String getGuid2() {
        return this.guid2;
    }

    public String getFormat() {
        return this.format;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public int getUnknown3() {
        return this.unknown3;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(FBPTv2_Entry.class.getSimpleName(), 0);
        struct.add(STRING, 36, "name", null);
        struct.add(STRING, 37, "guid1", null);
        struct.add(STRING, 37, "guid2", null);
        struct.add(STRING, 14, "format", null);
        struct.add(DWORD, "unknown1", null);
        struct.add(DWORD, "unknown2", null);
        struct.add(DWORD, "unknown3", null);
        return struct;
    }
}

