/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.android.cdex.CDexHeader;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.vdex.UnsupportedVdexVersionException;
import ghidra.file.formats.android.vdex.VdexHeader;
import ghidra.file.formats.android.vdex.VdexHeaderFactory;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@FileSystemInfo(type="androidvdex", description="Android VDEX (for extracting embedded DEX files)", factory=GFileSystemBaseFactory.class)
public class VdexFileSystem
extends GFileSystemBase {
    private VdexHeader header;
    private List<GFile> listing = new ArrayList<GFile>();

    public VdexFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        try {
            byte[] magicBytes = this.provider.readBytes(0L, (long)"vdex".length());
            return "vdex".equals(new String(magicBytes));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        monitor.setMessage("Parsing VDEX header...");
        BinaryReader reader = new BinaryReader(this.provider, true);
        try {
            this.header = VdexHeaderFactory.getVdexHeader(reader);
            this.header.parse(reader, monitor);
            for (int i = 0; i < this.header.getDexHeaderList().size(); ++i) {
                monitor.checkCancelled();
                DexHeader dexHeader = this.header.getDexHeaderList().get(i);
                String name = dexHeader instanceof CDexHeader ? "cdex_" + i : "classes" + i + ".dex";
                GFileImpl file = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)name, null, (boolean)false, (long)Integer.toUnsignedLong(dexHeader.getFileSize()));
                this.listing.add((GFile)file);
            }
        }
        catch (UnsupportedVdexVersionException e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        super.close();
        this.header = null;
        this.listing.clear();
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals(this.root)) {
            return this.listing;
        }
        return Collections.emptyList();
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        int index = this.listing.indexOf(file);
        if (index < 0) {
            throw new IOException("Unknown file: " + file);
        }
        DexHeader dexHeader = this.header.getDexHeaderList().get(index);
        long startIndex = this.header.getDexStartOffset(index);
        return new ByteProviderWrapper(this.provider, startIndex, Integer.toUnsignedLong(dexHeader.getFileSize()), file.getFSRL());
    }
}

