/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.zip;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.zip.ZipFileSystemFactory;
import ghidra.formats.gfilesystem.AbstractFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@FileSystemInfo(type="zip", description="ZIP", factory=ZipFileSystemFactory.class, priority=10)
public class ZipFileSystemBuiltin
extends AbstractFileSystem<ZipEntry> {
    static final String TEMPFILE_PREFIX = "ghidra_tmp_zipfile";
    private ZipFile zipFile;

    public ZipFileSystemBuiltin(FSRLRoot fsFSRL, FileSystemService fsService) {
        super(fsFSRL, fsService);
    }

    public void close() throws IOException {
        this.refManager.onClose();
        if (this.zipFile != null) {
            this.zipFile.close();
            this.zipFile = null;
        }
        this.fsIndex.clear();
    }

    public boolean isClosed() {
        return this.zipFile == null;
    }

    public void mount(File f, boolean deleteFileWhenDone, TaskMonitor monitor) throws CancelledException, IOException {
        deleteFileWhenDone = deleteFileWhenDone && f.getName().startsWith(TEMPFILE_PREFIX);
        int openMode = deleteFileWhenDone ? 5 : 1;
        this.zipFile = new ZipFile(f, openMode);
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            monitor.checkCancelled();
            ZipEntry currentEntry = entries.nextElement();
            this.fsIndex.storeFile(currentEntry.getName(), -1L, currentEntry.isDirectory(), currentEntry.getSize(), (Object)currentEntry);
        }
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        ZipEntry zipEntry = (ZipEntry)this.fsIndex.getMetadata(file);
        if (zipEntry == null) {
            return null;
        }
        FileAttributes result = new FileAttributes();
        result.add(FileAttributeType.COMMENT_ATTR, (Object)zipEntry.getComment());
        result.add(FileAttributeType.SIZE_ATTR, (Object)zipEntry.getSize());
        Date date = new Date(zipEntry.getLastModifiedTime().toMillis());
        result.add(FileAttributeType.MODIFIED_DATE_ATTR, (Object)date);
        result.add(FileAttributeType.COMPRESSED_SIZE_ATTR, (Object)zipEntry.getCompressedSize());
        result.add("CRC", (Object)Long.toHexString(zipEntry.getCrc()));
        result.add("Compression Method", (Object)("0x" + Integer.toHexString(zipEntry.getMethod())));
        return result;
    }

    public String toString() {
        return "ZipFilesystemBuiltin [ fsrl=" + this.fsFSRL + ", filename=" + this.zipFile.getName() + " ]";
    }

    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        ZipEntry zipEntry = (ZipEntry)this.fsIndex.getMetadata(file);
        return zipEntry != null ? this.zipFile.getInputStream(zipEntry) : null;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        ZipEntry zipEntry = (ZipEntry)this.fsIndex.getMetadata(file);
        if (zipEntry == null) {
            return null;
        }
        return this.fsService.getDerivedByteProvider(this.fsFSRL.getContainer(), file.getFSRL(), zipEntry.getName(), zipEntry.getSize(), () -> this.zipFile.getInputStream(zipEntry), monitor);
    }
}

