/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bsfv;

import docking.Tool;
import docking.action.builder.ActionBuilder;
import generic.jar.ResourceFile;
import ghidra.app.decompiler.DecompilerHighlightService;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.services.GoToService;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.bsfv.BsfvTableProvider;
import ghidra.features.bsim.query.client.Configuration;
import ghidra.framework.Application;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.IOException;
import org.xml.sax.SAXException;

@PluginInfo(status=PluginStatus.RELEASED, packageName="BSim", category="BSim", shortDescription="BSim Feature Visualizer", description="Displays BSim features as graphs and highlighted regions in the decompiler.", servicesRequired={GoToService.class, GraphDisplayBroker.class, DecompilerHighlightService.class}, eventsProduced={ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class})
public class BSimFeatureVisualizerPlugin
extends ProgramPlugin
implements DomainObjectListener,
OptionsChangeListener {
    private BsfvTableProvider provider;
    private Function currentFunction;
    public static final String BSIM_FEATURE_VISUALIZER_OPTION_NAME = "BsimFeatureVisualizer";
    public static final String DB_CONFIG_FILE = "Database Configuration File";
    public static final String REUSE_GRAPH = "Reuse Graph";
    public static final String DECOMPILER_TIMEOUT = "Decompiler Timeout";
    public static final String HIGHLIGHT_BY_ROW = "Highlight by Row";
    public static final String BSIM_FEATURE_VISUALIZER_ACTION = "Show BSim Feature Visualizer";
    private String dbConfigFile = "medium_nosize.xml";
    private boolean reuseGraph = true;
    private boolean highlightByRow = true;
    private int decompilerTimeout = 10;
    private DecompilerHighlightService highlightService;

    public BSimFeatureVisualizerPlugin(PluginTool tool) {
        super(tool);
    }

    public void init() {
        this.initOptions(this.tool.getOptions(BSIM_FEATURE_VISUALIZER_OPTION_NAME));
        this.highlightService = (DecompilerHighlightService)this.getTool().getService(DecompilerHighlightService.class);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(BSIM_FEATURE_VISUALIZER_ACTION, this.getName()).menuPath(new String[]{"BSim", "BSim Feature Visualizer"})).helpLocation(new HelpLocation(this.getName(), this.getName()))).onAction(c -> {
            if (this.currentLocation != null) {
                FunctionManager functionManager = this.currentProgram.getFunctionManager();
                this.currentFunction = functionManager.getFunctionContaining(this.currentLocation.getAddress());
            }
            this.provider = new BsfvTableProvider(this);
        })).buildAndInstall((Tool)this.tool);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        switch (optionName) {
            case "Database Configuration File": {
                this.dbConfigFile = (String)newValue;
                if (this.provider == null) break;
                this.provider.reload();
                break;
            }
            case "Reuse Graph": {
                this.reuseGraph = (Boolean)newValue;
                break;
            }
            case "Decompiler Timeout": {
                this.decompilerTimeout = (Integer)newValue;
                if (this.provider == null) break;
                this.provider.reload();
                break;
            }
            case "Highlight by Row": {
                this.highlightByRow = (Boolean)newValue;
                break;
            }
            default: {
                Msg.error((Object)((Object)this), (Object)("Unrecognized option: " + optionName));
            }
        }
    }

    protected void locationChanged(ProgramLocation location) {
        if (this.provider == null) {
            return;
        }
        if (location == null) {
            return;
        }
        if (this.currentFunction != null && this.currentFunction.getBody().contains(location.getAddress())) {
            return;
        }
        FunctionManager functionManager = this.currentProgram.getFunctionManager();
        this.currentFunction = functionManager.getFunctionContaining(location.getAddress());
        if (this.currentFunction == null) {
            return;
        }
        this.provider.reload();
    }

    protected void programActivated(Program program) {
        if (this.provider == null) {
            return;
        }
        program.addListener((DomainObjectListener)this);
        if (this.currentLocation != null) {
            FunctionManager functionManager = this.currentProgram.getFunctionManager();
            this.currentFunction = functionManager.getFunctionContaining(this.currentLocation.getAddress());
        }
        this.provider.programOpened(program);
    }

    protected void programDeactivated(Program program) {
        this.currentFunction = null;
        program.removeListener((DomainObjectListener)this);
        if (this.provider != null) {
            this.provider.programDeactivated();
        }
    }

    Function getFunction() {
        return this.currentFunction;
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (this.provider != null) {
            this.provider.reload();
        }
    }

    public void dispose() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        if (this.provider != null) {
            this.provider.dispose();
        }
        super.dispose();
    }

    int getSignatureSettings() {
        ResourceFile dbConfigurationFile = Application.findDataFileInAnyModule((String)this.dbConfigFile);
        if (dbConfigurationFile == null) {
            Msg.showError((Object)((Object)this), null, (String)"File not found", (Object)("Couldn't find file " + this.dbConfigFile));
            return 0;
        }
        Configuration dbConfig = new Configuration();
        try {
            dbConfig.loadTemplate(dbConfigurationFile.getParentFile(), this.dbConfigFile.substring(0, this.dbConfigFile.length() - 4));
        }
        catch (IOException | SAXException e) {
            Msg.showError((Object)dbConfig, null, (String)("Problem with configuration file " + this.dbConfigFile), (Object)e.getMessage());
        }
        return dbConfig.info.settings;
    }

    public boolean getReuseGraph() {
        return this.reuseGraph;
    }

    public int getDecompilerTimeout() {
        return this.decompilerTimeout;
    }

    public boolean getHighlightByRow() {
        return this.highlightByRow;
    }

    DecompilerHighlightService getDecompilerHighlightService() {
        return this.highlightService;
    }

    private void initOptions(ToolOptions options) {
        options.registerOption(DB_CONFIG_FILE, (Object)this.dbConfigFile, new HelpLocation(this.getName(), "Config_File"), "Database configuration file to read signature settings from.");
        this.dbConfigFile = options.getString(DB_CONFIG_FILE, this.dbConfigFile);
        options.registerOption(REUSE_GRAPH, (Object)this.reuseGraph, new HelpLocation(this.getName(), "Reuse_Graph"), "Clear and re-use the graph window or create new graph window when graphing features.");
        this.reuseGraph = options.getBoolean(REUSE_GRAPH, this.reuseGraph);
        options.registerOption(DECOMPILER_TIMEOUT, (Object)this.decompilerTimeout, new HelpLocation(this.getName(), "Decompiler_Timeout"), "Decompiler Timeout (seconds)");
        this.decompilerTimeout = options.getInt(DECOMPILER_TIMEOUT, this.decompilerTimeout);
        options.registerOption(HIGHLIGHT_BY_ROW, (Object)this.highlightByRow, new HelpLocation(this.getName(), "Highlight_By_Row"), "Highlight feature in decompiler whenever selected row changes");
        this.highlightByRow = options.getBoolean(HIGHLIGHT_BY_ROW, this.highlightByRow);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }
}

