/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.NotFoundException;

public class Xtensa_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 94 || elf.e_machine() == 43975;
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (!this.canRelocate(elf)) {
            return RelocationResult.FAILURE;
        }
        int type = relocation.getType();
        if (0 == type) {
            return RelocationResult.SKIPPED;
        }
        Program program = elfRelocationContext.getProgram();
        ElfSymbol sym = null;
        String symbolName = null;
        int symbolIndex = relocation.getSymbolIndex();
        if (symbolIndex != 0) {
            sym = elfRelocationContext.getSymbol(symbolIndex);
        }
        if (null != sym) {
            symbolName = sym.getNameAsString();
        }
        switch (type) {
            case 1: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 2: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_RTLD", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 3: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_GLOB_DAT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 4: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_JMP_SLOT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 5: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_RELATIVE", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 6: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_PLT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 8: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_OP0", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 9: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_OP1", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 10: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_OP2", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 11: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_ASM_EXPAND", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 12: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_ASM_SIMPLIFY", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 15: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_GNU_VTINHERIT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 16: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_GNU_VTENTRY", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 17: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_DIFF8", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 18: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_DIFF16", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 19: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_DIFF32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 20: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT0_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 21: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT1_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 22: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT2_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 23: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT3_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 24: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT4_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 25: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT5_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 26: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT6_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 27: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT7_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 28: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT8_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 29: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT9_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 30: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT10_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 31: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT11_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 32: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT12_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 33: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT13_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 34: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT14_OP", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 35: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT0_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 36: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT1_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 37: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT2_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 38: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT3_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 39: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT4_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 40: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT5_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 41: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT6_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 42: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT7_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 43: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT8_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 44: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT9_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 45: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT10_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 46: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT11_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 47: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT12_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 48: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT13_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 49: {
                Xtensa_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_XTENSA_SLOT14_ALT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            default: {
                Xtensa_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
            }
        }
        return RelocationResult.UNSUPPORTED;
    }
}

