/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.overview;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import generic.lsh.vector.LSHVectorFactory;
import ghidra.docking.settings.Settings;
import ghidra.features.bsim.gui.overview.BSimOverviewRowObject;
import ghidra.features.bsim.gui.search.results.BSimMatchResultsModel;
import ghidra.features.bsim.query.protocol.ResponseNearestVector;
import ghidra.features.bsim.query.protocol.SimilarityVectorResult;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class BSimOverviewModel
extends AddressBasedTableModel<BSimOverviewRowObject> {
    static final int NAME_COL = 0;
    static final int HIT_COL = 1;
    static final int SELF_COL = 2;
    static final int ADDRESS_COL = 3;
    private List<BSimOverviewRowObject> results = new ArrayList<BSimOverviewRowObject>();
    private LSHVectorFactory vectorFactory;

    BSimOverviewModel(PluginTool tool, Program program, LSHVectorFactory vFactory) {
        super("Query Overview", (ServiceProvider)tool, null, null);
        this.vectorFactory = vFactory;
        this.setProgram(program);
    }

    protected TableColumnDescriptor<BSimOverviewRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new FuncNameColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new HitCountColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new SelfSignificanceColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new VectorHashColumn());
        return descriptor;
    }

    public Address getAddress(int row) {
        return ((BSimOverviewRowObject)this.getRowObject(row)).getFunctionEntryPoint();
    }

    protected void doLoad(Accumulator<BSimOverviewRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.results.isEmpty()) {
            return;
        }
        for (BSimOverviewRowObject row : this.results) {
            accumulator.add((Object)row);
        }
    }

    void addResult(ResponseNearestVector response) {
        if (response == null) {
            return;
        }
        for (SimilarityVectorResult result : response.result) {
            Address addr = BSimMatchResultsModel.recoverAddress(result.getBase(), this.program);
            BSimOverviewRowObject row = new BSimOverviewRowObject(result, addr, this.vectorFactory);
            this.addObject(row);
        }
    }

    void reload(Program newProgram, ResponseNearestVector response) {
        this.setProgram(newProgram);
        if (response == null || response.result.isEmpty()) {
            this.clear();
            return;
        }
        this.results.clear();
        for (SimilarityVectorResult result : response.result) {
            Address addr = BSimMatchResultsModel.recoverAddress(result.getBase(), this.program);
            BSimOverviewRowObject row = new BSimOverviewRowObject(result, addr, this.vectorFactory);
            this.results.add(row);
        }
        super.reload();
    }

    void clear() {
        this.clearData();
    }

    private static class FuncNameColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimOverviewRowObject, String> {
        private FuncNameColumn() {
        }

        public String getColumnName() {
            return "Function Name";
        }

        public String getValue(BSimOverviewRowObject rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getFunctionName();
        }

        public int getColumnPreferredWidth() {
            return 400;
        }
    }

    private static class HitCountColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimOverviewRowObject, Integer> {
        private HitCountColumn() {
        }

        public String getColumnName() {
            return "Hit Count";
        }

        public Integer getValue(BSimOverviewRowObject rowObject, Settings settings, Program data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getHitCount();
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private static class SelfSignificanceColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimOverviewRowObject, Double> {
        private SelfSignificanceColumn() {
        }

        public String getColumnName() {
            return "Self Significance";
        }

        public Double getValue(BSimOverviewRowObject rowObject, Settings settings, Program data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSelfSignificance();
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private static class VectorHashColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimOverviewRowObject, Long> {
        private LongHexRenderer hexRenderer = new LongHexRenderer();

        private VectorHashColumn() {
        }

        public String getColumnName() {
            return "Vector Hash";
        }

        public Long getValue(BSimOverviewRowObject rowObject, Settings settings, Program data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getVectorHash();
        }

        public GColumnRenderer<Long> getColumnRenderer() {
            return this.hexRenderer;
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private static class LongHexRenderer
    extends AbstractGColumnRenderer<Long> {
        private LongHexRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            label.setHorizontalAlignment(4);
            Long value = (Long)data.getValue();
            if (value != null) {
                label.setText(this.getValueString(value));
            }
            return label;
        }

        protected void configureFont(JTable table, TableModel model, int column) {
            this.setFont(this.fixedWidthFont);
        }

        public String getFilterString(Long t, Settings settings) {
            return this.getValueString(t);
        }

        private String getValueString(Long v) {
            if (v == null) {
                return "";
            }
            return String.format("%016X", v);
        }
    }
}

