/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import ghidra.features.bsim.gui.search.dialog.AbstractBSimSearchDialog;
import ghidra.features.bsim.gui.search.dialog.BSimFilterSet;
import ghidra.features.bsim.gui.search.dialog.BSimSearchService;
import ghidra.features.bsim.gui.search.dialog.BSimSearchSettings;
import ghidra.features.bsim.gui.search.dialog.BSimServerManager;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;

public class BSimOverviewDialog
extends AbstractBSimSearchDialog {
    private Program program;

    public BSimOverviewDialog(PluginTool tool, BSimSearchService service, BSimServerManager serverManager) {
        super("BSim Overview", tool, service, serverManager);
        this.setOkButtonText("Overview");
        this.setHelpLocation(new HelpLocation("BSimSearchPlugin", "BSim_Overview_Dialog"));
    }

    protected void okCallback() {
        this.searchService.performOverview(this.serverCache, this.getSearchSettings());
        this.close();
    }

    protected BSimSearchSettings getSearchSettings() {
        BSimSearchSettings lastUsed = this.searchService.getLastUsedSearchSettings();
        double similarity = this.similarityField.getValue();
        double confidence = this.confidenceField.getValue();
        int maxResults = lastUsed.getMaxResults();
        BSimFilterSet filterSet = lastUsed.getBSimFilterSet().copy();
        return new BSimSearchSettings(similarity, confidence, maxResults, filterSet);
    }

    public Program getProgram() {
        return this.program;
    }
}

