/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import ghidra.features.bsim.gui.search.dialog.BSimServerManagerListener;
import ghidra.features.bsim.query.BSimPostgresDBConnectionManager;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.file.BSimH2FileDBConnectionManager;
import ghidra.framework.Application;
import ghidra.framework.options.GProperties;
import ghidra.framework.options.JSonProperties;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class BSimServerManager {
    private Set<BSimServerInfo> serverInfos = new HashSet<BSimServerInfo>();
    private List<BSimServerManagerListener> listeners = new CopyOnWriteArrayList<BSimServerManagerListener>();

    public BSimServerManager() {
        List files = Application.getUserSettingsFiles((String)"bsim", (String)".server.properties");
        for (File file : files) {
            BSimServerInfo info = this.readBsimServerInfoFile(file);
            if (info == null) continue;
            this.serverInfos.add(info);
        }
    }

    public Set<BSimServerInfo> getServerInfos() {
        return new HashSet<BSimServerInfo>(this.serverInfos);
    }

    private BSimServerInfo readBsimServerInfoFile(File file) {
        try {
            JSonProperties properties = new JSonProperties(file);
            String dbTypeName = properties.getString("DBType", null);
            BSimServerInfo.DBType dbType = BSimServerInfo.DBType.valueOf(dbTypeName);
            String name = properties.getString("Name", null);
            String host = properties.getString("Host", null);
            int port = properties.getInt("Port", 0);
            if (dbType != null && name != null) {
                BSimServerInfo info = new BSimServerInfo(dbType, host, port, name);
                return info;
            }
            Msg.showError((Object)this, null, (String)"Error reading Bsim Server File", (Object)("Bad BSim Server Info in file " + file.toString()));
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Error Reading BSim Server File", (Object)("Error processing Bsim Server info file: " + file.toString()));
        }
        return null;
    }

    private boolean saveBSimServerInfo(BSimServerInfo info) {
        GProperties properties = new GProperties("BSimServerInfo");
        properties.putString("DBType", info.getDBType().name());
        properties.putString("Name", info.getDBName());
        properties.putString("Host", info.getServerName());
        properties.putInt("Port", info.getPort());
        File settingsDir = Application.getUserSettingsDirectory();
        File serversDir = new File(settingsDir, "bsim");
        int hash = info.hashCode();
        File serverFile = new File(serversDir, "bsim" + hash + ".server.properties");
        try {
            properties.saveToJsonFile(serverFile);
            return true;
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Error Saving", (Object)("Error saving Bsim Server Info to file " + serverFile.getAbsolutePath()), (Throwable)e);
            return false;
        }
    }

    private boolean removeServerFileFromSettings(BSimServerInfo info) {
        File settingsDir = Application.getUserSettingsDirectory();
        File serversDir = new File(settingsDir, "bsim");
        int hash = info.hashCode();
        File serverFile = new File(serversDir, "bsim" + hash + ".server.properties");
        return serverFile.delete();
    }

    public void addServer(BSimServerInfo newServerInfo) {
        if (this.saveBSimServerInfo(newServerInfo)) {
            this.serverInfos.add(newServerInfo);
            this.notifyServerListChanged();
        }
    }

    public boolean removeServer(BSimServerInfo info, boolean force) {
        BSimPostgresDBConnectionManager.BSimPostgresDataSource ds;
        int active;
        BSimServerInfo.DBType dbType = info.getDBType();
        if (dbType == BSimServerInfo.DBType.file) {
            BSimH2FileDBConnectionManager.BSimH2FileDataSource ds2 = BSimH2FileDBConnectionManager.getDataSource(info);
            int active2 = ds2.getActiveConnections();
            if (active2 != 0) {
                if (!force) {
                    return false;
                }
                ds2.dispose();
            }
        } else if (dbType == BSimServerInfo.DBType.postgres && (active = (ds = BSimPostgresDBConnectionManager.getDataSource(info)).getActiveConnections()) != 0) {
            if (!force) {
                return false;
            }
            ds.dispose();
        }
        if (this.serverInfos.remove(info)) {
            this.removeServerFileFromSettings(info);
            this.notifyServerListChanged();
        }
        return true;
    }

    public void addListener(BSimServerManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BSimServerManagerListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyServerListChanged() {
        Swing.runLater(() -> {
            for (BSimServerManagerListener listener : this.listeners) {
                listener.serverListChanged();
            }
        });
    }

    public static int getActiveConnections(BSimServerInfo serverInfo) {
        switch (serverInfo.getDBType()) {
            case postgres: {
                BSimPostgresDBConnectionManager.BSimPostgresDataSource postgresDs = BSimPostgresDBConnectionManager.getDataSourceIfExists(serverInfo);
                if (postgresDs == null) break;
                return postgresDs.getActiveConnections();
            }
            case file: {
                BSimH2FileDBConnectionManager.BSimH2FileDataSource h2FileDs = BSimH2FileDBConnectionManager.getDataSourceIfExists(serverInfo);
                if (h2FileDs == null) break;
                return h2FileDs.getActiveConnections();
            }
        }
        return -1;
    }
}

