/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.client.CancelledSQLException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskBuilder;
import ghidra.util.task.TaskMonitor;
import java.sql.Connection;
import java.sql.SQLException;

public class BSimDBConnectTaskCoordinator {
    private final BSimServerInfo serverInfo;
    private Exception exc = null;
    private boolean isCancelled = false;
    private int count = 0;

    public BSimDBConnectTaskCoordinator(BSimServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    private void clear() {
        this.exc = null;
        this.isCancelled = false;
        this.count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(DBConnectionSupplier connectionSupplier) throws SQLException {
        DBConnectTask connectTask = new DBConnectTask(connectionSupplier);
        try {
            TaskBuilder.withTask((Task)connectTask).setTitle("BSim DB Connection...").setCanCancel(false).setHasProgress(false).launchModal();
            BSimDBConnectTaskCoordinator bSimDBConnectTaskCoordinator = this;
            synchronized (bSimDBConnectTaskCoordinator) {
                block18: {
                    Connection c = connectTask.getConnection();
                    if (c == null) break block18;
                    Connection connection = c;
                    return connection;
                }
                if (this.isCancelled) {
                    throw new CancelledSQLException("Password entry was cancelled");
                }
                Exception exception = this.exc;
                if (exception instanceof SQLException) {
                    SQLException e = (SQLException)exception;
                    throw e;
                }
                exception = this.exc;
                if (exception instanceof RuntimeException) {
                    RuntimeException e = (RuntimeException)exception;
                    throw e;
                }
                throw new RuntimeException(this.exc);
            }
        }
        finally {
            BSimDBConnectTaskCoordinator bSimDBConnectTaskCoordinator = this;
            synchronized (bSimDBConnectTaskCoordinator) {
                if (--this.count == 0) {
                    this.clear();
                }
            }
        }
    }

    private class DBConnectTask
    extends Task {
        private Connection c;
        private DBConnectionSupplier connectionSupplier;

        DBConnectTask(DBConnectionSupplier connectionSupplier) {
            super("BSim Connecting to " + BSimDBConnectTaskCoordinator.this.serverInfo, false, false, true);
            this.connectionSupplier = connectionSupplier;
        }

        Connection getConnection() {
            return this.c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) throws CancelledException {
            BSimDBConnectTaskCoordinator bSimDBConnectTaskCoordinator = BSimDBConnectTaskCoordinator.this;
            synchronized (bSimDBConnectTaskCoordinator) {
                monitor.setMessage("Connecting...");
                ++BSimDBConnectTaskCoordinator.this.count;
                if (BSimDBConnectTaskCoordinator.this.isCancelled) {
                    throw new CancelledException();
                }
                if (BSimDBConnectTaskCoordinator.this.exc != null) {
                    return;
                }
                try {
                    this.c = this.connectionSupplier.get();
                }
                catch (CancelledException e) {
                    BSimDBConnectTaskCoordinator.this.isCancelled = true;
                    throw e;
                }
                catch (Exception e) {
                    BSimDBConnectTaskCoordinator.this.exc = e;
                }
            }
        }
    }

    public static interface DBConnectionSupplier {
        public Connection get() throws CancelledException, SQLException;
    }
}

